/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.impl;

import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.Variable;
import io.activej.serializer.AbstractSerializerDef;
import io.activej.serializer.CompatibilityLevel;
import io.activej.serializer.SerializerDef;
import io.activej.serializer.impl.SerializerDefNullable;
import io.activej.serializer.impl.SerializerDefWithNullable;
import io.activej.serializer.impl.SerializerExpressions;
import io.activej.serializer.util.Utils;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;

public final class SerializerDefSubclass
extends AbstractSerializerDef
implements SerializerDefWithNullable {
    private final Class<?> dataType;
    private final LinkedHashMap<Class<?>, SerializerDef> subclassSerializers;
    private final boolean nullable;
    private final int startIndex;

    public SerializerDefSubclass(@NotNull Class<?> dataType, LinkedHashMap<Class<?>, SerializerDef> subclassSerializers, int startIndex) {
        SerializerDefSubclass.checkSubclasses(subclassSerializers.keySet());
        this.startIndex = startIndex;
        this.dataType = dataType;
        this.subclassSerializers = new LinkedHashMap(subclassSerializers);
        this.nullable = false;
    }

    private SerializerDefSubclass(@NotNull Class<?> dataType, LinkedHashMap<Class<?>, SerializerDef> subclassSerializers, boolean nullable, int startIndex) {
        SerializerDefSubclass.checkSubclasses(subclassSerializers.keySet());
        this.startIndex = startIndex;
        this.dataType = dataType;
        this.subclassSerializers = new LinkedHashMap(subclassSerializers);
        this.nullable = nullable;
    }

    @Override
    public SerializerDef ensureNullable(CompatibilityLevel compatibilityLevel) {
        if (compatibilityLevel.getLevel() < CompatibilityLevel.LEVEL_3.getLevel()) {
            return new SerializerDefNullable(this);
        }
        return new SerializerDefSubclass(this.dataType, this.subclassSerializers, true, this.startIndex);
    }

    @Override
    public void accept(SerializerDef.Visitor visitor) {
        for (Map.Entry<Class<?>, SerializerDef> entry : this.subclassSerializers.entrySet()) {
            visitor.visit(entry.getKey().getName(), entry.getValue());
        }
    }

    @Override
    public boolean isInline(int version, CompatibilityLevel compatibilityLevel) {
        return false;
    }

    @Override
    public Class<?> getEncodeType() {
        return this.dataType;
    }

    @Override
    public Expression encoder(SerializerDef.StaticEncoders staticEncoders, Expression buf, Variable pos, Expression value, int version, CompatibilityLevel compatibilityLevel) {
        int subClassIndex = this.nullable && this.startIndex == 0 ? 1 : this.startIndex;
        ArrayList<Expression> listKey = new ArrayList<Expression>();
        ArrayList<Expression> listValue = new ArrayList<Expression>();
        for (Map.Entry<Class<?>, SerializerDef> entry : this.subclassSerializers.entrySet()) {
            SerializerDef subclassSerializer = entry.getValue();
            listKey.add(Expressions.cast((Expression)Expressions.value((Object)Type.getType(entry.getKey())), Object.class));
            listValue.add(Expressions.sequence((Expression[])new Expression[]{SerializerExpressions.writeByte(buf, pos, Expressions.value((Object)((byte)subClassIndex))), subclassSerializer.defineEncoder(staticEncoders, buf, pos, Expressions.cast((Expression)value, subclassSerializer.getEncodeType()), version, compatibilityLevel)}));
            if (!this.nullable || ++subClassIndex != 0) continue;
            ++subClassIndex;
        }
        if (this.nullable) {
            return Expressions.ifThenElse((Expression)Expressions.isNotNull((Expression)value), (Expression)Expressions.switchByKey((Expression)Expressions.call((Expression)value, (String)"getClass", (Expression[])new Expression[0]), listKey, listValue), (Expression)SerializerExpressions.writeByte(buf, pos, Expressions.value((Object)0)));
        }
        return Expressions.switchByKey((Expression)Expressions.call((Expression)value, (String)"getClass", (Expression[])new Expression[0]), listKey, listValue);
    }

    @Override
    public Expression decoder(SerializerDef.StaticDecoders staticDecoders, Expression in, int version, CompatibilityLevel compatibilityLevel) {
        return Expressions.let((Expression)(this.startIndex != 0 ? Expressions.sub((Expression)SerializerExpressions.readByte(in), (Expression)Expressions.value((Object)this.startIndex)) : Expressions.cast((Expression)SerializerExpressions.readByte(in), Integer.TYPE)), idx -> Expressions.cast((Expression)Expressions.switchByIndex((Expression)idx, (List)Utils.get(() -> {
            ArrayList<Expression> versions = new ArrayList<Expression>();
            for (SerializerDef subclassSerializer : this.subclassSerializers.values()) {
                versions.add(Expressions.cast((Expression)subclassSerializer.defineDecoder(staticDecoders, in, version, compatibilityLevel), this.dataType));
            }
            if (this.nullable) {
                versions.add(-this.startIndex, Expressions.nullRef(this.getDecodeType()));
            }
            return versions;
        })), this.dataType));
    }

    private static void checkSubclasses(Set<Class<?>> subclasses) {
        for (Class<?> subclass : subclasses) {
            if (!Modifier.isAbstract(subclass.getModifiers())) continue;
            throw new IllegalArgumentException("A subclass should not be an " + (subclass.isInterface() ? "interface" : "abstract class") + ": " + subclass);
        }
    }
}

