/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer;

import io.activej.serializer.CorruptedDataException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BinaryInput {
    public final byte[] array;
    public int pos;
    private static final AtomicReference<char[]> BUF = new AtomicReference<char[]>(new char[256]);

    public BinaryInput(byte[] array) {
        this.array = array;
    }

    public BinaryInput(byte[] array, int pos) {
        this.array = array;
        this.pos = pos;
    }

    public byte[] array() {
        return this.array;
    }

    public int pos() {
        return this.pos;
    }

    public void pos(int pos) {
        this.pos = pos;
    }

    public void move(int delta) {
        this.pos += delta;
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) {
        System.arraycopy(this.array, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    public byte readByte() {
        return this.array[this.pos++];
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public short readShort() {
        short result = (short)((this.array[this.pos] & 0xFF) << 8 | this.array[this.pos + 1] & 0xFF);
        this.pos += 2;
        return result;
    }

    public short readShortLE() {
        short result = (short)(this.array[this.pos] & 0xFF | (this.array[this.pos + 1] & 0xFF) << 8);
        this.pos += 2;
        return result;
    }

    public char readChar() {
        char c = (char)((this.array[this.pos] & 0xFF) << 8 | this.array[this.pos + 1] & 0xFF);
        this.pos += 2;
        return c;
    }

    public char readCharLE() {
        char c = (char)(this.array[this.pos] & 0xFF | (this.array[this.pos + 1] & 0xFF) << 8);
        this.pos += 2;
        return c;
    }

    public int readInt() {
        int result = 0 | (0 | (this.array[this.pos] & 0xFF) << 24 | (this.array[this.pos + 1] & 0xFF) << 16) | (0 | (this.array[this.pos + 2] & 0xFF) << 8 | this.array[this.pos + 3] & 0xFF);
        this.pos += 4;
        return result;
    }

    public int readIntLE() {
        int result = 0 | (0 | this.array[this.pos] & 0xFF | (this.array[this.pos + 1] & 0xFF) << 8) | (0 | (this.array[this.pos + 2] & 0xFF) << 16 | (this.array[this.pos + 3] & 0xFF) << 24);
        this.pos += 4;
        return result;
    }

    public long readLong() {
        long result = 0L | (0L | (0L | (long)(this.array[this.pos] & 0xFF) << 56 | (long)(this.array[this.pos + 1] & 0xFF) << 48) | (0L | (long)(this.array[this.pos + 2] & 0xFF) << 40 | (long)(this.array[this.pos + 3] & 0xFF) << 32)) | (0L | (0L | (long)(this.array[this.pos + 4] & 0xFF) << 24 | (long)((this.array[this.pos + 5] & 0xFF) << 16)) | (long)(0 | (this.array[this.pos + 6] & 0xFF) << 8 | this.array[this.pos + 7] & 0xFF));
        this.pos += 8;
        return result;
    }

    public long readLongLE() {
        long result = 0L | ((long)(0 | (0 | this.array[this.pos] & 0xFF | (this.array[this.pos + 1] & 0xFF) << 8)) | ((long)(0 | (this.array[this.pos + 2] & 0xFF) << 16) | (long)(this.array[this.pos + 3] & 0xFF) << 24)) | (0L | (0L | (long)(this.array[this.pos + 4] & 0xFF) << 32 | (long)(this.array[this.pos + 5] & 0xFF) << 40) | (0L | (long)(this.array[this.pos + 6] & 0xFF) << 48 | (long)(this.array[this.pos + 7] & 0xFF) << 56));
        this.pos += 8;
        return result;
    }

    public int readVarInt() {
        byte b = this.array[this.pos];
        if (b >= 0) {
            ++this.pos;
            return b;
        }
        int result = b & 0x7F;
        b = this.array[this.pos + 1];
        if (b >= 0) {
            this.pos += 2;
            return result | b << 7;
        }
        result |= (b & 0x7F) << 7;
        b = this.array[this.pos + 2];
        if (b >= 0) {
            this.pos += 3;
            return result | b << 14;
        }
        result |= (b & 0x7F) << 14;
        b = this.array[this.pos + 3];
        if (b >= 0) {
            this.pos += 4;
            return result | b << 21;
        }
        result = result | (b & 0x7F) << 21 | this.array[this.pos + 4] << 28;
        this.pos += 5;
        return result;
    }

    public long readVarLong() {
        byte b;
        if ((b = this.array[this.pos++]) >= 0) {
            return b;
        }
        long result = b & 0x7F;
        for (int offset = 7; offset < 64; offset += 7) {
            if ((b = this.array[this.pos++]) >= 0) {
                return result | (long)b << offset;
            }
            result |= (long)(b & 0x7F) << offset;
        }
        throw new CorruptedDataException("Read varlong was too long");
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @NotNull
    public String readUTF8() {
        int length = this.readVarInt();
        String s = new String(this.array, this.pos, length, StandardCharsets.UTF_8);
        this.pos += length;
        return s;
    }

    @Nullable
    public String readUTF8Nullable() {
        int length = this.readVarInt();
        if (length == 0) {
            return null;
        }
        String s = new String(this.array, this.pos, --length, StandardCharsets.UTF_8);
        this.pos += length;
        return s;
    }

    @NotNull
    public String readIso88591() {
        int length = this.readVarInt();
        String s = new String(this.array, this.pos, length, StandardCharsets.ISO_8859_1);
        this.pos += length;
        return s;
    }

    @Nullable
    public String readIso88591Nullable() {
        int length = this.readVarInt();
        if (length == 0) {
            return null;
        }
        String s = new String(this.array, this.pos, --length, StandardCharsets.ISO_8859_1);
        this.pos += length;
        return s;
    }

    @NotNull
    public String readUTF16() {
        int length = this.readVarInt();
        if (length == 0) {
            return "";
        }
        if (length >= 40) {
            return this.readUTF16buf(length);
        }
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)((this.array[this.pos + i * 2] & 0xFF) << 8 | this.array[this.pos + i * 2 + 1] & 0xFF);
        }
        this.pos += length * 2;
        return new String(chars, 0, length);
    }

    @NotNull
    public String readUTF16LE() {
        int length = this.readVarInt();
        if (length == 0) {
            return "";
        }
        if (length >= 40) {
            return this.readUTF16LEbuf(length);
        }
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(this.array[this.pos + i * 2] & 0xFF | (this.array[this.pos + i * 2 + 1] & 0xFF) << 8);
        }
        this.pos += length * 2;
        return new String(chars, 0, length);
    }

    @Nullable
    public String readUTF16Nullable() {
        int length = this.readVarInt();
        if (length == 0) {
            return null;
        }
        if (--length == 0) {
            return "";
        }
        if (length >= 40) {
            return this.readUTF16buf(length);
        }
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)((this.array[this.pos + i * 2] & 0xFF) << 8 | this.array[this.pos + i * 2 + 1] & 0xFF);
        }
        this.pos += length * 2;
        return new String(chars, 0, length);
    }

    @Nullable
    public String readUTF16NullableLE() {
        int length = this.readVarInt();
        if (length == 0) {
            return null;
        }
        if (--length == 0) {
            return "";
        }
        if (length >= 40) {
            return this.readUTF16LEbuf(length);
        }
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(this.array[this.pos + i * 2] & 0xFF | (this.array[this.pos + i * 2 + 1] & 0xFF) << 8);
        }
        this.pos += length * 2;
        return new String(chars, 0, length);
    }

    @NotNull
    private String readUTF16buf(int length) {
        char[] chars = BUF.getAndSet(null);
        if (chars == null || chars.length < length) {
            chars = new char[length + length / 4];
        }
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)((this.array[this.pos + i * 2] & 0xFF) << 8 | this.array[this.pos + i * 2 + 1] & 0xFF);
        }
        this.pos += length * 2;
        String s = new String(chars, 0, length);
        BUF.lazySet(chars);
        return s;
    }

    @NotNull
    private String readUTF16LEbuf(int length) {
        char[] chars = BUF.getAndSet(null);
        if (chars == null || chars.length < length) {
            chars = new char[length + length / 4];
        }
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(this.array[this.pos + i * 2] & 0xFF | (this.array[this.pos + i * 2 + 1] & 0xFF) << 8);
        }
        this.pos += length * 2;
        String s = new String(chars, 0, length);
        BUF.lazySet(chars);
        return s;
    }

    @Deprecated
    @NotNull
    public String readUTF8mb3() {
        int length = this.readVarInt();
        if (length == 0) {
            return "";
        }
        if (length >= 40) {
            return this.readUTF8mb3buf(length);
        }
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            byte b;
            chars[i] = (b = this.array[this.pos++]) >= 0 ? (char)b : this.readUTF8mb3Char(b);
        }
        return new String(chars, 0, length);
    }

    @Deprecated
    @Nullable
    public String readUTF8mb3Nullable() {
        int length = this.readVarInt();
        if (length == 0) {
            return null;
        }
        if (--length == 0) {
            return "";
        }
        if (length >= 40) {
            return this.readUTF8mb3buf(length);
        }
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            byte b;
            chars[i] = (b = this.array[this.pos++]) >= 0 ? (char)b : this.readUTF8mb3Char(b);
        }
        return new String(chars, 0, length);
    }

    @Deprecated
    private char readUTF8mb3Char(byte b) {
        int c = b & 0xFF;
        if (c < 224) {
            return (char)((c & 0x1F) << 6 | this.array[this.pos++] & 0x3F);
        }
        return (char)((c & 0xF) << 12 | (this.array[this.pos++] & 0x3F) << 6 | this.array[this.pos++] & 0x3F);
    }

    @Deprecated
    @NotNull
    private String readUTF8mb3buf(int length) {
        char[] chars = BUF.getAndSet(null);
        if (chars == null || chars.length < length) {
            chars = new char[length + length / 4];
        }
        for (int i = 0; i < length; ++i) {
            byte b;
            chars[i] = (b = this.array[this.pos++]) >= 0 ? (char)b : this.readUTF8mb3Char(b);
        }
        String s = new String(chars, 0, length);
        BUF.lazySet(chars);
        return s;
    }
}

