/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer;

import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.StoreDef;
import io.activej.codegen.expression.Variable;
import io.activej.serializer.AbstractSerializerDef;
import io.activej.serializer.BinarySerializer;
import io.activej.serializer.CompatibilityLevel;
import io.activej.serializer.SerializerDef;
import io.activej.types.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class SimpleSerializerDef<T>
extends AbstractSerializerDef {
    private final Map<CacheKey, Expression> SERIALIZER_EXPRESSION_CACHE = new HashMap<CacheKey, Expression>();
    private final Class<T> encodeType = Types.getRawType((Type)SimpleSerializerDef.getSuperclassTypeParameter(this.getClass()));

    protected SimpleSerializerDef() {
    }

    protected abstract BinarySerializer<T> createSerializer(int var1, CompatibilityLevel var2);

    public final Class<T> getEncodeType() {
        return this.encodeType;
    }

    @Override
    public final Expression encoder(SerializerDef.StaticEncoders staticEncoders, Expression buf, Variable pos, Expression value, int version, CompatibilityLevel compatibilityLevel) {
        Expression serializer = this.ensureSerializerExpression(version, compatibilityLevel);
        return Expressions.set((StoreDef)pos, (Expression)Expressions.call((Expression)serializer, (String)"encode", (Expression[])new Expression[]{buf, pos, value}));
    }

    @Override
    public final Expression decoder(SerializerDef.StaticDecoders staticDecoders, Expression in, int version, CompatibilityLevel compatibilityLevel) {
        Expression serializer = this.ensureSerializerExpression(version, compatibilityLevel);
        return Expressions.call((Expression)serializer, (String)"decode", (Expression[])new Expression[]{in});
    }

    @NotNull
    private static Type getSuperclassTypeParameter(@NotNull Class<?> subclass) {
        Type superclass = subclass.getGenericSuperclass();
        if (superclass instanceof ParameterizedType) {
            return ((ParameterizedType)superclass).getActualTypeArguments()[0];
        }
        throw new AssertionError();
    }

    private synchronized Expression ensureSerializerExpression(int version, CompatibilityLevel compatibilityLevel) {
        CacheKey cacheKey = new CacheKey(version, compatibilityLevel);
        return this.SERIALIZER_EXPRESSION_CACHE.computeIfAbsent(cacheKey, $ -> Expressions.value(this.createSerializer(version, compatibilityLevel), BinarySerializer.class));
    }

    private static final class CacheKey {
        private final int version;
        private final CompatibilityLevel level;

        private CacheKey(int version, CompatibilityLevel level) {
            this.version = version;
            this.level = level;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.version == cacheKey.version && this.level == cacheKey.level;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.version, this.level});
        }
    }
}

