/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.impl;

import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.Variable;
import io.activej.serializer.AbstractSerializerDef;
import io.activej.serializer.CompatibilityLevel;
import io.activej.serializer.SerializerDef;
import io.activej.serializer.impl.SerializerDefNullable;
import io.activej.serializer.impl.SerializerDefWithNullable;
import io.activej.serializer.impl.SerializerExpressions;

public final class SerializerDefEnum
extends AbstractSerializerDef
implements SerializerDefWithNullable {
    private final Class<? extends Enum<?>> enumType;
    private final boolean nullable;

    public SerializerDefEnum(Class<? extends Enum<?>> enumType, boolean nullable) {
        this.enumType = enumType;
        this.nullable = nullable;
    }

    public SerializerDefEnum(Class<? extends Enum<?>> enumType) {
        this(enumType, false);
    }

    @Override
    public Class<?> getEncodeType() {
        return this.enumType;
    }

    @Override
    public Expression encoder(SerializerDef.StaticEncoders staticEncoders, Expression buf, Variable pos, Expression value, int version, CompatibilityLevel compatibilityLevel) {
        Expression ordinal = Expressions.call((Expression)Expressions.cast((Expression)value, Enum.class), (String)"ordinal", (Expression[])new Expression[0]);
        if (this.isSmallEnum()) {
            return !this.nullable ? SerializerExpressions.writeByte(buf, pos, Expressions.cast((Expression)ordinal, Byte.TYPE)) : Expressions.ifThenElse((Expression)Expressions.isNull((Expression)value), (Expression)SerializerExpressions.writeByte(buf, pos, Expressions.value((Object)0)), (Expression)SerializerExpressions.writeByte(buf, pos, Expressions.cast((Expression)Expressions.add((Expression)ordinal, (Expression)Expressions.value((Object)1)), Byte.TYPE)));
        }
        return !this.nullable ? SerializerExpressions.writeVarInt(buf, pos, ordinal) : Expressions.ifThenElse((Expression)Expressions.isNull((Expression)value), (Expression)SerializerExpressions.writeByte(buf, pos, Expressions.value((Object)0)), (Expression)SerializerExpressions.writeVarInt(buf, pos, Expressions.add((Expression)ordinal, (Expression)Expressions.value((Object)1))));
    }

    @Override
    public Expression decoder(SerializerDef.StaticDecoders staticDecoders, Expression in, int version, CompatibilityLevel compatibilityLevel) {
        return this.isSmallEnum() ? Expressions.let((Expression)SerializerExpressions.readByte(in), b -> !this.nullable ? Expressions.arrayGet((Expression)Expressions.staticCall(this.enumType, (String)"values", (Expression[])new Expression[0]), (Expression)b) : Expressions.ifThenElse((Expression)Expressions.cmpEq((Expression)b, (Expression)Expressions.value((Object)0)), (Expression)Expressions.nullRef(this.enumType), (Expression)Expressions.arrayGet((Expression)Expressions.staticCall(this.enumType, (String)"values", (Expression[])new Expression[0]), (Expression)Expressions.dec((Expression)b)))) : Expressions.let((Expression)SerializerExpressions.readVarInt(in), value -> !this.nullable ? Expressions.arrayGet((Expression)Expressions.staticCall(this.enumType, (String)"values", (Expression[])new Expression[0]), (Expression)value) : Expressions.ifThenElse((Expression)Expressions.cmpEq((Expression)value, (Expression)Expressions.value((Object)0)), (Expression)Expressions.nullRef(this.enumType), (Expression)Expressions.arrayGet((Expression)Expressions.staticCall(this.enumType, (String)"values", (Expression[])new Expression[0]), (Expression)Expressions.dec((Expression)value))));
    }

    private boolean isSmallEnum() {
        int size = this.enumType.getEnumConstants().length + (this.nullable ? 1 : 0);
        if (size >= 16384) {
            throw new IllegalArgumentException();
        }
        return size <= 127;
    }

    @Override
    public SerializerDef ensureNullable(CompatibilityLevel compatibilityLevel) {
        if (compatibilityLevel.getLevel() < CompatibilityLevel.LEVEL_3.getLevel()) {
            return new SerializerDefNullable(this);
        }
        return new SerializerDefEnum(this.enumType, true);
    }
}

