/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.impl;

import io.activej.serializer.BinaryInput;
import io.activej.serializer.BinaryOutput;
import io.activej.serializer.BinarySerializer;
import io.activej.serializer.CompatibilityLevel;
import io.activej.serializer.CorruptedDataException;
import io.activej.serializer.SimpleSerializerDef;
import java.net.Inet6Address;
import java.net.UnknownHostException;

public final class SerializerDefInet6Address
extends SimpleSerializerDef<Inet6Address> {
    @Override
    protected BinarySerializer<Inet6Address> createSerializer(int version, CompatibilityLevel compatibilityLevel) {
        return new BinarySerializer<Inet6Address>(){

            @Override
            public void encode(BinaryOutput out, Inet6Address address) {
                out.write(address.getAddress());
            }

            @Override
            public Inet6Address decode(BinaryInput in) throws CorruptedDataException {
                byte[] addressBytes = new byte[16];
                in.read(addressBytes);
                try {
                    return Inet6Address.getByAddress(null, addressBytes, null);
                }
                catch (UnknownHostException e) {
                    throw new CorruptedDataException(e.getMessage());
                }
            }
        };
    }
}

