/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.impl;

import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.Variable;
import io.activej.serializer.CompatibilityLevel;
import io.activej.serializer.SerializerDef;
import io.activej.serializer.impl.SerializerDefPrimitive;
import io.activej.serializer.impl.SerializerDefWithVarLength;
import io.activej.serializer.impl.SerializerExpressions;

public final class SerializerDefInt
extends SerializerDefPrimitive
implements SerializerDefWithVarLength {
    private final boolean varLength;

    public SerializerDefInt() {
        this(true, false);
    }

    public SerializerDefInt(boolean wrapped) {
        this(wrapped, false);
    }

    public SerializerDefInt(boolean wrapped, boolean varLength) {
        super(Integer.TYPE, wrapped);
        this.varLength = varLength;
    }

    @Override
    public SerializerDef ensureWrapped() {
        return new SerializerDefInt(true, this.varLength);
    }

    @Override
    protected Expression doSerialize(Expression byteArray, Variable off, Expression value, CompatibilityLevel compatibilityLevel) {
        return this.varLength ? SerializerExpressions.writeVarInt(byteArray, off, Expressions.cast((Expression)value, Integer.TYPE)) : SerializerExpressions.writeInt(byteArray, off, Expressions.cast((Expression)value, Integer.TYPE), !compatibilityLevel.isLittleEndian());
    }

    @Override
    protected Expression doDeserialize(Expression in, CompatibilityLevel compatibilityLevel) {
        return this.varLength ? SerializerExpressions.readVarInt(in) : SerializerExpressions.readInt(in, !compatibilityLevel.isLittleEndian());
    }

    @Override
    public SerializerDef ensureVarLength() {
        return new SerializerDefInt(this.wrapped, true);
    }
}

