/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.impl;

import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Variable;
import io.activej.serializer.CompatibilityLevel;
import io.activej.serializer.SerializerDef;
import io.activej.serializer.impl.SerializerDefPrimitive;
import io.activej.serializer.impl.SerializerDefWithVarLength;
import io.activej.serializer.impl.SerializerExpressions;

public final class SerializerDefLong
extends SerializerDefPrimitive
implements SerializerDefWithVarLength {
    private final boolean varLength;

    public SerializerDefLong() {
        this(true, false);
    }

    public SerializerDefLong(boolean wrapped) {
        this(wrapped, false);
    }

    public SerializerDefLong(boolean wrapped, boolean varLength) {
        super(Long.TYPE, wrapped);
        this.varLength = varLength;
    }

    @Override
    public SerializerDef ensureWrapped() {
        return new SerializerDefLong(true, this.varLength);
    }

    @Override
    protected Expression doSerialize(Expression byteArray, Variable off, Expression value, CompatibilityLevel compatibilityLevel) {
        return this.varLength ? SerializerExpressions.writeVarLong(byteArray, off, value) : SerializerExpressions.writeLong(byteArray, off, value, !compatibilityLevel.isLittleEndian());
    }

    @Override
    protected Expression doDeserialize(Expression in, CompatibilityLevel compatibilityLevel) {
        return this.varLength ? SerializerExpressions.readVarLong(in) : SerializerExpressions.readLong(in, !compatibilityLevel.isLittleEndian());
    }

    @Override
    public SerializerDef ensureVarLength() {
        return new SerializerDefLong(this.wrapped, true);
    }
}

