/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.impl;

import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.Variable;
import io.activej.codegen.util.Primitives;
import io.activej.serializer.AbstractSerializerDef;
import io.activej.serializer.CompatibilityLevel;
import io.activej.serializer.SerializerDef;

public abstract class SerializerDefPrimitive
extends AbstractSerializerDef
implements SerializerDef {
    protected final Class<?> primitiveType;
    protected final Class<?> wrappedType;
    protected final boolean wrapped;

    protected SerializerDefPrimitive(Class<?> primitiveType, boolean wrapped) {
        if (!primitiveType.isPrimitive()) {
            throw new IllegalArgumentException("Not a primitive type");
        }
        this.primitiveType = primitiveType;
        this.wrappedType = Primitives.wrap(primitiveType);
        this.wrapped = wrapped;
    }

    @Override
    public Class<?> getEncodeType() {
        return this.wrapped ? this.wrappedType : this.primitiveType;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public abstract SerializerDef ensureWrapped();

    protected abstract Expression doSerialize(Expression var1, Variable var2, Expression var3, CompatibilityLevel var4);

    protected abstract Expression doDeserialize(Expression var1, CompatibilityLevel var2);

    protected boolean castToPrimitive() {
        return true;
    }

    @Override
    public final Expression encoder(SerializerDef.StaticEncoders staticEncoders, Expression buf, Variable pos, Expression value, int version, CompatibilityLevel compatibilityLevel) {
        return this.doSerialize(buf, pos, this.castToPrimitive() ? Expressions.cast((Expression)value, this.primitiveType) : value, compatibilityLevel);
    }

    @Override
    public final Expression decoder(SerializerDef.StaticDecoders staticDecoders, Expression in, int version, CompatibilityLevel compatibilityLevel) {
        Expression expression = this.doDeserialize(in, compatibilityLevel);
        return this.wrapped ? Expressions.cast((Expression)expression, this.wrappedType) : expression;
    }
}

