/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.impl;

import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.StoreDef;
import io.activej.codegen.expression.Variable;
import io.activej.serializer.util.BinaryOutputUtils;
import org.jetbrains.annotations.NotNull;

public final class SerializerExpressions {
    private static final Class<?> JDK_UNSAFE;
    private static final int BYTE_ARRAY_BASE_OFFSET;
    private static final boolean BIG_ENDIAN;

    @NotNull
    private static Expression getUnsafe() {
        return Expressions.staticCall(JDK_UNSAFE, (String)"getUnsafe", (Expression[])new Expression[0]);
    }

    public static Expression writeBytes(Expression buf, Variable pos, Expression bytes) {
        return SerializerExpressions.writeBytes(buf, pos, bytes, Expressions.value((Object)0), Expressions.length((Expression)bytes));
    }

    public static Expression writeBytes(Expression buf, Variable pos, Expression bytes, Expression bytesOff, Expression bytesLen) {
        return Expressions.sequence((Expression[])new Expression[]{Expressions.staticCall(System.class, (String)"arraycopy", (Expression[])new Expression[]{bytes, bytesOff, buf, pos, bytesLen}), Expressions.set((StoreDef)pos, (Expression)Expressions.add((Expression)pos, (Expression)bytesLen))});
    }

    public static Expression writeByte(Expression buf, Variable pos, Expression value) {
        return Expressions.sequence((Expression[])new Expression[]{Expressions.arraySet((Expression)buf, (Expression)pos, (Expression)value), Expressions.set((StoreDef)pos, (Expression)Expressions.add((Expression)pos, (Expression)Expressions.value((Object)1)))});
    }

    public static Expression writeBoolean(Expression buf, Variable pos, Expression value) {
        return SerializerExpressions.writeByte(buf, pos, value);
    }

    public static Expression writeShort(Expression buf, Variable pos, Expression value, boolean bigEndian) {
        return JDK_UNSAFE != null ? SerializerExpressions.putUnaligned(buf, pos, value, "putShortUnaligned", Short.class, 2, bigEndian) : Expressions.set((StoreDef)pos, (Expression)Expressions.staticCall(BinaryOutputUtils.class, (String)("writeShort" + (bigEndian ? "" : "LE")), (Expression[])new Expression[]{buf, pos, Expressions.cast((Expression)value, Short.TYPE)}));
    }

    public static Expression writeChar(Expression buf, Variable pos, Expression value, boolean bigEndian) {
        return JDK_UNSAFE != null ? SerializerExpressions.putUnaligned(buf, pos, value, "putCharUnaligned", Character.class, 2, bigEndian) : Expressions.set((StoreDef)pos, (Expression)Expressions.staticCall(BinaryOutputUtils.class, (String)("writeChar" + (bigEndian ? "" : "LE")), (Expression[])new Expression[]{buf, pos, Expressions.cast((Expression)value, Character.TYPE)}));
    }

    public static Expression writeInt(Expression buf, Variable pos, Expression value, boolean bigEndian) {
        return JDK_UNSAFE != null ? SerializerExpressions.putUnaligned(buf, pos, value, "putIntUnaligned", Integer.class, 4, bigEndian) : Expressions.set((StoreDef)pos, (Expression)Expressions.staticCall(BinaryOutputUtils.class, (String)("writeInt" + (bigEndian ? "" : "LE")), (Expression[])new Expression[]{buf, pos, Expressions.cast((Expression)value, Integer.TYPE)}));
    }

    public static Expression writeLong(Expression buf, Variable pos, Expression value, boolean bigEndian) {
        return JDK_UNSAFE != null ? SerializerExpressions.putUnaligned(buf, pos, value, "putLongUnaligned", Long.class, 8, bigEndian) : Expressions.set((StoreDef)pos, (Expression)Expressions.staticCall(BinaryOutputUtils.class, (String)("writeLong" + (bigEndian ? "" : "LE")), (Expression[])new Expression[]{buf, pos, Expressions.cast((Expression)value, Long.TYPE)}));
    }

    private static Expression putUnaligned(Expression buf, Variable pos, Expression value, String name, Class<?> numericType, int size, boolean bigEndian) {
        return SerializerExpressions.ensureRemaining(buf, pos, size, Expressions.sequence((Expression[])new Expression[]{Expressions.call((Expression)SerializerExpressions.getUnsafe(), (String)name, (Expression[])new Expression[]{buf, Expressions.cast((Expression)Expressions.add((Expression)Expressions.value((Object)BYTE_ARRAY_BASE_OFFSET), (Expression)pos), Long.TYPE), SerializerExpressions.convEndian(value, numericType, bigEndian)}), Expressions.set((StoreDef)pos, (Expression)Expressions.add((Expression)pos, (Expression)Expressions.value((Object)size)))}));
    }

    public static Expression writeVarInt(Expression buf, Variable pos, Expression value) {
        return Expressions.set((StoreDef)pos, (Expression)Expressions.staticCall(BinaryOutputUtils.class, (String)"writeVarInt", (Expression[])new Expression[]{buf, pos, Expressions.cast((Expression)value, Integer.TYPE)}));
    }

    public static Expression writeVarLong(Expression buf, Variable pos, Expression value) {
        return Expressions.set((StoreDef)pos, (Expression)Expressions.staticCall(BinaryOutputUtils.class, (String)"writeVarLong", (Expression[])new Expression[]{buf, pos, Expressions.cast((Expression)value, Long.TYPE)}));
    }

    public static Expression writeFloat(Expression buf, Variable pos, Expression value, boolean bigEndian) {
        return SerializerExpressions.writeInt(buf, pos, Expressions.staticCall(Float.class, (String)"floatToIntBits", (Expression[])new Expression[]{Expressions.cast((Expression)value, Float.TYPE)}), bigEndian);
    }

    public static Expression writeDouble(Expression buf, Variable pos, Expression value, boolean bigEndian) {
        return SerializerExpressions.writeLong(buf, pos, Expressions.staticCall(Double.class, (String)"doubleToLongBits", (Expression[])new Expression[]{Expressions.cast((Expression)value, Double.TYPE)}), bigEndian);
    }

    public static Expression ensureRemaining(Expression buf, Variable pos, int size, Expression next) {
        return SerializerExpressions.ensureRemaining(buf, pos, Expressions.value((Object)size), next);
    }

    public static Expression ensureRemaining(Expression buf, Variable pos, Expression size, Expression next) {
        return Expressions.ifThenElse((Expression)Expressions.cmpGt((Expression)Expressions.add((Expression)pos, (Expression)size), (Expression)Expressions.length((Expression)buf)), (Expression)Expressions.throwException(ArrayIndexOutOfBoundsException.class), (Expression)next);
    }

    public static Expression array(Expression in) {
        return Expressions.call((Expression)in, (String)"array", (Expression[])new Expression[0]);
    }

    public static Expression pos(Expression in) {
        return Expressions.call((Expression)in, (String)"pos", (Expression[])new Expression[0]);
    }

    public static Expression pos(Expression in, Expression newPos) {
        return Expressions.call((Expression)in, (String)"pos", (Expression[])new Expression[]{newPos});
    }

    public static Expression move(Expression in, Expression bytes) {
        return Expressions.call((Expression)in, (String)"move", (Expression[])new Expression[]{bytes});
    }

    private static Expression move(Expression in, int bytes) {
        return Expressions.call((Expression)in, (String)"move", (Expression[])new Expression[]{Expressions.value((Object)bytes)});
    }

    public static Expression readBytes(Expression in, Expression buf) {
        return Expressions.call((Expression)in, (String)"read", (Expression[])new Expression[]{buf});
    }

    public static Expression readBytes(Expression in, Expression buf, Expression off, Expression len) {
        return Expressions.call((Expression)in, (String)"read", (Expression[])new Expression[]{buf, off, len});
    }

    public static Expression readByte(Expression in) {
        return Expressions.call((Expression)in, (String)"readByte", (Expression[])new Expression[0]);
    }

    public static Expression readBoolean(Expression in) {
        return Expressions.call((Expression)in, (String)"readBoolean", (Expression[])new Expression[0]);
    }

    public static Expression readShort(Expression in, boolean bigEndian) {
        return JDK_UNSAFE != null ? SerializerExpressions.getUnaligned(in, "getShortUnaligned", Short.class, 2, bigEndian) : Expressions.call((Expression)in, (String)("readShort" + (bigEndian ? "" : "LE")), (Expression[])new Expression[0]);
    }

    public static Expression readChar(Expression in, boolean bigEndian) {
        return JDK_UNSAFE != null ? SerializerExpressions.getUnaligned(in, "getCharUnaligned", Character.class, 2, bigEndian) : Expressions.call((Expression)in, (String)("readChar" + (bigEndian ? "" : "LE")), (Expression[])new Expression[0]);
    }

    public static Expression readInt(Expression in, boolean bigEndian) {
        return JDK_UNSAFE != null ? SerializerExpressions.getUnaligned(in, "getIntUnaligned", Integer.class, 4, bigEndian) : Expressions.call((Expression)in, (String)("readInt" + (bigEndian ? "" : "LE")), (Expression[])new Expression[0]);
    }

    public static Expression readLong(Expression in, boolean bigEndian) {
        return JDK_UNSAFE != null ? SerializerExpressions.getUnaligned(in, "getLongUnaligned", Long.class, 8, bigEndian) : Expressions.call((Expression)in, (String)("readLong" + (bigEndian ? "" : "LE")), (Expression[])new Expression[0]);
    }

    private static Expression getUnaligned(Expression in, String name, Class<?> numericType, int size, boolean bigEndian) {
        return Expressions.let((Expression)SerializerExpressions.convEndian(Expressions.call((Expression)SerializerExpressions.getUnsafe(), (String)name, (Expression[])new Expression[]{SerializerExpressions.array(in), Expressions.cast((Expression)Expressions.add((Expression)Expressions.value((Object)BYTE_ARRAY_BASE_OFFSET), (Expression)SerializerExpressions.pos(in)), Long.TYPE)}), numericType, bigEndian), result -> Expressions.sequence((Expression[])new Expression[]{SerializerExpressions.move(in, size), result}));
    }

    private static Expression convEndian(Expression numericValue, Class<?> numericType, boolean bigEndian) {
        return BIG_ENDIAN == bigEndian ? numericValue : Expressions.staticCall(numericType, (String)"reverseBytes", (Expression[])new Expression[]{numericValue});
    }

    public static Expression readVarInt(Expression in) {
        return Expressions.call((Expression)in, (String)"readVarInt", (Expression[])new Expression[0]);
    }

    public static Expression readVarLong(Expression in) {
        return Expressions.call((Expression)in, (String)"readVarLong", (Expression[])new Expression[0]);
    }

    public static Expression readFloat(Expression in, boolean bigEndian) {
        return Expressions.staticCall(Float.class, (String)"intBitsToFloat", (Expression[])new Expression[]{SerializerExpressions.readInt(in, bigEndian)});
    }

    public static Expression readDouble(Expression in, boolean bigEndian) {
        return Expressions.staticCall(Double.class, (String)"longBitsToDouble", (Expression[])new Expression[]{SerializerExpressions.readLong(in, bigEndian)});
    }

    static {
        Class<?> jdkUnsafe;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        int byteArrayBaseOffset = 0;
        boolean bigEndian = false;
        try {
            jdkUnsafe = classLoader.loadClass("jdk.internal.misc.Unsafe");
            Object unsafe = jdkUnsafe.getMethod("getUnsafe", new Class[0]).invoke(null, new Object[0]);
            byteArrayBaseOffset = (Integer)jdkUnsafe.getMethod("arrayBaseOffset", Class.class).invoke(unsafe, byte[].class);
            int byteArrayIndexScale = (Integer)jdkUnsafe.getMethod("arrayIndexScale", Class.class).invoke(unsafe, byte[].class);
            bigEndian = (Boolean)jdkUnsafe.getMethod("isBigEndian", new Class[0]).invoke(unsafe, new Object[0]);
            if (byteArrayIndexScale != 1) {
                jdkUnsafe = null;
            }
        }
        catch (Exception e) {
            jdkUnsafe = null;
        }
        JDK_UNSAFE = jdkUnsafe;
        BYTE_ARRAY_BASE_OFFSET = byteArrayBaseOffset;
        BIG_ENDIAN = bigEndian;
    }
}

