/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.stream;

import io.activej.serializer.BinaryInput;
import io.activej.serializer.BinaryOutput;
import io.activej.serializer.BinarySerializer;
import io.activej.serializer.CorruptedDataException;
import io.activej.serializer.stream.StreamCodec;
import io.activej.serializer.stream.StreamDecoder;
import io.activej.serializer.stream.StreamInput;
import io.activej.serializer.stream.StreamOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StreamCodecs {
    public static StreamCodec<Void> ofVoid() {
        return new StreamCodec<Void>(){

            @Override
            public void encode(StreamOutput output, Void item) {
            }

            @Override
            public Void decode(StreamInput input) {
                return null;
            }
        };
    }

    public static StreamCodec<Boolean> ofBoolean() {
        return new StreamCodec<Boolean>(){

            @Override
            public Boolean decode(StreamInput input) throws IOException {
                return input.readBoolean();
            }

            @Override
            public void encode(StreamOutput output, Boolean item) throws IOException {
                output.writeBoolean(item);
            }
        };
    }

    public static StreamCodec<Character> ofChar() {
        return new StreamCodec<Character>(){

            @Override
            public Character decode(StreamInput input) throws IOException {
                return Character.valueOf(input.readChar());
            }

            @Override
            public void encode(StreamOutput output, Character item) throws IOException {
                output.writeChar(item.charValue());
            }
        };
    }

    public static StreamCodec<Byte> ofByte() {
        return new StreamCodec<Byte>(){

            @Override
            public Byte decode(StreamInput input) throws IOException {
                return input.readByte();
            }

            @Override
            public void encode(StreamOutput output, Byte item) throws IOException {
                output.writeByte(item);
            }
        };
    }

    public static StreamCodec<Short> ofShort() {
        return new StreamCodec<Short>(){

            @Override
            public Short decode(StreamInput input) throws IOException {
                return input.readShort();
            }

            @Override
            public void encode(StreamOutput output, Short item) throws IOException {
                output.writeShort(item);
            }
        };
    }

    public static StreamCodec<Integer> ofInt() {
        return new StreamCodec<Integer>(){

            @Override
            public Integer decode(StreamInput input) throws IOException {
                return input.readInt();
            }

            @Override
            public void encode(StreamOutput output, Integer item) throws IOException {
                output.writeInt(item);
            }
        };
    }

    public static StreamCodec<Integer> ofVarInt() {
        return new StreamCodec<Integer>(){

            @Override
            public Integer decode(StreamInput input) throws IOException {
                return input.readVarInt();
            }

            @Override
            public void encode(StreamOutput output, Integer item) throws IOException {
                output.writeVarInt(item);
            }
        };
    }

    public static StreamCodec<Long> ofLong() {
        return new StreamCodec<Long>(){

            @Override
            public Long decode(StreamInput input) throws IOException {
                return input.readLong();
            }

            @Override
            public void encode(StreamOutput output, Long item) throws IOException {
                output.writeLong(item);
            }
        };
    }

    public static StreamCodec<Long> ofVarLong() {
        return new StreamCodec<Long>(){

            @Override
            public Long decode(StreamInput input) throws IOException {
                return input.readVarLong();
            }

            @Override
            public void encode(StreamOutput output, Long item) throws IOException {
                output.writeVarLong(item);
            }
        };
    }

    public static StreamCodec<Float> ofFloat() {
        return new StreamCodec<Float>(){

            @Override
            public Float decode(StreamInput input) throws IOException {
                return Float.valueOf(input.readFloat());
            }

            @Override
            public void encode(StreamOutput output, Float item) throws IOException {
                output.writeFloat(item.floatValue());
            }
        };
    }

    public static StreamCodec<Double> ofDouble() {
        return new StreamCodec<Double>(){

            @Override
            public Double decode(StreamInput input) throws IOException {
                return input.readDouble();
            }

            @Override
            public void encode(StreamOutput output, Double item) throws IOException {
                output.writeDouble(item);
            }
        };
    }

    public static StreamCodec<String> ofString() {
        return new StreamCodec<String>(){

            @Override
            public String decode(StreamInput input) throws IOException {
                return input.readString();
            }

            @Override
            public void encode(StreamOutput output, String item) throws IOException {
                output.writeString(item);
            }
        };
    }

    public static StreamCodec<boolean[]> ofBooleanArray() {
        return new AbstractArrayStreamCodec<boolean[]>(1){

            @Override
            protected int getArrayLength(boolean[] array) {
                return array.length;
            }

            @Override
            protected void doWrite(BinaryOutput output, boolean[] array, int offset, int limit) {
                while (offset < limit) {
                    output.writeBoolean(array[offset]);
                    ++offset;
                }
            }

            @Override
            protected boolean[] createArray(int length) {
                return new boolean[length];
            }

            @Override
            protected void doRead(BinaryInput input, boolean[] array, int offset, int count) {
                for (int i = 0; i < count; ++i) {
                    array[i + offset] = input.readBoolean();
                }
            }

            @Override
            protected void doReadRemaining(StreamInput input, boolean[] array, int offset, int limit) throws IOException {
                while (offset < limit) {
                    array[offset] = input.readBoolean();
                    ++offset;
                }
            }
        };
    }

    public static StreamCodec<char[]> ofCharArray() {
        return new AbstractArrayStreamCodec<char[]>(2){

            @Override
            protected int getArrayLength(char[] array) {
                return array.length;
            }

            @Override
            protected void doWrite(BinaryOutput output, char[] array, int offset, int limit) {
                while (offset < limit) {
                    output.writeChar(array[offset]);
                    ++offset;
                }
            }

            @Override
            protected char[] createArray(int length) {
                return new char[length];
            }

            @Override
            protected void doRead(BinaryInput input, char[] array, int offset, int count) {
                for (int i = 0; i < count; ++i) {
                    array[i + offset] = input.readChar();
                }
            }

            @Override
            protected void doReadRemaining(StreamInput input, char[] array, int offset, int limit) throws IOException {
                while (offset < limit) {
                    array[offset] = input.readChar();
                    ++offset;
                }
            }
        };
    }

    public static StreamCodec<byte[]> ofByteArray() {
        return new StreamCodec<byte[]>(){

            @Override
            public void encode(StreamOutput output, byte[] item) throws IOException {
                output.writeVarInt(item.length);
                output.write(item);
            }

            @Override
            public byte[] decode(StreamInput input) throws IOException {
                byte[] array = new byte[input.readVarInt()];
                input.read(array);
                return array;
            }
        };
    }

    public static StreamCodec<short[]> ofShortArray() {
        return new AbstractArrayStreamCodec<short[]>(2){

            @Override
            protected int getArrayLength(short[] array) {
                return array.length;
            }

            @Override
            protected void doWrite(BinaryOutput output, short[] array, int offset, int limit) {
                while (offset < limit) {
                    output.writeShort(array[offset]);
                    ++offset;
                }
            }

            @Override
            protected short[] createArray(int length) {
                return new short[length];
            }

            @Override
            protected void doRead(BinaryInput input, short[] array, int offset, int count) {
                for (int i = 0; i < count; ++i) {
                    array[i + offset] = input.readShort();
                }
            }

            @Override
            protected void doReadRemaining(StreamInput input, short[] array, int offset, int limit) throws IOException {
                while (offset < limit) {
                    array[offset] = input.readShort();
                    ++offset;
                }
            }
        };
    }

    public static StreamCodec<int[]> ofIntArray() {
        return new AbstractArrayStreamCodec<int[]>(4){

            @Override
            protected int getArrayLength(int[] array) {
                return array.length;
            }

            @Override
            protected void doWrite(BinaryOutput output, int[] array, int offset, int limit) {
                while (offset < limit) {
                    output.writeInt(array[offset]);
                    ++offset;
                }
            }

            @Override
            protected int[] createArray(int length) {
                return new int[length];
            }

            @Override
            protected void doRead(BinaryInput input, int[] array, int offset, int count) {
                for (int i = 0; i < count; ++i) {
                    array[i + offset] = input.readInt();
                }
            }

            @Override
            protected void doReadRemaining(StreamInput input, int[] array, int offset, int limit) throws IOException {
                while (offset < limit) {
                    array[offset] = input.readInt();
                    ++offset;
                }
            }
        };
    }

    public static StreamCodec<long[]> ofLongArray() {
        return new AbstractArrayStreamCodec<long[]>(8){

            @Override
            protected int getArrayLength(long[] array) {
                return array.length;
            }

            @Override
            protected void doWrite(BinaryOutput output, long[] array, int offset, int limit) {
                while (offset < limit) {
                    output.writeLong(array[offset]);
                    ++offset;
                }
            }

            @Override
            protected long[] createArray(int length) {
                return new long[length];
            }

            @Override
            protected void doRead(BinaryInput input, long[] array, int offset, int count) {
                for (int i = 0; i < count; ++i) {
                    array[i + offset] = input.readLong();
                }
            }

            @Override
            protected void doReadRemaining(StreamInput input, long[] array, int offset, int limit) throws IOException {
                while (offset < limit) {
                    array[offset] = input.readLong();
                    ++offset;
                }
            }
        };
    }

    public static StreamCodec<float[]> ofFloatArray() {
        return new AbstractArrayStreamCodec<float[]>(4){

            @Override
            protected int getArrayLength(float[] array) {
                return array.length;
            }

            @Override
            protected void doWrite(BinaryOutput output, float[] array, int offset, int limit) {
                while (offset < limit) {
                    output.writeFloat(array[offset]);
                    ++offset;
                }
            }

            @Override
            protected float[] createArray(int length) {
                return new float[length];
            }

            @Override
            protected void doRead(BinaryInput input, float[] array, int offset, int count) {
                for (int i = 0; i < count; ++i) {
                    array[i + offset] = input.readFloat();
                }
            }

            @Override
            protected void doReadRemaining(StreamInput input, float[] array, int offset, int limit) throws IOException {
                while (offset < limit) {
                    array[offset] = input.readFloat();
                    ++offset;
                }
            }
        };
    }

    public static StreamCodec<double[]> ofDoubleArray() {
        return new AbstractArrayStreamCodec<double[]>(8){

            @Override
            protected int getArrayLength(double[] array) {
                return array.length;
            }

            @Override
            protected void doWrite(BinaryOutput output, double[] array, int offset, int limit) {
                while (offset < limit) {
                    output.writeDouble(array[offset]);
                    ++offset;
                }
            }

            @Override
            protected double[] createArray(int length) {
                return new double[length];
            }

            @Override
            protected void doRead(BinaryInput input, double[] array, int offset, int count) {
                for (int i = 0; i < count; ++i) {
                    array[i + offset] = input.readDouble();
                }
            }

            @Override
            protected void doReadRemaining(StreamInput input, double[] array, int offset, int limit) throws IOException {
                while (offset < limit) {
                    array[offset] = input.readDouble();
                    ++offset;
                }
            }
        };
    }

    public static StreamCodec<int[]> ofVarIntArray() {
        return new AbstractArrayStreamCodec<int[]>(1, 5){

            @Override
            protected int getArrayLength(int[] array) {
                return array.length;
            }

            @Override
            protected void doWrite(BinaryOutput output, int[] array, int offset, int limit) {
                for (int i = offset; i < limit; ++i) {
                    output.writeVarInt(array[i]);
                }
            }

            @Override
            protected int[] createArray(int length) {
                return new int[length];
            }

            @Override
            protected void doRead(BinaryInput input, int[] array, int offset, int count) {
                for (int i = 0; i < count; ++i) {
                    array[offset++] = input.readVarInt();
                }
            }

            @Override
            protected void doReadRemaining(StreamInput input, int[] array, int offset, int limit) throws IOException {
                while (offset < limit) {
                    array[offset] = input.readVarInt();
                    ++offset;
                }
            }
        };
    }

    public static StreamCodec<long[]> ofVarLongArray() {
        return new AbstractArrayStreamCodec<long[]>(1, 10){

            @Override
            protected int getArrayLength(long[] array) {
                return array.length;
            }

            @Override
            protected void doWrite(BinaryOutput output, long[] array, int offset, int limit) {
                for (int i = offset; i < limit; ++i) {
                    output.writeVarLong(array[i]);
                }
            }

            @Override
            protected long[] createArray(int length) {
                return new long[length];
            }

            @Override
            protected void doRead(BinaryInput input, long[] array, int offset, int count) {
                for (int i = 0; i < count; ++i) {
                    array[offset++] = input.readVarLong();
                }
            }

            @Override
            protected void doReadRemaining(StreamInput input, long[] array, int offset, int limit) throws IOException {
                while (offset < limit) {
                    array[offset] = input.readVarLong();
                    ++offset;
                }
            }
        };
    }

    public static <T> StreamCodec<T[]> ofArray(StreamCodec<T> itemCodec, IntFunction<T[]> factory) {
        return StreamCodecs.ofArray((int $) -> itemCodec, factory);
    }

    public static <T> StreamCodec<T[]> ofArray(final IntFunction<? extends StreamCodec<? extends T>> itemCodecFn, final IntFunction<T[]> factory) {
        return new StreamCodec<T[]>(){

            @Override
            public void encode(StreamOutput output, T[] list) throws IOException {
                output.writeVarInt(list.length);
                for (int i = 0; i < list.length; ++i) {
                    StreamCodec codec = (StreamCodec)itemCodecFn.apply(i);
                    codec.encode(output, list[i]);
                }
            }

            @Override
            public T[] decode(StreamInput input) throws IOException {
                int size = input.readVarInt();
                Object[] array = (Object[])factory.apply(size);
                for (int i = 0; i < size; ++i) {
                    array[i] = ((StreamCodec)itemCodecFn.apply(i)).decode(input);
                }
                return array;
            }
        };
    }

    public static <E extends Enum<E>> StreamCodec<E> ofEnum(final Class<E> enumType) {
        return new StreamCodec<E>(){

            @Override
            public void encode(StreamOutput output, E value) throws IOException {
                output.writeVarInt(((Enum)value).ordinal());
            }

            @Override
            public E decode(StreamInput input) throws IOException {
                return ((Enum[])enumType.getEnumConstants())[input.readVarInt()];
            }
        };
    }

    public static <T> StreamCodec<Optional<T>> ofOptional(final StreamCodec<T> codec) {
        return new StreamCodec<Optional<T>>(){

            @Override
            public void encode(StreamOutput output, Optional<T> item) throws IOException {
                if (!item.isPresent()) {
                    output.writeByte((byte)0);
                } else {
                    output.writeByte((byte)1);
                    codec.encode(output, item.get());
                }
            }

            @Override
            public Optional<T> decode(StreamInput input) throws IOException {
                if (input.readByte() == 0) {
                    return Optional.empty();
                }
                return Optional.of(codec.decode(input));
            }
        };
    }

    public static <T, C extends Collection<T>> StreamCodec<C> ofCollection(final StreamCodec<T> itemCodec, final IntFunction<C> factory) {
        return new StreamCodec<C>(){

            @Override
            public void encode(StreamOutput output, C c) throws IOException {
                output.writeVarInt(c.size());
                for (Object e : c) {
                    itemCodec.encode(output, e);
                }
            }

            @Override
            public C decode(StreamInput input) throws IOException {
                int size = input.readVarInt();
                Collection c = (Collection)factory.apply(size);
                for (int i = 0; i < size; ++i) {
                    Object e = itemCodec.decode(input);
                    c.add(e);
                }
                return c;
            }
        };
    }

    public static <T> StreamCodec<Collection<T>> ofCollection(StreamCodec<T> itemCodec) {
        return StreamCodecs.ofCollection(itemCodec, ArrayList::new);
    }

    public static <T> StreamCodec<Set<T>> ofSet(StreamCodec<T> itemCodec) {
        return StreamCodecs.ofCollection(itemCodec, length -> new HashSet(StreamCodecs.hashInitialSize(length)));
    }

    public static <E extends Enum<E>> StreamCodec<Set<E>> ofEnumSet(Class<E> type) {
        return StreamCodecs.ofCollection(StreamCodecs.ofEnum(type), $ -> EnumSet.noneOf(type));
    }

    public static <T> StreamCodec<List<T>> ofList(StreamCodec<T> itemCodec) {
        return StreamCodecs.ofList((int $) -> itemCodec);
    }

    public static <T> StreamCodec<List<T>> ofList(final IntFunction<? extends StreamCodec<? extends T>> itemCodecFn) {
        return new StreamCodec<List<T>>(){

            @Override
            public void encode(StreamOutput output, List<T> list) throws IOException {
                output.writeVarInt(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    StreamCodec codec = (StreamCodec)itemCodecFn.apply(i);
                    codec.encode(output, list.get(i));
                }
            }

            @Override
            public List<T> decode(StreamInput input) throws IOException {
                int length = input.readVarInt();
                Object[] array = new Object[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = ((StreamCodec)itemCodecFn.apply(i)).decode(input);
                }
                return Arrays.asList(array);
            }
        };
    }

    public static <K, V> StreamCodec<Map<K, V>> ofMap(StreamCodec<K> keyCodec, StreamCodec<V> valueCodec) {
        return StreamCodecs.ofMap(keyCodec, (? super K $) -> valueCodec);
    }

    public static <K, V> StreamCodec<Map<K, V>> ofMap(StreamCodec<K> keyCodec, Function<? super K, ? extends StreamCodec<? extends V>> valueCodecFn) {
        return StreamCodecs.ofMap(keyCodec, valueCodecFn, length -> new HashMap(StreamCodecs.hashInitialSize(length)));
    }

    public static <E extends Enum<E>, V> StreamCodec<Map<E, V>> ofEnumMap(Class<E> type, StreamCodec<V> valueCodec) {
        return StreamCodecs.ofMap(StreamCodecs.ofEnum(type), $ -> valueCodec, $ -> new EnumMap(type));
    }

    public static <K, V, M extends Map<K, V>> StreamCodec<M> ofMap(final StreamCodec<K> keyCodec, final Function<? super K, ? extends StreamCodec<? extends V>> valueCodecFn, final IntFunction<M> factory) {
        return new StreamCodec<M>(){

            @Override
            public void encode(StreamOutput output, M map) throws IOException {
                output.writeVarInt(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    keyCodec.encode(output, entry.getKey());
                    StreamCodec valueCodec = (StreamCodec)valueCodecFn.apply(entry.getKey());
                    valueCodec.encode(output, entry.getValue());
                }
            }

            @Override
            public M decode(StreamInput input) throws IOException {
                int length = input.readVarInt();
                Map map = (Map)factory.apply(length);
                for (int i = 0; i < length; ++i) {
                    Object key = keyCodec.decode(input);
                    Object value = ((StreamCodec)valueCodecFn.apply(key)).decode(input);
                    map.put(key, value);
                }
                return map;
            }
        };
    }

    public static <T> StreamCodec<T> ofSubtype(LinkedHashMap<Class<? extends T>, StreamCodec<? extends T>> codecs) {
        SubtypeBuilder builder = new SubtypeBuilder();
        for (Map.Entry<Class<T>, StreamCodec<T>> e : codecs.entrySet()) {
            builder.add(e.getKey(), e.getValue());
        }
        return builder.build();
    }

    public static <T> StreamCodec<@Nullable T> ofNullable(final StreamCodec<@NotNull T> codec) {
        return new StreamCodec<T>(){

            @Override
            public void encode(StreamOutput output, @Nullable T item) throws IOException {
                if (item == null) {
                    output.writeByte((byte)0);
                } else {
                    output.writeByte((byte)1);
                    codec.encode(output, item);
                }
            }

            @Override
            @Nullable
            public T decode(StreamInput input) throws IOException {
                if (input.readByte() == 0) {
                    return null;
                }
                return codec.decode(input);
            }
        };
    }

    public static <T, R> StreamCodec<R> transform(final StreamCodec<T> codec, final Function<T, ? extends R> reader, final Function<R, T> writer) {
        return new StreamCodec<R>(){

            @Override
            public void encode(StreamOutput output, R value) throws IOException {
                Object result = writer.apply(value);
                codec.encode(output, result);
            }

            @Override
            public R decode(StreamInput input) throws IOException {
                Object result = codec.decode(input);
                return reader.apply(result);
            }
        };
    }

    public static <T> StreamCodec<T> singleton(final T instance) {
        return new StreamCodec<T>(){

            @Override
            public void encode(StreamOutput output, T item) {
            }

            @Override
            public T decode(StreamInput input) {
                return instance;
            }
        };
    }

    private static int hashInitialSize(int length) {
        return (length + 2) / 3 * 4;
    }

    public static <T> StreamCodec<T> reference(final StreamCodec<T> codec) {
        return new StreamCodec<T>(){
            private final IdentityHashMap<T, Integer> mapEncode = new IdentityHashMap();
            private final ArrayList<T> mapDecode = new ArrayList();

            @Override
            public void encode(StreamOutput output, T item) throws IOException {
                int index = this.mapEncode.getOrDefault(item, 0);
                if (index == 0) {
                    this.mapEncode.put(item, this.mapEncode.size() + 1);
                    output.writeVarInt(0);
                    codec.encode(output, item);
                } else {
                    output.writeVarInt(index);
                }
            }

            @Override
            public T decode(StreamInput input) throws IOException {
                int index = input.readVarInt();
                if (index == 0) {
                    Object item = codec.decode(input);
                    this.mapDecode.add(item);
                    return item;
                }
                return this.mapDecode.get(index - 1);
            }
        };
    }

    public static class SubtypeBuilder<T> {
        private final Map<Class<?>, SubclassEntry<? extends T>> encoders = new HashMap();
        private final List<StreamDecoder<? extends T>> decoders = new ArrayList<StreamDecoder<? extends T>>();

        public <E extends T> SubtypeBuilder<T> add(Class<E> type, StreamCodec<E> codec) {
            byte idx = (byte)this.encoders.size();
            this.encoders.put(type, new SubclassEntry(idx, codec));
            this.decoders.add(codec);
            return this;
        }

        public StreamCodec<T> build() {
            if (this.encoders.isEmpty()) {
                throw new IllegalStateException("No subtype codec has been specified");
            }
            return new StreamCodec<T>(){

                @Override
                public void encode(StreamOutput output, T item) throws IOException {
                    Class<?> type = item.getClass();
                    SubclassEntry entry = (SubclassEntry)encoders.get(type);
                    if (entry == null) {
                        throw new IllegalArgumentException("Unsupported type " + type);
                    }
                    output.writeByte(entry.idx);
                    entry.codec.encode(output, item);
                }

                @Override
                public T decode(StreamInput input) throws IOException {
                    byte idx = input.readByte();
                    if (idx < 0 || idx >= decoders.size()) {
                        throw new CorruptedDataException();
                    }
                    return ((StreamDecoder)decoders.get(idx)).decode(input);
                }
            };
        }

        private static final class SubclassEntry<T> {
            final byte idx;
            final StreamCodec<T> codec;

            private SubclassEntry(byte idx, StreamCodec<T> codec) {
                this.idx = idx;
                this.codec = codec;
            }
        }
    }

    protected static abstract class AbstractArrayStreamCodec<T>
    implements StreamCodec<T> {
        protected final int minElementSize;
        protected final int maxElementSize;

        protected AbstractArrayStreamCodec(int minElementSize, int maxElementSize) {
            this.minElementSize = minElementSize;
            this.maxElementSize = maxElementSize;
        }

        protected AbstractArrayStreamCodec(int elementSize) {
            this.minElementSize = elementSize;
            this.maxElementSize = elementSize;
        }

        @Override
        public final void encode(StreamOutput output, T array) throws IOException {
            int sourceArrayLength = this.getArrayLength(array);
            output.writeVarInt(sourceArrayLength);
            output.ensure(this.maxElementSize);
            int i = 0;
            while (i < sourceArrayLength) {
                int numberOfItems = output.remaining() / this.maxElementSize;
                if (numberOfItems == 0) {
                    output.flush();
                    continue;
                }
                int limit = i + Math.min(numberOfItems, sourceArrayLength - i);
                this.doWrite(output.out(), array, i, limit);
                i += numberOfItems;
            }
        }

        protected abstract int getArrayLength(T var1);

        protected abstract void doWrite(BinaryOutput var1, T var2, int var3, int var4);

        @Override
        public final T decode(StreamInput input) throws IOException {
            int length = input.readVarInt();
            T array = this.createArray(length);
            int idx = 0;
            while (idx < length) {
                int safeRemaining = length - idx;
                int safeReadCount = Math.min(safeRemaining, input.remaining() / this.maxElementSize);
                if (safeReadCount == 0) {
                    int safeEnsure = Math.min(input.array().length - input.remaining(), safeRemaining * this.minElementSize);
                    input.ensure(safeEnsure);
                    if (input.remaining() / this.maxElementSize != 0) continue;
                    break;
                }
                this.doRead(input.in(), array, idx, safeReadCount);
                idx += safeReadCount;
            }
            this.doReadRemaining(input, array, idx, length);
            return array;
        }

        protected abstract T createArray(int var1);

        protected abstract void doRead(BinaryInput var1, T var2, int var3, int var4);

        protected abstract void doReadRemaining(StreamInput var1, T var2, int var3, int var4) throws IOException;
    }

    static class OfBinarySerializer<T>
    implements StreamCodec<T> {
        private static final int MAX_SIZE = 0x10000000;
        public static final int DEFAULT_ESTIMATED_SIZE = 1;
        private final BinarySerializer<T> serializer;
        private final AtomicInteger estimation = new AtomicInteger();

        public OfBinarySerializer(BinarySerializer<T> serializer) {
            this(serializer, 1);
        }

        public OfBinarySerializer(BinarySerializer<T> serializer, int estimatedSize) {
            this.serializer = serializer;
            this.estimation.set(estimatedSize);
        }

        @Override
        public final void encode(StreamOutput output, T item) throws IOException {
            int headerSize;
            int dataSize;
            int positionData;
            int positionBegin;
            BinaryOutput out;
            int estimatedDataSize = this.estimation.get();
            int estimatedHeaderSize = OfBinarySerializer.varIntSize(estimatedDataSize);
            output.ensure(estimatedHeaderSize + estimatedDataSize + (estimatedDataSize >>> 2));
            while (true) {
                out = output.out();
                positionBegin = out.pos();
                positionData = positionBegin + estimatedHeaderSize;
                out.pos(positionData);
                try {
                    this.serializer.encode(out, item);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    dataSize = out.array().length - positionData;
                    out.pos(positionBegin);
                    output.ensure(estimatedHeaderSize + dataSize + 1 + (dataSize >>> 1));
                    continue;
                }
                break;
            }
            int positionEnd = out.pos();
            dataSize = positionEnd - positionData;
            if (dataSize > estimatedDataSize) {
                headerSize = OfBinarySerializer.varIntSize(dataSize);
                this.estimateMore(output, positionBegin, positionData, dataSize, headerSize);
            } else {
                headerSize = estimatedHeaderSize;
            }
            this.writeSize(output.array(), positionBegin, dataSize, headerSize);
        }

        private void estimateMore(StreamOutput output, int positionBegin, int positionData, int dataSize, int headerSize) {
            int estimationNew;
            int estimationOld;
            if (dataSize >= 0x10000000) {
                throw new IllegalArgumentException("Unsupported size");
            }
            while (!this.estimation.compareAndSet(estimationOld = this.estimation.get(), estimationNew = Math.max(estimationOld, dataSize))) {
            }
            this.ensureHeaderSize(output, positionBegin, positionData, dataSize, headerSize);
        }

        private void ensureHeaderSize(StreamOutput output, int positionBegin, int positionData, int dataSize, int headerSize) {
            int previousHeaderSize = positionData - positionBegin;
            if (previousHeaderSize == headerSize) {
                return;
            }
            int headerDelta = headerSize - previousHeaderSize;
            assert (headerDelta > 0);
            int newPositionData = positionData + headerDelta;
            int newPositionEnd = newPositionData + dataSize;
            byte[] array = output.array();
            if (newPositionEnd < array.length) {
                System.arraycopy(array, positionData, array, newPositionData, dataSize);
            } else {
                byte[] oldArray = array;
                output.out(new BinaryOutput(this.allocate(newPositionEnd)));
                array = output.array();
                System.arraycopy(oldArray, 0, array, 0, positionBegin);
                System.arraycopy(oldArray, positionData, array, newPositionData, dataSize);
                this.recycle(oldArray);
            }
            output.pos(newPositionEnd);
        }

        private static int varIntSize(int dataSize) {
            return 1 + (31 - Integer.numberOfLeadingZeros(dataSize)) / 7;
        }

        private void writeSize(byte[] array, int pos, int size, int headerSize) {
            if (headerSize == 1) {
                array[pos] = (byte)size;
                return;
            }
            array[pos] = (byte)(size & 0x7F | 0x80);
            size >>>= 7;
            if (headerSize == 2) {
                array[pos + 1] = (byte)size;
                return;
            }
            array[pos + 1] = (byte)(size & 0x7F | 0x80);
            size >>>= 7;
            if (headerSize == 3) {
                array[pos + 2] = (byte)size;
                return;
            }
            assert (headerSize == 4);
            array[pos + 2] = (byte)(size & 0x7F | 0x80);
            array[pos + 3] = (byte)(size >>>= 7);
        }

        protected byte[] allocate(int size) {
            return new byte[size];
        }

        protected void recycle(byte[] array) {
        }

        @Override
        public T decode(StreamInput input) throws IOException {
            int messageSize = this.readSize(input);
            input.ensure(messageSize);
            BinaryInput in = input.in();
            int oldPos = in.pos();
            try {
                T item = this.serializer.decode(in);
                if (in.pos() - oldPos != messageSize) {
                    throw new CorruptedDataException("Deserialized size != decoded data size");
                }
                return item;
            }
            catch (CorruptedDataException e) {
                input.close();
                throw e;
            }
        }

        private int readSize(StreamInput input) throws IOException {
            int result;
            int b = input.readByte();
            if (b >= 0) {
                result = b;
            } else {
                result = b & 0x7F;
                byte by = input.readByte();
                b = by;
                if (by >= 0) {
                    result |= b << 7;
                } else {
                    result |= (b & 0x7F) << 7;
                    byte by2 = input.readByte();
                    b = by2;
                    if (by2 >= 0) {
                        result |= b << 14;
                    } else {
                        result |= (b & 0x7F) << 14;
                        byte by3 = input.readByte();
                        b = by3;
                        if (by3 >= 0) {
                            result |= b << 21;
                        } else {
                            input.close();
                            throw new CorruptedDataException("Invalid size");
                        }
                    }
                }
            }
            return result;
        }
    }
}

