/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.impl;

import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.Variable;
import io.activej.serializer.AbstractSerializerDef;
import io.activej.serializer.CompatibilityLevel;
import io.activej.serializer.SerializerDef;
import io.activej.serializer.impl.SerializerDefNullable;
import io.activej.serializer.impl.SerializerDefWithNullable;
import io.activej.serializer.impl.SerializerExpressions;
import java.util.function.BinaryOperator;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSerializerDefMap
extends AbstractSerializerDef
implements SerializerDefWithNullable {
    protected final SerializerDef keySerializer;
    protected final SerializerDef valueSerializer;
    protected final Class<?> encodeType;
    protected final Class<?> decodeType;
    protected final Class<?> keyType;
    protected final Class<?> valueType;
    protected final boolean nullable;

    protected AbstractSerializerDefMap(@NotNull SerializerDef keySerializer, @NotNull SerializerDef valueSerializer, @NotNull Class<?> encodeType, @NotNull Class<?> decodeType, @NotNull Class<?> keyType, @NotNull Class<?> valueType, boolean nullable) {
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.encodeType = encodeType;
        this.decodeType = decodeType;
        this.keyType = keyType;
        this.valueType = valueType;
        this.nullable = nullable;
    }

    @Override
    public void accept(SerializerDef.Visitor visitor) {
        visitor.visit("key", this.keySerializer);
        visitor.visit("value", this.valueSerializer);
    }

    @Override
    public boolean isInline(int version, CompatibilityLevel compatibilityLevel) {
        return false;
    }

    @Override
    public Class<?> getEncodeType() {
        return this.encodeType;
    }

    @Override
    public Class<?> getDecodeType() {
        return this.decodeType;
    }

    @Override
    public final SerializerDef ensureNullable(CompatibilityLevel compatibilityLevel) {
        if (compatibilityLevel.getLevel() < CompatibilityLevel.LEVEL_3.getLevel()) {
            return new SerializerDefNullable(this);
        }
        return this.doEnsureNullable(compatibilityLevel);
    }

    @Override
    public final Expression encoder(SerializerDef.StaticEncoders staticEncoders, Expression buf, Variable pos, Expression value, int version, CompatibilityLevel compatibilityLevel) {
        if (!this.nullable) {
            return Expressions.sequence((Expression[])new Expression[]{SerializerExpressions.writeVarInt(buf, pos, Expressions.length((Expression)value)), this.doEncode(staticEncoders, buf, pos, value, version, compatibilityLevel)});
        }
        return Expressions.ifThenElse((Expression)Expressions.isNull((Expression)value), (Expression)SerializerExpressions.writeByte(buf, pos, Expressions.value((Object)0)), (Expression)Expressions.sequence((Expression[])new Expression[]{SerializerExpressions.writeVarInt(buf, pos, Expressions.inc((Expression)Expressions.length((Expression)value))), this.doEncode(staticEncoders, buf, pos, value, version, compatibilityLevel)}));
    }

    @NotNull
    protected Expression doEncode(SerializerDef.StaticEncoders staticEncoders, Expression buf, Variable pos, Expression value, int version, CompatibilityLevel compatibilityLevel) {
        return this.doIterateMap(value, (k, v) -> Expressions.sequence((Expression[])new Expression[]{this.keySerializer.defineEncoder(staticEncoders, buf, pos, Expressions.cast((Expression)k, this.keySerializer.getEncodeType()), version, compatibilityLevel), this.valueSerializer.defineEncoder(staticEncoders, buf, pos, Expressions.cast((Expression)v, this.valueSerializer.getEncodeType()), version, compatibilityLevel)}));
    }

    @Override
    public final Expression decoder(SerializerDef.StaticDecoders staticDecoders, Expression in, int version, CompatibilityLevel compatibilityLevel) {
        return Expressions.let((Expression)SerializerExpressions.readVarInt(in), length -> !this.nullable ? this.doDecode(staticDecoders, in, version, compatibilityLevel, (Expression)length) : Expressions.ifThenElse((Expression)Expressions.cmpEq((Expression)length, (Expression)Expressions.value((Object)0)), (Expression)Expressions.nullRef(this.decodeType), (Expression)Expressions.let((Expression)Expressions.dec((Expression)length), len -> this.doDecode(staticDecoders, in, version, compatibilityLevel, (Expression)len))));
    }

    @NotNull
    protected Expression doDecode(SerializerDef.StaticDecoders staticDecoders, Expression in, int version, CompatibilityLevel compatibilityLevel, Expression length) {
        return Expressions.let((Expression)this.createBuilder(length), builder -> Expressions.sequence((Expression[])new Expression[]{Expressions.iterate((Expression)Expressions.value((Object)0), (Expression)length, i -> this.putToBuilder((Expression)builder, (Expression)i, Expressions.cast((Expression)this.keySerializer.defineDecoder(staticDecoders, in, version, compatibilityLevel), this.keyType), Expressions.cast((Expression)this.valueSerializer.defineDecoder(staticDecoders, in, version, compatibilityLevel), this.valueType))), this.build((Expression)builder)}));
    }

    @NotNull
    protected abstract SerializerDef doEnsureNullable(CompatibilityLevel var1);

    @NotNull
    protected abstract Expression doIterateMap(Expression var1, BinaryOperator<Expression> var2);

    @NotNull
    protected abstract Expression createBuilder(Expression var1);

    @NotNull
    protected abstract Expression putToBuilder(Expression var1, Expression var2, Expression var3, Expression var4);

    @NotNull
    protected abstract Expression build(Expression var1);
}

