/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.impl;

import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.Variable;
import io.activej.serializer.AbstractSerializerDef;
import io.activej.serializer.CompatibilityLevel;
import io.activej.serializer.SerializerDef;
import io.activej.serializer.impl.SerializerDefNullable;
import io.activej.serializer.impl.SerializerDefWithFixedSize;
import io.activej.serializer.impl.SerializerDefWithNullable;
import io.activej.serializer.impl.SerializerExpressions;
import org.jetbrains.annotations.NotNull;

public final class SerializerDefArray
extends AbstractSerializerDef
implements SerializerDefWithNullable,
SerializerDefWithFixedSize {
    private final SerializerDef valueSerializer;
    private final int fixedSize;
    private final Class<?> type;
    private final boolean nullable;

    public SerializerDefArray(SerializerDef serializer, Class<?> type) {
        this.valueSerializer = serializer;
        this.fixedSize = -1;
        this.type = type;
        this.nullable = false;
    }

    private SerializerDefArray(@NotNull SerializerDef serializer, int fixedSize, Class<?> type, boolean nullable) {
        this.valueSerializer = serializer;
        this.fixedSize = fixedSize;
        this.type = type;
        this.nullable = nullable;
    }

    @Override
    public SerializerDefArray ensureFixedSize(int fixedSize) {
        return new SerializerDefArray(this.valueSerializer, fixedSize, this.type, this.nullable);
    }

    @Override
    public SerializerDef ensureNullable(CompatibilityLevel compatibilityLevel) {
        if (compatibilityLevel.getLevel() < CompatibilityLevel.LEVEL_3.getLevel()) {
            return new SerializerDefNullable(this);
        }
        return new SerializerDefArray(this.valueSerializer, this.fixedSize, this.type, true);
    }

    @Override
    public void accept(SerializerDef.Visitor visitor) {
        visitor.visit(this.valueSerializer);
    }

    @Override
    public boolean isInline(int version, CompatibilityLevel compatibilityLevel) {
        return this.type.getComponentType() == Byte.TYPE;
    }

    @Override
    public Class<?> getEncodeType() {
        return Object.class;
    }

    @Override
    public Expression encoder(SerializerDef.StaticEncoders staticEncoders, Expression buf, Variable pos, Expression value, int version, CompatibilityLevel compatibilityLevel) {
        if (this.type.getComponentType() == Byte.TYPE) {
            Expression length;
            Expression castedValue = Expressions.cast((Expression)value, this.type);
            Expression expression = length = this.fixedSize != -1 ? Expressions.value((Object)this.fixedSize) : Expressions.length((Expression)castedValue);
            if (!this.nullable) {
                return Expressions.sequence((Expression[])new Expression[]{SerializerExpressions.writeVarInt(buf, pos, length), SerializerExpressions.writeBytes(buf, pos, castedValue)});
            }
            return Expressions.ifThenElse((Expression)Expressions.isNull((Expression)value), (Expression)SerializerExpressions.writeByte(buf, pos, Expressions.value((Object)0)), (Expression)Expressions.sequence((Expression[])new Expression[]{SerializerExpressions.writeVarInt(buf, pos, Expressions.inc((Expression)length)), SerializerExpressions.writeBytes(buf, pos, castedValue)}));
        }
        Expression size = this.fixedSize != -1 ? Expressions.value((Object)this.fixedSize) : Expressions.length((Expression)Expressions.cast((Expression)value, this.type));
        Expression writeCollection = Expressions.iterate((Expression)Expressions.value((Object)0), (Expression)size, i -> this.valueSerializer.defineEncoder(staticEncoders, buf, pos, Expressions.arrayGet((Expression)Expressions.cast((Expression)value, this.type), (Expression)i), version, compatibilityLevel));
        if (!this.nullable) {
            return Expressions.sequence((Expression[])new Expression[]{SerializerExpressions.writeVarInt(buf, pos, size), writeCollection});
        }
        return Expressions.ifThenElse((Expression)Expressions.isNull((Expression)value), (Expression)SerializerExpressions.writeByte(buf, pos, Expressions.value((Object)0)), (Expression)Expressions.sequence((Expression[])new Expression[]{SerializerExpressions.writeVarInt(buf, pos, Expressions.inc((Expression)size)), writeCollection}));
    }

    @Override
    public Expression decoder(SerializerDef.StaticDecoders staticDecoders, Expression in, int version, CompatibilityLevel compatibilityLevel) {
        if (this.type.getComponentType() == Byte.TYPE) {
            return Expressions.let((Expression)SerializerExpressions.readVarInt(in), len -> !this.nullable ? Expressions.let((Expression)Expressions.arrayNew(this.type, (Expression)len), array -> Expressions.sequence((Expression[])new Expression[]{SerializerExpressions.readBytes(in, (Expression)array), array})) : Expressions.ifThenElse((Expression)Expressions.cmpEq((Expression)len, (Expression)Expressions.value((Object)0)), (Expression)Expressions.nullRef(this.type), (Expression)Expressions.let((Expression)Expressions.arrayNew(this.type, (Expression)Expressions.dec((Expression)len)), array -> Expressions.sequence((Expression[])new Expression[]{SerializerExpressions.readBytes(in, (Expression)array, Expressions.value((Object)0), Expressions.dec((Expression)len)), array}))));
        }
        return Expressions.let((Expression)SerializerExpressions.readVarInt(in), len -> !this.nullable ? this.doDecode(staticDecoders, in, version, compatibilityLevel, (Expression)len) : Expressions.ifThenElse((Expression)Expressions.cmpEq((Expression)len, (Expression)Expressions.value((Object)0)), (Expression)Expressions.nullRef(this.type), (Expression)Expressions.let((Expression)Expressions.dec((Expression)len), len0 -> this.doDecode(staticDecoders, in, version, compatibilityLevel, (Expression)len0))));
    }

    private Expression doDecode(SerializerDef.StaticDecoders staticDecoders, Expression in, int version, CompatibilityLevel compatibilityLevel, Expression size) {
        return Expressions.let((Expression)Expressions.arrayNew(this.type, (Expression)size), array -> Expressions.sequence((Expression[])new Expression[]{Expressions.iterate((Expression)Expressions.value((Object)0), (Expression)size, i -> Expressions.arraySet((Expression)array, (Expression)i, (Expression)Expressions.cast((Expression)this.valueSerializer.defineDecoder(staticDecoders, in, version, compatibilityLevel), this.type.getComponentType()))), array}));
    }
}

