/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.impl;

import io.activej.serializer.BinaryInput;
import io.activej.serializer.BinaryOutput;
import io.activej.serializer.BinarySerializer;
import io.activej.serializer.CompatibilityLevel;
import io.activej.serializer.CorruptedDataException;
import io.activej.serializer.SimpleSerializerDef;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public final class SerializerDefInet4Address
extends SimpleSerializerDef<Inet4Address> {
    @Override
    protected BinarySerializer<Inet4Address> createSerializer(int version, CompatibilityLevel compatibilityLevel) {
        return new BinarySerializer<Inet4Address>(){

            @Override
            public void encode(BinaryOutput out, Inet4Address address) {
                out.write(address.getAddress());
            }

            @Override
            public Inet4Address decode(BinaryInput in) throws CorruptedDataException {
                byte[] addressBytes = new byte[4];
                in.read(addressBytes);
                try {
                    return (Inet4Address)Inet4Address.getByAddress(addressBytes);
                }
                catch (UnknownHostException e) {
                    throw new CorruptedDataException(e.getMessage());
                }
            }
        };
    }
}

