/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.stream;

import io.activej.serializer.BinarySerializer;
import io.activej.serializer.stream.StreamCodecs;
import io.activej.serializer.stream.StreamDecoder;
import io.activej.serializer.stream.StreamEncoder;
import io.activej.serializer.stream.StreamInput;
import io.activej.serializer.stream.StreamOutput;
import java.io.IOException;

public interface StreamCodec<T>
extends StreamEncoder<T>,
StreamDecoder<T> {
    public static <T> StreamCodec<T> of(final StreamEncoder<? super T> encoder, final StreamDecoder<? extends T> decoder) {
        return new StreamCodec<T>(){

            @Override
            public void encode(StreamOutput output, T item) throws IOException {
                encoder.encode(output, item);
            }

            @Override
            public T decode(StreamInput input) throws IOException {
                return decoder.decode(input);
            }
        };
    }

    public static <T> StreamCodec<T> ofBinarySerializer(BinarySerializer<T> binarySerializer) {
        return StreamCodec.ofBinarySerializer(binarySerializer, 1);
    }

    public static <T> StreamCodec<T> ofBinarySerializer(BinarySerializer<T> binarySerializer, int estimatedSize) {
        return new StreamCodecs.OfBinarySerializer<T>(binarySerializer, estimatedSize);
    }
}

