/*
 * Decompiled with CFR 0.152.
 */
package io.activej.service;

import io.activej.async.service.EventloopService;
import io.activej.common.Checks;
import io.activej.common.initializer.Initializer;
import io.activej.common.initializer.WithInitializer;
import io.activej.common.reflection.ReflectionUtils;
import io.activej.common.service.BlockingService;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.net.BlockingSocketServer;
import io.activej.inject.Injector;
import io.activej.inject.Key;
import io.activej.inject.Scope;
import io.activej.inject.annotation.Provides;
import io.activej.inject.annotation.ProvidesIntoSet;
import io.activej.inject.binding.Binding;
import io.activej.inject.binding.BindingType;
import io.activej.inject.binding.OptionalDependency;
import io.activej.inject.module.AbstractModule;
import io.activej.inject.util.ScopedKey;
import io.activej.inject.util.Trie;
import io.activej.launcher.LauncherService;
import io.activej.net.EventloopServer;
import io.activej.service.Service;
import io.activej.service.ServiceGraph;
import io.activej.service.ServiceGraphModuleSettings;
import io.activej.service.Utils;
import io.activej.service.adapter.ServiceAdapter;
import io.activej.service.adapter.ServiceAdapters;
import io.activej.worker.WorkerPool;
import io.activej.worker.WorkerPools;
import java.io.Closeable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceGraphModule
extends AbstractModule
implements ServiceGraphModuleSettings,
WithInitializer<ServiceGraphModule> {
    private static final Logger logger = LoggerFactory.getLogger(ServiceGraphModule.class);
    private final Map<Class<?>, ServiceAdapter<?>> registeredServiceAdapters = new LinkedHashMap();
    private final Set<Key<?>> excludedKeys = new LinkedHashSet();
    private final Map<Key<?>, ServiceAdapter<?>> keys = new LinkedHashMap();
    private final Map<Key<?>, Set<Key<?>>> addedDependencies = new HashMap();
    private final Map<Key<?>, Set<Key<?>>> removedDependencies = new HashMap();
    private final Executor executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 10L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());

    public static ServiceGraphModule create() {
        ServiceGraphModule serviceGraphModule = (ServiceGraphModule)new ServiceGraphModule().register(Service.class, ServiceAdapters.forService()).register(BlockingService.class, ServiceAdapters.forBlockingService()).register(Closeable.class, ServiceAdapters.forCloseable()).register(ExecutorService.class, ServiceAdapters.forExecutorService()).register(Timer.class, ServiceAdapters.forTimer()).withInitializer(module -> {
            try {
                Thread.currentThread().getContextClassLoader().loadClass("javax.sql.DataSource");
                module.register(DataSource.class, ServiceAdapters.forDataSource());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        });
        ServiceGraphModule.tryRegisterAsyncComponents(serviceGraphModule);
        return serviceGraphModule;
    }

    @Override
    public <T> ServiceGraphModule register(Class<? extends T> type, ServiceAdapter<T> factory) {
        this.registeredServiceAdapters.put(type, factory);
        return this;
    }

    @Override
    public <T> ServiceGraphModule registerForSpecificKey(Key<T> key, ServiceAdapter<T> factory) {
        this.keys.put(key, factory);
        return this;
    }

    @Override
    public <T> ServiceGraphModule excludeSpecificKey(Key<T> key) {
        this.excludedKeys.add(key);
        return this;
    }

    @Override
    public ServiceGraphModule addDependency(Key<?> key, Key<?> keyDependency) {
        this.addedDependencies.computeIfAbsent(key, key1 -> new HashSet()).add(keyDependency);
        return this;
    }

    @Override
    public ServiceGraphModule removeDependency(Key<?> key, Key<?> keyDependency) {
        this.removedDependencies.computeIfAbsent(key, key1 -> new HashSet()).add(keyDependency);
        return this;
    }

    private static void tryRegisterAsyncComponents(ServiceGraphModule serviceGraphModule) {
        if (ReflectionUtils.isClassPresent((String)"io.activej.eventloop.Eventloop")) {
            serviceGraphModule.register(Eventloop.class, ServiceAdapters.forEventloop()).register(EventloopService.class, ServiceAdapters.forEventloopService());
        }
        if (ReflectionUtils.isClassPresent((String)"io.activej.net.EventloopServer")) {
            serviceGraphModule.register(BlockingSocketServer.class, ServiceAdapters.forBlockingSocketServer()).register(EventloopServer.class, ServiceAdapters.forEventloopServer());
        }
    }

    @Provides
    ServiceGraph serviceGraph(Injector injector) {
        ServiceGraph serviceGraph = ServiceGraph.create();
        serviceGraph.setStartCallback(() -> this.doStart(serviceGraph, injector));
        return serviceGraph;
    }

    @ProvidesIntoSet
    LauncherService service(final ServiceGraph serviceGraph, OptionalDependency<Set<Initializer<ServiceGraphModuleSettings>>> initializers) {
        for (Initializer initializer : (Set)initializers.orElse(Collections.emptySet())) {
            initializer.accept((Object)this);
        }
        return new LauncherService(){

            public CompletableFuture<?> start() {
                CompletableFuture future = new CompletableFuture();
                serviceGraph.startFuture().whenComplete(($, e) -> {
                    if (e == null) {
                        if (logger.isInfoEnabled()) {
                            logger.info("Effective ServiceGraph:\n\n{}", (Object)serviceGraph);
                        }
                        future.complete(null);
                    } else {
                        logger.error("Could not start ServiceGraph", e);
                        if (logger.isInfoEnabled()) {
                            logger.info("Effective ServiceGraph:\n\n{}", (Object)serviceGraph);
                        }
                        logger.warn("Stopping services of partially started ServiceGraph...");
                        serviceGraph.stopFuture().whenComplete(($2, e2) -> {
                            if (e2 != null) {
                                e.addSuppressed((Throwable)e2);
                            }
                            future.completeExceptionally((Throwable)e);
                        });
                    }
                });
                return future;
            }

            public CompletableFuture<?> stop() {
                logger.info("Stopping ServiceGraph...");
                return serviceGraph.stopFuture();
            }
        };
    }

    private void doStart(ServiceGraph serviceGraph, Injector injector) {
        logger.trace("Initializing ServiceGraph ...");
        WorkerPools workerPools = (WorkerPools)injector.peekInstance(WorkerPools.class);
        List pools = workerPools != null ? workerPools.getWorkerPools() : Collections.emptyList();
        HashMap instances = new HashMap();
        HashMap<ServiceKey, Set<ServiceKey>> instanceDependencies = new HashMap<ServiceKey, Set<ServiceKey>>();
        IdentityHashMap<Object, ServiceKey> workerInstanceToKey = new IdentityHashMap<Object, ServiceKey>();
        if (workerPools != null) {
            for (WorkerPool workerPool : pools) {
                Map<Key<?>, Set<ScopedKey>> scopeDependencies = this.getScopeDependencies(injector, workerPool.getScope());
                for (Map.Entry entry : workerPool.peekInstances().entrySet()) {
                    Key key = (Key)entry.getKey();
                    WorkerPool.Instances workerInstances = (WorkerPool.Instances)entry.getValue();
                    if (!scopeDependencies.containsKey(key)) continue;
                    ServiceKey serviceKey = new ServiceKey(key, workerPool);
                    instances.put(serviceKey, workerInstances.getList());
                    workerInstanceToKey.put(workerInstances.get(0), serviceKey);
                    instanceDependencies.put(serviceKey, scopeDependencies.get(key).stream().map(scopedDependency -> scopedDependency.isScoped() ? new ServiceKey(scopedDependency.getKey(), pool) : new ServiceKey(scopedDependency.getKey())).collect(Collectors.toSet()));
                }
            }
        }
        for (Map.Entry entry : injector.peekInstances().entrySet()) {
            Binding binding;
            Key key = (Key)entry.getKey();
            Object instance = entry.getValue();
            if (instance == null || (binding = injector.getBinding(key)) == null || binding.getType() == BindingType.TRANSIENT) continue;
            if (key.getRawType() == OptionalDependency.class && binding.getType() == BindingType.SYNTHETIC) {
                this.excludedKeys.add(key);
            }
            ServiceKey serviceKey = new ServiceKey(key);
            instances.put(serviceKey, Collections.singletonList(instance));
            instanceDependencies.put(serviceKey, binding.getDependencies().stream().map(dependency -> {
                Class dependencyRawType = dependency.getRawType();
                boolean rawTypeMatches = dependencyRawType == WorkerPool.class || dependencyRawType == WorkerPools.class;
                boolean instanceMatches = instance instanceof WorkerPool.Instances;
                if (rawTypeMatches && instanceMatches) {
                    WorkerPool.Instances workerInstances = (WorkerPool.Instances)instance;
                    return (ServiceKey)workerInstanceToKey.get(workerInstances.get(0));
                }
                if (rawTypeMatches && !(instance instanceof WorkerPool)) {
                    logger.warn("Unsupported service {} at {} : worker instances is expected", (Object)key, (Object)binding.getLocation());
                }
                if (instanceMatches) {
                    logger.warn("Unsupported service {} at {} : dependency to WorkerPool or WorkerPools is expected", (Object)key, (Object)binding.getLocation());
                }
                return new ServiceKey((Key)dependency);
            }).collect(Collectors.toSet()));
        }
        this.doStart(serviceGraph, instances, instanceDependencies);
    }

    private Map<Key<?>, Set<ScopedKey>> getScopeDependencies(Injector injector, Scope scope) {
        Trie scopeBindings = injector.getBindingsTrie().getOrDefault((Object)scope, Collections.emptyMap());
        return ((Map)scopeBindings.get()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Binding)entry.getValue()).getDependencies().stream().map(dependencyKey -> ((Map)scopeBindings.get()).containsKey(dependencyKey) ? ScopedKey.of((Scope)scope, (Key)dependencyKey) : ScopedKey.of((Key)dependencyKey)).collect(Collectors.toSet())));
    }

    private void doStart(ServiceGraph serviceGraph, Map<ServiceKey, List<?>> instances, Map<ServiceKey, Set<ServiceKey>> instanceDependencies) {
        ServiceKey serviceKey;
        IdentityHashMap<Object, CachedService> cache = new IdentityHashMap<Object, CachedService>();
        Set unusedKeys = io.activej.common.Utils.difference(this.keys.keySet(), instances.keySet().stream().map(ServiceKey::getKey).collect(Collectors.toSet()));
        if (!unusedKeys.isEmpty()) {
            logger.warn("Unused services : {}", (Object)unusedKeys);
        }
        for (Map.Entry<ServiceKey, List<?>> entry : instances.entrySet()) {
            serviceKey = entry.getKey();
            @Nullable Service service = this.getCombinedServiceOrNull(cache, serviceKey, entry.getValue());
            if (service == null) continue;
            serviceGraph.add((ServiceGraph.Key)serviceKey, service, new ServiceGraph.Key[0]);
        }
        for (Map.Entry<ServiceKey, Collection<Object>> entry : instanceDependencies.entrySet()) {
            serviceKey = entry.getKey();
            Key<?> key = serviceKey.getKey();
            HashSet<Object> dependencies = new HashSet<Object>(entry.getValue());
            if (!io.activej.common.Utils.difference(this.removedDependencies.getOrDefault(key, Collections.emptySet()), dependencies).isEmpty()) {
                logger.warn("Unused removed dependencies for {} : {}", key, (Object)io.activej.common.Utils.difference(this.removedDependencies.getOrDefault(key, Collections.emptySet()), dependencies));
            }
            if (!io.activej.common.Utils.intersection(dependencies, this.addedDependencies.getOrDefault(key, Collections.emptySet())).isEmpty()) {
                logger.warn("Unused added dependencies for {} : {}", key, (Object)io.activej.common.Utils.intersection(dependencies, this.addedDependencies.getOrDefault(key, Collections.emptySet())));
            }
            Set added = this.addedDependencies.getOrDefault(key, Collections.emptySet());
            for (Key k2 : added) {
                List list = instances.keySet().stream().filter(s -> s.getKey().equals((Object)k2)).collect(Collectors.toList());
                if (list.isEmpty()) {
                    throw new IllegalArgumentException("Did not find an instance for the added dependency " + key.getDisplayString());
                }
                if (list.size() > 1) {
                    throw new IllegalArgumentException("Found more than one instance for the added dependency " + key.getDisplayString());
                }
                dependencies.add((ServiceKey)list.get(0));
            }
            Set removed = this.removedDependencies.getOrDefault(key, Collections.emptySet());
            dependencies.removeIf(k -> removed.contains(k.getKey()));
            for (ServiceKey serviceKey2 : dependencies) {
                serviceGraph.add((ServiceGraph.Key)serviceKey, serviceKey2, new ServiceGraph.Key[0]);
            }
        }
        serviceGraph.removeIntermediateNodes();
    }

    @Nullable
    private Service getCombinedServiceOrNull(IdentityHashMap<Object, CachedService> cache, ServiceKey key, List<?> instances) {
        ArrayList<Service> services = new ArrayList<Service>();
        for (Object instance : instances) {
            Service service = this.getServiceOrNull(cache, key.getKey(), instance);
            if (service == null) continue;
            services.add(service);
        }
        if (services.isEmpty()) {
            return null;
        }
        return new CombinedService(services);
    }

    @Nullable
    private <T> Service getServiceOrNull(IdentityHashMap<Object, CachedService> cache, Key<T> key, final @NotNull T instance) {
        CachedService service;
        Object cacheKey = instance;
        if (cacheKey instanceof OptionalDependency) {
            OptionalDependency optionalDependency = (OptionalDependency)cacheKey;
            if (!optionalDependency.isPresent()) {
                return null;
            }
            cacheKey = optionalDependency.get();
        }
        if ((service = cache.get(cacheKey)) != null) {
            return service;
        }
        if (this.excludedKeys.contains(key)) {
            return null;
        }
        final ServiceAdapter<T> serviceAdapter = this.lookupAdapter(key, instance.getClass());
        if (serviceAdapter == null) {
            return null;
        }
        service = new CachedService(new Service(){

            @Override
            public CompletableFuture<?> start() {
                return serviceAdapter.start(instance, ServiceGraphModule.this.executor);
            }

            @Override
            public CompletableFuture<?> stop() {
                return serviceAdapter.stop(instance, ServiceGraphModule.this.executor);
            }
        });
        cache.put(cacheKey, service);
        return service;
    }

    @Nullable
    private <T> ServiceAdapter<T> lookupAdapter(Key<T> key, Class<T> instanceClass) {
        if (key.getRawType() == OptionalDependency.class) {
            Key parameterKey = key.getTypeParameter(0).qualified(key.getQualifier());
            ServiceAdapter<T> serviceAdapter = this.doLookupAdapter(parameterKey, parameterKey.getRawType());
            if (serviceAdapter == null) {
                return null;
            }
            return ServiceAdapters.forOptionalDependency(serviceAdapter);
        }
        return this.doLookupAdapter(key, instanceClass);
    }

    @Nullable
    private <T> ServiceAdapter<T> doLookupAdapter(Key<T> key, Class<T> instanceClass) {
        ServiceAdapter<?> serviceAdapter = this.keys.get(key);
        if (serviceAdapter == null) {
            ArrayList<Class<T>> foundRegisteredClasses = new ArrayList<Class<T>>();
            block0: for (Map.Entry<Class<?>, ServiceAdapter<?>> entry : this.registeredServiceAdapters.entrySet()) {
                Class<T> registeredClass = entry.getKey();
                if (!registeredClass.isAssignableFrom(instanceClass)) continue;
                Iterator iterator = foundRegisteredClasses.iterator();
                while (iterator.hasNext()) {
                    Class foundRegisteredClass = (Class)iterator.next();
                    if (registeredClass.isAssignableFrom(foundRegisteredClass)) continue block0;
                    if (!foundRegisteredClass.isAssignableFrom(registeredClass)) continue;
                    iterator.remove();
                }
                foundRegisteredClasses.add(registeredClass);
            }
            if (foundRegisteredClasses.size() == 1) {
                serviceAdapter = this.registeredServiceAdapters.get(foundRegisteredClasses.get(0));
            }
            if (foundRegisteredClasses.size() > 1) {
                throw new IllegalArgumentException("Ambiguous services found for " + instanceClass + " : " + foundRegisteredClasses + ". Use register() methods to specify service.");
            }
        }
        return serviceAdapter;
    }

    private static final class ServiceKey
    implements ServiceGraph.Key {
        @NotNull
        private final Key<?> key;
        @Nullable
        private final WorkerPool workerPool;

        private ServiceKey(@NotNull Key<?> key) {
            this.key = key;
            this.workerPool = null;
        }

        private ServiceKey(@NotNull Key<?> key, @NotNull WorkerPool workerPool) {
            this.key = key;
            this.workerPool = workerPool;
        }

        @NotNull
        public Key<?> getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public Type getType() {
            return this.key.getType();
        }

        @Override
        @Nullable
        public String getSuffix() {
            return this.workerPool == null ? null : "" + this.workerPool.getSize();
        }

        @Override
        @Nullable
        public String getIndex() {
            return this.workerPool == null || this.workerPool.getId() == 0 ? null : "" + (this.workerPool.getId() + 1);
        }

        @Override
        @Nullable
        public Object getQualifier() {
            return this.key.getQualifier();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceKey other = (ServiceKey)o;
            return this.workerPool == other.workerPool && this.key.equals(other.key);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.workerPool);
        }

        public String toString() {
            return this.key + (this.workerPool == null ? "" : ":" + this.workerPool.getId());
        }
    }

    private static class CombinedService
    implements Service {
        private final List<Service> services;
        private final List<Service> startedServices = new ArrayList<Service>();

        private CombinedService(List<Service> services) {
            this.services = services;
        }

        @Override
        public CompletableFuture<?> start() {
            return ((CompletableFuture)((CompletableFuture)Utils.combineAll(this.services.stream().map(service -> CombinedService.safeCall(service::start).thenRun(() -> {
                CombinedService combinedService = this;
                synchronized (combinedService) {
                    this.startedServices.add((Service)service);
                }
            })).collect(Collectors.toList())).thenApply(v -> null)).exceptionally(e -> e)).thenCompose(e -> e == null ? CompletableFuture.completedFuture(null) : Utils.combineAll(this.startedServices.stream().map(service -> CombinedService.safeCall(service::stop)).collect(Collectors.toList())).thenCompose($ -> Utils.completedExceptionallyFuture(e)));
        }

        @Override
        public CompletableFuture<?> stop() {
            return Utils.combineAll(this.services.stream().map(service -> CombinedService.safeCall(service::stop)).collect(Collectors.toList()));
        }

        private static <T> CompletionStage<T> safeCall(Supplier<? extends CompletionStage<T>> invoke) {
            try {
                return invoke.get();
            }
            catch (Exception e) {
                return Utils.completedExceptionallyFuture(e);
            }
        }
    }

    private static class CachedService
    implements Service {
        private final Service service;
        private int started;
        private CompletableFuture<?> startFuture;
        private CompletableFuture<?> stopFuture;

        private CachedService(Service service) {
            this.service = service;
        }

        @Override
        public synchronized CompletableFuture<?> start() {
            Checks.checkState((this.stopFuture == null ? 1 : 0) != 0, (Object)"Already stopped");
            ++this.started;
            if (this.startFuture == null) {
                this.startFuture = this.service.start();
            }
            return this.startFuture;
        }

        @Override
        public synchronized CompletableFuture<?> stop() {
            Checks.checkState((this.startFuture != null ? 1 : 0) != 0, (Object)"Has not been started yet");
            if (--this.started != 0) {
                return CompletableFuture.completedFuture(null);
            }
            if (this.stopFuture == null) {
                this.stopFuture = this.service.stop();
            }
            return this.stopFuture;
        }
    }
}

