/*
 * Decompiled with CFR 0.152.
 */
package io.activej.service.adapter;

import io.activej.async.service.EventloopService;
import io.activej.common.service.BlockingService;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.net.BlockingSocketServer;
import io.activej.eventloop.util.RunnableWithContext;
import io.activej.inject.binding.OptionalDependency;
import io.activej.net.EventloopServer;
import io.activej.service.Service;
import io.activej.service.adapter.ServiceAdapter;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceAdapters {
    private static final Logger logger = LoggerFactory.getLogger(ServiceAdapters.class);

    public static ServiceAdapter<Service> forService() {
        return new ServiceAdapter<Service>(){

            @Override
            public CompletableFuture<?> start(Service instance, Executor executor) {
                return instance.start();
            }

            @Override
            public CompletableFuture<?> stop(Service instance, Executor executor) {
                return instance.stop();
            }
        };
    }

    public static ServiceAdapter<BlockingService> forBlockingService() {
        return new SimpleServiceAdapter<BlockingService>(){

            @Override
            protected void start(BlockingService instance) throws Exception {
                instance.start();
            }

            @Override
            protected void stop(BlockingService instance) throws Exception {
                instance.stop();
            }
        };
    }

    public static <T> ServiceAdapter<OptionalDependency<T>> forOptionalDependency(final ServiceAdapter<T> adapter) {
        return new ServiceAdapter<OptionalDependency<T>>(){

            @Override
            public CompletableFuture<?> start(OptionalDependency<T> optional, Executor executor) {
                if (optional.isPresent()) {
                    Object instance = optional.get();
                    return adapter.start(instance, executor);
                }
                return CompletableFuture.completedFuture(null);
            }

            @Override
            public CompletableFuture<?> stop(OptionalDependency<T> optional, Executor executor) {
                if (optional.isPresent()) {
                    Object instance = optional.get();
                    return adapter.stop(instance, executor);
                }
                return CompletableFuture.completedFuture(null);
            }
        };
    }

    public static ServiceAdapter<Timer> forTimer() {
        return new SimpleServiceAdapter<Timer>(false, false){

            @Override
            protected void start(Timer instance) {
            }

            @Override
            protected void stop(Timer instance) {
                instance.cancel();
            }
        };
    }

    public static ServiceAdapter<ExecutorService> forExecutorService() {
        return new SimpleServiceAdapter<ExecutorService>(false, true){

            @Override
            protected void start(ExecutorService instance) {
            }

            @Override
            protected void stop(ExecutorService instance) throws Exception {
                instance.shutdown();
                if (!instance.isTerminated()) {
                    logger.warn("Awaiting termination of {} ...", (Object)instance);
                    instance.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    logger.info("Instance {} has been terminated", (Object)instance);
                }
            }
        };
    }

    public static ServiceAdapter<Closeable> forCloseable() {
        return new SimpleServiceAdapter<Closeable>(false, true){

            @Override
            protected void start(Closeable instance) {
            }

            @Override
            protected void stop(Closeable instance) throws Exception {
                instance.close();
            }
        };
    }

    public static ServiceAdapter<DataSource> forDataSource() {
        return new SimpleServiceAdapter<DataSource>(true, false){

            @Override
            protected void start(DataSource instance) throws Exception {
                Connection connection = instance.getConnection();
                connection.close();
            }

            @Override
            protected void stop(DataSource instance) {
            }
        };
    }

    public static ServiceAdapter<EventloopService> forEventloopService() {
        return new ServiceAdapter<EventloopService>(){

            @Override
            public CompletableFuture<?> start(EventloopService instance, Executor executor) {
                CompletableFuture future = new CompletableFuture();
                instance.getEventloop().execute(RunnableWithContext.wrapContext((Object)instance, () -> {
                    try {
                        instance.start().whenResult(future::complete).whenException(future::completeExceptionally);
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                    }
                }));
                return future;
            }

            @Override
            public CompletableFuture<?> stop(EventloopService instance, Executor executor) {
                CompletableFuture future = new CompletableFuture();
                instance.getEventloop().execute(RunnableWithContext.wrapContext((Object)instance, () -> {
                    try {
                        instance.stop().whenResult(future::complete).whenException(future::completeExceptionally);
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                    }
                }));
                return future;
            }
        };
    }

    public static ServiceAdapter<EventloopServer> forEventloopServer() {
        return new ServiceAdapter<EventloopServer>(){

            @Override
            public CompletableFuture<?> start(EventloopServer instance, Executor executor) {
                CompletableFuture future = new CompletableFuture();
                instance.getEventloop().execute(RunnableWithContext.wrapContext((Object)instance, () -> {
                    try {
                        instance.listen();
                        future.complete(null);
                    }
                    catch (IOException e) {
                        future.completeExceptionally(e);
                    }
                }));
                return future;
            }

            @Override
            public CompletableFuture<?> stop(EventloopServer instance, Executor executor) {
                CompletableFuture future = new CompletableFuture();
                instance.getEventloop().execute(RunnableWithContext.wrapContext((Object)instance, () -> instance.close().whenResult(future::complete).whenException(future::completeExceptionally)));
                return future;
            }
        };
    }

    public static ServiceAdapter<Eventloop> forEventloop(final ThreadFactory threadFactory) {
        return new ServiceAdapter<Eventloop>(){

            @Override
            public CompletableFuture<?> start(Eventloop eventloop, Executor executor) {
                CompletableFuture future = new CompletableFuture();
                threadFactory.newThread(() -> {
                    eventloop.keepAlive(true);
                    future.complete(null);
                    eventloop.run();
                }).start();
                return future;
            }

            @Override
            public CompletableFuture<?> stop(Eventloop eventloop, Executor executor) {
                Thread eventloopThread = eventloop.getEventloopThread();
                if (eventloopThread == null) {
                    return CompletableFuture.completedFuture(null);
                }
                CompletableFuture future = new CompletableFuture();
                eventloop.execute(() -> {
                    eventloop.keepAlive(false);
                    this.logStopping(eventloop);
                    Eventloop.logger.info("Waiting for {}", (Object)eventloop);
                });
                executor.execute(() -> {
                    try {
                        eventloopThread.join();
                        future.complete(null);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        future.completeExceptionally(e);
                    }
                });
                return future;
            }

            private void logStopping(Eventloop eventloop) {
                eventloop.delayBackground(1000L, () -> {
                    if (eventloop.getEventloopThread() != null) {
                        Eventloop.logger.info("...Waiting for {}", (Object)eventloop);
                        this.logStopping(eventloop);
                    }
                });
            }
        };
    }

    public static ServiceAdapter<Eventloop> forEventloop() {
        ThreadFactory threadFactory = Executors.defaultThreadFactory();
        return ServiceAdapters.forEventloop(r -> {
            Thread thread = threadFactory.newThread(r);
            thread.setName("eventloop: " + thread.getName());
            return thread;
        });
    }

    public static ServiceAdapter<BlockingSocketServer> forBlockingSocketServer() {
        return new SimpleServiceAdapter<BlockingSocketServer>(){

            @Override
            protected void start(BlockingSocketServer instance) throws Exception {
                instance.start();
            }

            @Override
            protected void stop(BlockingSocketServer instance) throws Exception {
                instance.stop();
            }
        };
    }

    public static <T> ServiceAdapter<T> immediateServiceAdapter() {
        return new SimpleServiceAdapter<T>(false, false){

            @Override
            protected void start(T instance) {
            }

            @Override
            protected void stop(T instance) {
            }
        };
    }

    @SafeVarargs
    public static <T, S extends ServiceAdapter<? super T>> ServiceAdapter<T> combinedAdapter(S ... startOrder) {
        return ServiceAdapters.combinedAdapter(Arrays.asList(startOrder));
    }

    public static <T> ServiceAdapter<T> combinedAdapter(List<? extends ServiceAdapter<? super T>> startOrder) {
        ArrayList<? extends ServiceAdapter<? super T>> stopOrder = new ArrayList<ServiceAdapter<? super T>>(startOrder);
        Collections.reverse(stopOrder);
        return ServiceAdapters.combinedAdapter(startOrder, stopOrder);
    }

    public static <T> ServiceAdapter<T> combinedAdapter(final List<? extends ServiceAdapter<? super T>> startOrder, final List<? extends ServiceAdapter<? super T>> stopOrder) {
        return new ServiceAdapter<T>(){

            private void doAction(T instance, Executor executor, Iterator<? extends ServiceAdapter<? super T>> iterator, CompletableFuture<?> future, Action<T> action) {
                if (iterator.hasNext()) {
                    action.doAction(iterator.next(), (Object)instance, executor).whenCompleteAsync(($, e) -> {
                        if (e == null) {
                            this.doAction(instance, executor, iterator, future, action);
                        } else if (e instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                            future.completeExceptionally((Throwable)e);
                        } else if (e instanceof ExecutionException) {
                            future.completeExceptionally(e.getCause());
                        }
                    }, Runnable::run);
                } else {
                    future.complete(null);
                }
            }

            @Override
            public CompletableFuture<Void> start(T instance, Executor executor) {
                CompletableFuture<Void> future = new CompletableFuture<Void>();
                this.doAction(instance, executor, startOrder.iterator(), future, ServiceAdapter::start);
                return future;
            }

            @Override
            public CompletableFuture<Void> stop(T instance, Executor executor) {
                CompletableFuture<Void> future = new CompletableFuture<Void>();
                this.doAction(instance, executor, stopOrder.iterator(), future, ServiceAdapter::stop);
                return future;
            }
        };
    }

    @FunctionalInterface
    private static interface Action<T> {
        public CompletableFuture<?> doAction(ServiceAdapter<T> var1, T var2, Executor var3);
    }

    public static abstract class SimpleServiceAdapter<S>
    implements ServiceAdapter<S> {
        private final boolean startConcurrently;
        private final boolean stopConcurrently;

        protected SimpleServiceAdapter(boolean startConcurrently, boolean stopConcurrently) {
            this.startConcurrently = startConcurrently;
            this.stopConcurrently = stopConcurrently;
        }

        protected SimpleServiceAdapter() {
            this(true, true);
        }

        protected abstract void start(S var1) throws Exception;

        protected abstract void stop(S var1) throws Exception;

        @Override
        public final CompletableFuture<?> start(S instance, Executor executor) {
            CompletableFuture future = new CompletableFuture();
            (this.startConcurrently ? executor : Runnable::run).execute(() -> {
                try {
                    this.start(instance);
                    future.complete(null);
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            });
            return future;
        }

        @Override
        public final CompletableFuture<?> stop(S instance, Executor executor) {
            CompletableFuture future = new CompletableFuture();
            (this.stopConcurrently ? executor : Runnable::run).execute(() -> {
                try {
                    this.stop(instance);
                    future.complete(null);
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            });
            return future;
        }
    }
}

