/*
 * Decompiled with CFR 0.152.
 */
package io.activej.worker;

import io.activej.inject.Injector;
import io.activej.inject.Key;
import io.activej.inject.Scope;
import io.activej.inject.annotation.ShortTypeName;
import io.activej.inject.binding.Binding;
import io.activej.inject.binding.BindingType;
import io.activej.inject.util.Trie;
import io.activej.worker.annotation.WorkerId;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WorkerPool {
    private final int id;
    private final Scope scope;
    private final Injector[] scopeInjectors;
    private final Map<Key<?>, Binding<?>> scopeBindings;

    WorkerPool(Injector injector, int id, Scope scope, int workers) {
        this.id = id;
        this.scope = scope;
        this.scopeInjectors = new Injector[workers];
        Trie subtrie = injector.getBindingsTrie().get((Object)scope);
        this.scopeBindings = subtrie != null ? (Map)subtrie.get() : Collections.emptyMap();
        for (int i = 0; i < workers; ++i) {
            this.scopeInjectors[i] = injector.enterScope(scope);
            this.scopeInjectors[i].putInstance(Key.of(Integer.TYPE, WorkerId.class), (Object)i);
            this.scopeInjectors[i].createEagerInstances();
        }
    }

    public int getId() {
        return this.id;
    }

    public Scope getScope() {
        return this.scope;
    }

    @NotNull
    public <T> Instances<T> getInstances(Class<T> type) {
        return this.getInstances(Key.of(type));
    }

    @NotNull
    public <T> Instances<T> getInstances(Key<T> key) {
        Object[] instances = new Object[this.scopeInjectors.length];
        for (int i = 0; i < this.scopeInjectors.length; ++i) {
            instances[i] = this.scopeInjectors[i].getInstance(key);
        }
        return new Instances(instances);
    }

    @Nullable
    public <T> Instances<T> peekInstances(Class<T> type) {
        return this.peekInstances(Key.of(type));
    }

    @Nullable
    public <T> Instances<T> peekInstances(Key<T> key) {
        Binding<?> binding = this.scopeBindings.get(key);
        if (binding == null || binding.getType() == BindingType.TRANSIENT) {
            return null;
        }
        Object[] instances = this.doPeekInstances(key);
        if (Arrays.stream(instances).anyMatch(Objects::isNull)) {
            return null;
        }
        return new Instances(instances);
    }

    @NotNull
    public Map<Key<?>, Instances<?>> peekInstances() {
        HashMap map = new HashMap();
        for (Map.Entry<Key<?>, Binding<?>> entry : this.scopeBindings.entrySet()) {
            Object[] instances;
            if (entry.getValue().getType() == BindingType.TRANSIENT || !Arrays.stream(instances = this.doPeekInstances(entry.getKey())).noneMatch(Objects::isNull)) continue;
            map.put(entry.getKey(), new Instances(instances));
        }
        return map;
    }

    private Object[] doPeekInstances(Key<?> key) {
        Object[] instances = new Object[this.getSize()];
        for (int i = 0; i < instances.length; ++i) {
            instances[i] = this.scopeInjectors[i].peekInstance(key);
        }
        return instances;
    }

    public Injector[] getScopeInjectors() {
        return this.scopeInjectors;
    }

    public int getSize() {
        return this.scopeInjectors.length;
    }

    public String toString() {
        return "WorkerPool{scope=" + this.scope + (this.id > 0 ? "id=" + this.id : "") + "}";
    }

    @ShortTypeName(value="WorkerInstances")
    public static final class Instances<T>
    implements Iterable<T> {
        private final Object[] instances;
        private final List<T> list;

        private Instances(Object[] instances) {
            this.instances = instances;
            this.list = Arrays.asList(instances);
        }

        public Object[] getArray() {
            return this.instances;
        }

        public List<T> getList() {
            return this.list;
        }

        public T get(int i) {
            return (T)this.instances[i];
        }

        public int size() {
            return this.instances.length;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return this.list.iterator();
        }
    }
}

