/*
 * Decompiled with CFR 0.152.
 */
package io.adabox.client;

import io.adabox.model.base.Message;
import io.adabox.model.base.Request;
import io.adabox.model.base.Response;
import io.adabox.model.base.iface.LocalChainSync;
import io.adabox.model.base.iface.LocalStateQuery;
import io.adabox.model.base.iface.LocalTxSubmission;
import io.adabox.model.chain.request.RequestNext;
import io.adabox.model.chain.response.AcquireResponse;
import io.adabox.model.chain.response.RequestNextResponse;
import io.adabox.model.query.request.BlockHeightRequest;
import io.adabox.model.query.request.ChainTipRequest;
import io.adabox.model.query.request.CurrentEpochRequest;
import io.adabox.model.query.request.CurrentProtocolParametersRequest;
import io.adabox.model.query.request.GenesisConfigRequest;
import io.adabox.model.query.request.LedgerTipRequest;
import io.adabox.model.query.request.UtxoByAddressRequest;
import io.adabox.model.query.response.BlockHeight;
import io.adabox.model.query.response.ChainTip;
import io.adabox.model.query.response.CurrentEpoch;
import io.adabox.model.query.response.CurrentProtocolParameters;
import io.adabox.model.query.response.GenesisConfig;
import io.adabox.model.query.response.LedgerTip;
import io.adabox.model.query.response.UtxoByAddress;
import io.adabox.model.tx.request.EvaluateTxRequest;
import io.adabox.model.tx.request.SubmitTxRequest;
import io.adabox.model.tx.response.EvaluateTxResponse;
import io.adabox.model.tx.response.SubmitTxResponse;
import java.net.URI;
import java.security.InvalidParameterException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OgmiosWSClient
extends WebSocketClient
implements LocalTxSubmission,
LocalStateQuery,
LocalChainSync {
    private static final Logger log = LoggerFactory.getLogger(OgmiosWSClient.class);
    private static final long TIMEOUT = 60L;
    private final AtomicLong msgId = new AtomicLong();
    private final ConcurrentHashMap<Long, BlockingQueue<Message>> blockingQueueConcurrentHashMap = new ConcurrentHashMap();

    public OgmiosWSClient(URI serverURI) {
        super(serverURI);
    }

    public void onOpen(ServerHandshake serverHandshake) {
        log.info("Connection Established!");
        log.debug("onOpen -> ServerHandshake: {}", (Object)serverHandshake);
    }

    public void onMessage(String message) {
        log.debug("Received: {}", (Object)message);
        Message response = Message.deserialize(message);
        if (response == null) {
            log.error("Response is Null");
            return;
        }
        if (this.blockingQueueConcurrentHashMap.get(response.getMsgId()).offer(response) && log.isDebugEnabled()) {
            log.debug("Message Offered: {}", (Object)message);
        }
    }

    public void onClose(int code, String reason, boolean remote) {
        log.info("Connection closed by {}, Code: {}{}", new Object[]{remote ? "remote peer" : "client", code, reason == null || reason.isEmpty() ? reason : ", Reason: " + reason});
    }

    public void onError(Exception ex) {
        log.error(ex.getMessage());
    }

    private Response send(Request request) {
        Response queryResponse = null;
        long msgIdentifier = this.msgId.incrementAndGet();
        request.setMsgId(msgIdentifier);
        this.send(request.toString());
        ArrayBlockingQueue messageBlockingQueue = new ArrayBlockingQueue(1);
        this.blockingQueueConcurrentHashMap.put(msgIdentifier, messageBlockingQueue);
        try {
            queryResponse = (Response)messageBlockingQueue.poll(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage());
            Thread.currentThread().interrupt();
        }
        return queryResponse;
    }

    @Override
    public AcquireResponse acquire(String point) {
        return null;
    }

    @Override
    public RequestNextResponse requestNext() {
        this.send(new RequestNext(this.msgId.incrementAndGet()).toString());
        return null;
    }

    @Override
    public SubmitTxResponse submitTx(byte[] cborData) throws InvalidParameterException {
        if (cborData.length == 0) {
            throw new InvalidParameterException();
        }
        return (SubmitTxResponse)this.send(new SubmitTxRequest(cborData));
    }

    @Override
    public EvaluateTxResponse evaluateTx(byte[] cborData) throws InvalidParameterException {
        if (cborData.length == 0) {
            throw new InvalidParameterException();
        }
        Response response = this.send(new EvaluateTxRequest(cborData));
        if (response.getFault() == null) {
            return (EvaluateTxResponse)response;
        }
        throw new RuntimeException(response.toString());
    }

    @Override
    public BlockHeight blockHeight() {
        return (BlockHeight)this.send(new BlockHeightRequest());
    }

    @Override
    public ChainTip chainTip() {
        return (ChainTip)this.send(new ChainTipRequest());
    }

    @Override
    public CurrentProtocolParameters currentProtocolParameters() {
        return (CurrentProtocolParameters)this.send(new CurrentProtocolParametersRequest());
    }

    @Override
    public CurrentEpoch currentEpoch() {
        return (CurrentEpoch)this.send(new CurrentEpochRequest());
    }

    @Override
    public LedgerTip ledgerTip() {
        return (LedgerTip)this.send(new LedgerTipRequest());
    }

    @Override
    public UtxoByAddress utxoByAddress(String address) throws InvalidParameterException {
        return (UtxoByAddress)this.send(new UtxoByAddressRequest(address));
    }

    @Override
    public GenesisConfig genesisConfig() {
        return (GenesisConfig)this.send(new GenesisConfigRequest());
    }
}

