/*
 * Decompiled with CFR 0.152.
 */
package io.adabox.model.base;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.adabox.exception.ApiRuntimeException;
import io.adabox.model.base.Error;
import io.adabox.model.base.MethodType;
import io.adabox.model.base.RawResponse;
import io.adabox.model.query.request.base.QueryType;
import io.adabox.model.query.response.base.QueryResponse;
import io.adabox.model.tx.response.EvaluateTxResponse;
import io.adabox.model.tx.response.SubmitTxResponse;
import io.adabox.util.JsonHelper;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Message {
    private static final Logger log = LoggerFactory.getLogger(Message.class);
    private long msgId;

    public static Message deserialize(String messageJson) {
        try {
            RawResponse rawResponse = JsonHelper.toObject(messageJson, RawResponse.class);
            if (rawResponse == null) {
                throw new ApiRuntimeException("Could not parse response");
            }
            long msgId = 0L;
            if (rawResponse.getReflection() != null) {
                msgId = rawResponse.getReflection().get("msg_id").asLong();
            }
            if (rawResponse.getType().equals("jsonwsp/fault")) {
                Error error = new Error(msgId);
                error.setFault(rawResponse.getFault());
            } else {
                MethodType methodType = MethodType.convert(rawResponse.getMethodname());
                switch (Objects.requireNonNull(methodType)) {
                    case SUBMIT_TX: {
                        return SubmitTxResponse.deserialize(msgId, rawResponse.getResult());
                    }
                    case REQUEST_NEXT: {
                        return new Message(0L);
                    }
                    case EVALUATE_TX: {
                        return EvaluateTxResponse.deserialize(msgId, rawResponse.getResult());
                    }
                    case QUERY: {
                        QueryType queryType = QueryType.convert(rawResponse.getReflection().get("object").asText());
                        return QueryResponse.parse(queryType, msgId, rawResponse.getResult());
                    }
                }
            }
        }
        catch (JsonProcessingException e) {
            log.warn("Cannot deserialize message. Message does not contain \"reflection\" parameter", (Throwable)e);
        }
        return null;
    }

    public long getMsgId() {
        return this.msgId;
    }

    public void setMsgId(long msgId) {
        this.msgId = msgId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getMsgId() == other.getMsgId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $msgId = this.getMsgId();
        result = result * 59 + (int)($msgId >>> 32 ^ $msgId);
        return result;
    }

    public String toString() {
        return "Message(msgId=" + this.getMsgId() + ")";
    }

    public Message() {
    }

    public Message(long msgId) {
        this.msgId = msgId;
    }
}

