/*
 * Decompiled with CFR 0.152.
 */
package io.adabox.model.query.response;

import com.fasterxml.jackson.databind.JsonNode;
import io.adabox.model.query.response.base.QueryResponse;
import io.adabox.model.query.response.models.ProtocolParameters;
import java.time.OffsetDateTime;

public class GenesisConfig
extends QueryResponse {
    private String activeSlotsCoefficient;
    private Integer updateQuorum;
    private Integer slotLength;
    private Integer maxKesEvolutions;
    private Integer slotsPerKesPeriod;
    private OffsetDateTime systemStart;
    private ProtocolParameters protocolParameters;
    private Integer epochLength;
    private Integer securityParameter;
    private String maxLovelaceSupply;
    private Integer networkMagic;
    private String network;

    public GenesisConfig(long msgId) {
        super(msgId);
    }

    public static GenesisConfig deserialize(long msgId, JsonNode jsonNode) {
        GenesisConfig genesisConfig = new GenesisConfig(msgId);
        genesisConfig.setActiveSlotsCoefficient(jsonNode.get("activeSlotsCoefficient").asText());
        genesisConfig.setUpdateQuorum(jsonNode.get("updateQuorum").intValue());
        genesisConfig.setSlotLength(jsonNode.get("slotLength").intValue());
        genesisConfig.setMaxKesEvolutions(jsonNode.get("maxKesEvolutions").intValue());
        genesisConfig.setSlotsPerKesPeriod(jsonNode.get("slotsPerKesPeriod").intValue());
        genesisConfig.setSystemStart(OffsetDateTime.parse(jsonNode.get("systemStart").asText()));
        genesisConfig.setProtocolParameters(ProtocolParameters.deserialize(jsonNode.get("protocolParameters")));
        genesisConfig.setEpochLength(jsonNode.get("epochLength").intValue());
        genesisConfig.setSecurityParameter(jsonNode.get("securityParameter").intValue());
        genesisConfig.setMaxLovelaceSupply(jsonNode.get("maxLovelaceSupply").asText());
        genesisConfig.setNetworkMagic(jsonNode.get("networkMagic").intValue());
        genesisConfig.setNetwork(jsonNode.get("network").asText());
        return genesisConfig;
    }

    public String getActiveSlotsCoefficient() {
        return this.activeSlotsCoefficient;
    }

    public Integer getUpdateQuorum() {
        return this.updateQuorum;
    }

    public Integer getSlotLength() {
        return this.slotLength;
    }

    public Integer getMaxKesEvolutions() {
        return this.maxKesEvolutions;
    }

    public Integer getSlotsPerKesPeriod() {
        return this.slotsPerKesPeriod;
    }

    public OffsetDateTime getSystemStart() {
        return this.systemStart;
    }

    public ProtocolParameters getProtocolParameters() {
        return this.protocolParameters;
    }

    public Integer getEpochLength() {
        return this.epochLength;
    }

    public Integer getSecurityParameter() {
        return this.securityParameter;
    }

    public String getMaxLovelaceSupply() {
        return this.maxLovelaceSupply;
    }

    public Integer getNetworkMagic() {
        return this.networkMagic;
    }

    public String getNetwork() {
        return this.network;
    }

    public void setActiveSlotsCoefficient(String activeSlotsCoefficient) {
        this.activeSlotsCoefficient = activeSlotsCoefficient;
    }

    public void setUpdateQuorum(Integer updateQuorum) {
        this.updateQuorum = updateQuorum;
    }

    public void setSlotLength(Integer slotLength) {
        this.slotLength = slotLength;
    }

    public void setMaxKesEvolutions(Integer maxKesEvolutions) {
        this.maxKesEvolutions = maxKesEvolutions;
    }

    public void setSlotsPerKesPeriod(Integer slotsPerKesPeriod) {
        this.slotsPerKesPeriod = slotsPerKesPeriod;
    }

    public void setSystemStart(OffsetDateTime systemStart) {
        this.systemStart = systemStart;
    }

    public void setProtocolParameters(ProtocolParameters protocolParameters) {
        this.protocolParameters = protocolParameters;
    }

    public void setEpochLength(Integer epochLength) {
        this.epochLength = epochLength;
    }

    public void setSecurityParameter(Integer securityParameter) {
        this.securityParameter = securityParameter;
    }

    public void setMaxLovelaceSupply(String maxLovelaceSupply) {
        this.maxLovelaceSupply = maxLovelaceSupply;
    }

    public void setNetworkMagic(Integer networkMagic) {
        this.networkMagic = networkMagic;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    @Override
    public String toString() {
        return "GenesisConfig(activeSlotsCoefficient=" + this.getActiveSlotsCoefficient() + ", updateQuorum=" + this.getUpdateQuorum() + ", slotLength=" + this.getSlotLength() + ", maxKesEvolutions=" + this.getMaxKesEvolutions() + ", slotsPerKesPeriod=" + this.getSlotsPerKesPeriod() + ", systemStart=" + this.getSystemStart() + ", protocolParameters=" + this.getProtocolParameters() + ", epochLength=" + this.getEpochLength() + ", securityParameter=" + this.getSecurityParameter() + ", maxLovelaceSupply=" + this.getMaxLovelaceSupply() + ", networkMagic=" + this.getNetworkMagic() + ", network=" + this.getNetwork() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenesisConfig)) {
            return false;
        }
        GenesisConfig other = (GenesisConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$updateQuorum = this.getUpdateQuorum();
        Integer other$updateQuorum = other.getUpdateQuorum();
        if (this$updateQuorum == null ? other$updateQuorum != null : !((Object)this$updateQuorum).equals(other$updateQuorum)) {
            return false;
        }
        Integer this$slotLength = this.getSlotLength();
        Integer other$slotLength = other.getSlotLength();
        if (this$slotLength == null ? other$slotLength != null : !((Object)this$slotLength).equals(other$slotLength)) {
            return false;
        }
        Integer this$maxKesEvolutions = this.getMaxKesEvolutions();
        Integer other$maxKesEvolutions = other.getMaxKesEvolutions();
        if (this$maxKesEvolutions == null ? other$maxKesEvolutions != null : !((Object)this$maxKesEvolutions).equals(other$maxKesEvolutions)) {
            return false;
        }
        Integer this$slotsPerKesPeriod = this.getSlotsPerKesPeriod();
        Integer other$slotsPerKesPeriod = other.getSlotsPerKesPeriod();
        if (this$slotsPerKesPeriod == null ? other$slotsPerKesPeriod != null : !((Object)this$slotsPerKesPeriod).equals(other$slotsPerKesPeriod)) {
            return false;
        }
        Integer this$epochLength = this.getEpochLength();
        Integer other$epochLength = other.getEpochLength();
        if (this$epochLength == null ? other$epochLength != null : !((Object)this$epochLength).equals(other$epochLength)) {
            return false;
        }
        Integer this$securityParameter = this.getSecurityParameter();
        Integer other$securityParameter = other.getSecurityParameter();
        if (this$securityParameter == null ? other$securityParameter != null : !((Object)this$securityParameter).equals(other$securityParameter)) {
            return false;
        }
        Integer this$networkMagic = this.getNetworkMagic();
        Integer other$networkMagic = other.getNetworkMagic();
        if (this$networkMagic == null ? other$networkMagic != null : !((Object)this$networkMagic).equals(other$networkMagic)) {
            return false;
        }
        String this$activeSlotsCoefficient = this.getActiveSlotsCoefficient();
        String other$activeSlotsCoefficient = other.getActiveSlotsCoefficient();
        if (this$activeSlotsCoefficient == null ? other$activeSlotsCoefficient != null : !this$activeSlotsCoefficient.equals(other$activeSlotsCoefficient)) {
            return false;
        }
        OffsetDateTime this$systemStart = this.getSystemStart();
        OffsetDateTime other$systemStart = other.getSystemStart();
        if (this$systemStart == null ? other$systemStart != null : !((Object)this$systemStart).equals(other$systemStart)) {
            return false;
        }
        ProtocolParameters this$protocolParameters = this.getProtocolParameters();
        ProtocolParameters other$protocolParameters = other.getProtocolParameters();
        if (this$protocolParameters == null ? other$protocolParameters != null : !((Object)this$protocolParameters).equals(other$protocolParameters)) {
            return false;
        }
        String this$maxLovelaceSupply = this.getMaxLovelaceSupply();
        String other$maxLovelaceSupply = other.getMaxLovelaceSupply();
        if (this$maxLovelaceSupply == null ? other$maxLovelaceSupply != null : !this$maxLovelaceSupply.equals(other$maxLovelaceSupply)) {
            return false;
        }
        String this$network = this.getNetwork();
        String other$network = other.getNetwork();
        return !(this$network == null ? other$network != null : !this$network.equals(other$network));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GenesisConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $updateQuorum = this.getUpdateQuorum();
        result = result * 59 + ($updateQuorum == null ? 43 : ((Object)$updateQuorum).hashCode());
        Integer $slotLength = this.getSlotLength();
        result = result * 59 + ($slotLength == null ? 43 : ((Object)$slotLength).hashCode());
        Integer $maxKesEvolutions = this.getMaxKesEvolutions();
        result = result * 59 + ($maxKesEvolutions == null ? 43 : ((Object)$maxKesEvolutions).hashCode());
        Integer $slotsPerKesPeriod = this.getSlotsPerKesPeriod();
        result = result * 59 + ($slotsPerKesPeriod == null ? 43 : ((Object)$slotsPerKesPeriod).hashCode());
        Integer $epochLength = this.getEpochLength();
        result = result * 59 + ($epochLength == null ? 43 : ((Object)$epochLength).hashCode());
        Integer $securityParameter = this.getSecurityParameter();
        result = result * 59 + ($securityParameter == null ? 43 : ((Object)$securityParameter).hashCode());
        Integer $networkMagic = this.getNetworkMagic();
        result = result * 59 + ($networkMagic == null ? 43 : ((Object)$networkMagic).hashCode());
        String $activeSlotsCoefficient = this.getActiveSlotsCoefficient();
        result = result * 59 + ($activeSlotsCoefficient == null ? 43 : $activeSlotsCoefficient.hashCode());
        OffsetDateTime $systemStart = this.getSystemStart();
        result = result * 59 + ($systemStart == null ? 43 : ((Object)$systemStart).hashCode());
        ProtocolParameters $protocolParameters = this.getProtocolParameters();
        result = result * 59 + ($protocolParameters == null ? 43 : ((Object)$protocolParameters).hashCode());
        String $maxLovelaceSupply = this.getMaxLovelaceSupply();
        result = result * 59 + ($maxLovelaceSupply == null ? 43 : $maxLovelaceSupply.hashCode());
        String $network = this.getNetwork();
        result = result * 59 + ($network == null ? 43 : $network.hashCode());
        return result;
    }
}

