/*
 * Decompiled with CFR 0.152.
 */
package io.adabox.model.query.response.models;

import com.fasterxml.jackson.databind.JsonNode;
import io.adabox.model.query.response.models.CostModels;
import io.adabox.model.query.response.models.ExecutionUnit;
import io.adabox.model.query.response.models.Prices;
import io.adabox.model.query.response.models.ProtocolVersion;
import java.math.BigDecimal;

public class ProtocolParameters {
    private Integer minFeeCoefficient;
    private Integer minFeeConstant;
    private Integer maxBlockBodySize;
    private Integer maxBlockHeaderSize;
    private Integer maxTxSize;
    private String stakeKeyDeposit;
    private String poolDeposit;
    private Integer poolRetirementEpochBound;
    private Integer desiredNumberOfPools;
    private String poolInfluence;
    private String monetaryExpansion;
    private String treasuryExpansion;
    private String decentralizationParameter;
    private String extraEntropy;
    private ProtocolVersion protocolVersion;
    private String minUtxoValue;
    private String minPoolCost;
    private String coinsPerUtxoWord;
    private String coinsPerUtxoByte;
    private CostModels costModels;
    private Prices prices;
    private ExecutionUnit maxExecutionUnitsPerTransaction;
    private ExecutionUnit maxExecutionUnitsPerBlock;
    private String maxValueSize;
    private BigDecimal collateralPercentage;
    private Integer maxCollateralInputs;

    public static ProtocolParameters deserialize(JsonNode jsonNode) {
        ProtocolParameters protocolParameters = new ProtocolParameters();
        if (jsonNode.has("minFeeCoefficient")) {
            protocolParameters.setMinFeeCoefficient(jsonNode.get("minFeeCoefficient").intValue());
        }
        if (jsonNode.has("minFeeConstant")) {
            protocolParameters.setMinFeeConstant(jsonNode.get("minFeeConstant").intValue());
        }
        if (jsonNode.has("maxBlockBodySize")) {
            protocolParameters.setMaxBlockBodySize(jsonNode.get("maxBlockBodySize").intValue());
        }
        if (jsonNode.has("maxBlockHeaderSize")) {
            protocolParameters.setMaxBlockHeaderSize(jsonNode.get("maxBlockHeaderSize").intValue());
        }
        if (jsonNode.has("maxTxSize")) {
            protocolParameters.setMaxTxSize(jsonNode.get("maxTxSize").intValue());
        }
        if (jsonNode.has("stakeKeyDeposit")) {
            protocolParameters.setStakeKeyDeposit(jsonNode.get("stakeKeyDeposit").asText());
        }
        if (jsonNode.has("poolDeposit")) {
            protocolParameters.setPoolDeposit(jsonNode.get("poolDeposit").asText());
        }
        if (jsonNode.has("poolRetirementEpochBound")) {
            protocolParameters.setPoolRetirementEpochBound(jsonNode.get("poolRetirementEpochBound").intValue());
        }
        if (jsonNode.has("desiredNumberOfPools")) {
            protocolParameters.setDesiredNumberOfPools(jsonNode.get("desiredNumberOfPools").intValue());
        }
        if (jsonNode.has("poolInfluence")) {
            protocolParameters.setPoolInfluence(jsonNode.get("poolInfluence").asText());
        }
        if (jsonNode.has("monetaryExpansion")) {
            protocolParameters.setMonetaryExpansion(jsonNode.get("monetaryExpansion").asText());
        }
        if (jsonNode.has("treasuryExpansion")) {
            protocolParameters.setTreasuryExpansion(jsonNode.get("treasuryExpansion").asText());
        }
        if (jsonNode.has("decentralizationParameter")) {
            protocolParameters.setDecentralizationParameter(jsonNode.get("decentralizationParameter").asText());
        }
        if (jsonNode.has("extraEntropy")) {
            protocolParameters.setExtraEntropy(jsonNode.get("extraEntropy").asText());
        }
        if (jsonNode.has("protocolVersion")) {
            protocolParameters.setProtocolVersion(ProtocolVersion.deserialize(jsonNode.get("protocolVersion")));
        }
        if (jsonNode.has("minUtxoValue")) {
            protocolParameters.setMinUtxoValue(jsonNode.get("minUtxoValue").asText());
        }
        if (jsonNode.has("minPoolCost")) {
            protocolParameters.setMinPoolCost(jsonNode.get("minPoolCost").asText());
        }
        if (jsonNode.has("coinsPerUtxoWord")) {
            protocolParameters.setCoinsPerUtxoWord(jsonNode.get("coinsPerUtxoWord").asText());
        }
        if (jsonNode.has("coinsPerUtxoByte")) {
            protocolParameters.setCoinsPerUtxoByte(jsonNode.get("coinsPerUtxoByte").asText());
        }
        if (jsonNode.has("costModels")) {
            protocolParameters.setCostModels(CostModels.deserialize(jsonNode.get("costModels")));
        }
        if (jsonNode.has("prices")) {
            protocolParameters.setPrices(Prices.deserialize(jsonNode.get("prices")));
        }
        if (jsonNode.has("maxExecutionUnitsPerTransaction")) {
            protocolParameters.setMaxExecutionUnitsPerTransaction(ExecutionUnit.deserialize(jsonNode.get("maxExecutionUnitsPerTransaction")));
        }
        if (jsonNode.has("maxExecutionUnitsPerBlock")) {
            protocolParameters.setMaxExecutionUnitsPerBlock(ExecutionUnit.deserialize(jsonNode.get("maxExecutionUnitsPerBlock")));
        }
        if (jsonNode.has("maxValueSize")) {
            protocolParameters.setMaxValueSize(jsonNode.get("maxValueSize").asText());
        }
        if (jsonNode.has("collateralPercentage")) {
            protocolParameters.setCollateralPercentage(jsonNode.get("collateralPercentage").decimalValue());
        }
        if (jsonNode.has("maxCollateralInputs")) {
            protocolParameters.setMaxCollateralInputs(jsonNode.get("maxCollateralInputs").intValue());
        }
        return protocolParameters;
    }

    public Integer getMinFeeCoefficient() {
        return this.minFeeCoefficient;
    }

    public Integer getMinFeeConstant() {
        return this.minFeeConstant;
    }

    public Integer getMaxBlockBodySize() {
        return this.maxBlockBodySize;
    }

    public Integer getMaxBlockHeaderSize() {
        return this.maxBlockHeaderSize;
    }

    public Integer getMaxTxSize() {
        return this.maxTxSize;
    }

    public String getStakeKeyDeposit() {
        return this.stakeKeyDeposit;
    }

    public String getPoolDeposit() {
        return this.poolDeposit;
    }

    public Integer getPoolRetirementEpochBound() {
        return this.poolRetirementEpochBound;
    }

    public Integer getDesiredNumberOfPools() {
        return this.desiredNumberOfPools;
    }

    public String getPoolInfluence() {
        return this.poolInfluence;
    }

    public String getMonetaryExpansion() {
        return this.monetaryExpansion;
    }

    public String getTreasuryExpansion() {
        return this.treasuryExpansion;
    }

    public String getDecentralizationParameter() {
        return this.decentralizationParameter;
    }

    public String getExtraEntropy() {
        return this.extraEntropy;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getMinUtxoValue() {
        return this.minUtxoValue;
    }

    public String getMinPoolCost() {
        return this.minPoolCost;
    }

    public String getCoinsPerUtxoWord() {
        return this.coinsPerUtxoWord;
    }

    public String getCoinsPerUtxoByte() {
        return this.coinsPerUtxoByte;
    }

    public CostModels getCostModels() {
        return this.costModels;
    }

    public Prices getPrices() {
        return this.prices;
    }

    public ExecutionUnit getMaxExecutionUnitsPerTransaction() {
        return this.maxExecutionUnitsPerTransaction;
    }

    public ExecutionUnit getMaxExecutionUnitsPerBlock() {
        return this.maxExecutionUnitsPerBlock;
    }

    public String getMaxValueSize() {
        return this.maxValueSize;
    }

    public BigDecimal getCollateralPercentage() {
        return this.collateralPercentage;
    }

    public Integer getMaxCollateralInputs() {
        return this.maxCollateralInputs;
    }

    public void setMinFeeCoefficient(Integer minFeeCoefficient) {
        this.minFeeCoefficient = minFeeCoefficient;
    }

    public void setMinFeeConstant(Integer minFeeConstant) {
        this.minFeeConstant = minFeeConstant;
    }

    public void setMaxBlockBodySize(Integer maxBlockBodySize) {
        this.maxBlockBodySize = maxBlockBodySize;
    }

    public void setMaxBlockHeaderSize(Integer maxBlockHeaderSize) {
        this.maxBlockHeaderSize = maxBlockHeaderSize;
    }

    public void setMaxTxSize(Integer maxTxSize) {
        this.maxTxSize = maxTxSize;
    }

    public void setStakeKeyDeposit(String stakeKeyDeposit) {
        this.stakeKeyDeposit = stakeKeyDeposit;
    }

    public void setPoolDeposit(String poolDeposit) {
        this.poolDeposit = poolDeposit;
    }

    public void setPoolRetirementEpochBound(Integer poolRetirementEpochBound) {
        this.poolRetirementEpochBound = poolRetirementEpochBound;
    }

    public void setDesiredNumberOfPools(Integer desiredNumberOfPools) {
        this.desiredNumberOfPools = desiredNumberOfPools;
    }

    public void setPoolInfluence(String poolInfluence) {
        this.poolInfluence = poolInfluence;
    }

    public void setMonetaryExpansion(String monetaryExpansion) {
        this.monetaryExpansion = monetaryExpansion;
    }

    public void setTreasuryExpansion(String treasuryExpansion) {
        this.treasuryExpansion = treasuryExpansion;
    }

    public void setDecentralizationParameter(String decentralizationParameter) {
        this.decentralizationParameter = decentralizationParameter;
    }

    public void setExtraEntropy(String extraEntropy) {
        this.extraEntropy = extraEntropy;
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setMinUtxoValue(String minUtxoValue) {
        this.minUtxoValue = minUtxoValue;
    }

    public void setMinPoolCost(String minPoolCost) {
        this.minPoolCost = minPoolCost;
    }

    public void setCoinsPerUtxoWord(String coinsPerUtxoWord) {
        this.coinsPerUtxoWord = coinsPerUtxoWord;
    }

    public void setCoinsPerUtxoByte(String coinsPerUtxoByte) {
        this.coinsPerUtxoByte = coinsPerUtxoByte;
    }

    public void setCostModels(CostModels costModels) {
        this.costModels = costModels;
    }

    public void setPrices(Prices prices) {
        this.prices = prices;
    }

    public void setMaxExecutionUnitsPerTransaction(ExecutionUnit maxExecutionUnitsPerTransaction) {
        this.maxExecutionUnitsPerTransaction = maxExecutionUnitsPerTransaction;
    }

    public void setMaxExecutionUnitsPerBlock(ExecutionUnit maxExecutionUnitsPerBlock) {
        this.maxExecutionUnitsPerBlock = maxExecutionUnitsPerBlock;
    }

    public void setMaxValueSize(String maxValueSize) {
        this.maxValueSize = maxValueSize;
    }

    public void setCollateralPercentage(BigDecimal collateralPercentage) {
        this.collateralPercentage = collateralPercentage;
    }

    public void setMaxCollateralInputs(Integer maxCollateralInputs) {
        this.maxCollateralInputs = maxCollateralInputs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtocolParameters)) {
            return false;
        }
        ProtocolParameters other = (ProtocolParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$minFeeCoefficient = this.getMinFeeCoefficient();
        Integer other$minFeeCoefficient = other.getMinFeeCoefficient();
        if (this$minFeeCoefficient == null ? other$minFeeCoefficient != null : !((Object)this$minFeeCoefficient).equals(other$minFeeCoefficient)) {
            return false;
        }
        Integer this$minFeeConstant = this.getMinFeeConstant();
        Integer other$minFeeConstant = other.getMinFeeConstant();
        if (this$minFeeConstant == null ? other$minFeeConstant != null : !((Object)this$minFeeConstant).equals(other$minFeeConstant)) {
            return false;
        }
        Integer this$maxBlockBodySize = this.getMaxBlockBodySize();
        Integer other$maxBlockBodySize = other.getMaxBlockBodySize();
        if (this$maxBlockBodySize == null ? other$maxBlockBodySize != null : !((Object)this$maxBlockBodySize).equals(other$maxBlockBodySize)) {
            return false;
        }
        Integer this$maxBlockHeaderSize = this.getMaxBlockHeaderSize();
        Integer other$maxBlockHeaderSize = other.getMaxBlockHeaderSize();
        if (this$maxBlockHeaderSize == null ? other$maxBlockHeaderSize != null : !((Object)this$maxBlockHeaderSize).equals(other$maxBlockHeaderSize)) {
            return false;
        }
        Integer this$maxTxSize = this.getMaxTxSize();
        Integer other$maxTxSize = other.getMaxTxSize();
        if (this$maxTxSize == null ? other$maxTxSize != null : !((Object)this$maxTxSize).equals(other$maxTxSize)) {
            return false;
        }
        Integer this$poolRetirementEpochBound = this.getPoolRetirementEpochBound();
        Integer other$poolRetirementEpochBound = other.getPoolRetirementEpochBound();
        if (this$poolRetirementEpochBound == null ? other$poolRetirementEpochBound != null : !((Object)this$poolRetirementEpochBound).equals(other$poolRetirementEpochBound)) {
            return false;
        }
        Integer this$desiredNumberOfPools = this.getDesiredNumberOfPools();
        Integer other$desiredNumberOfPools = other.getDesiredNumberOfPools();
        if (this$desiredNumberOfPools == null ? other$desiredNumberOfPools != null : !((Object)this$desiredNumberOfPools).equals(other$desiredNumberOfPools)) {
            return false;
        }
        Integer this$maxCollateralInputs = this.getMaxCollateralInputs();
        Integer other$maxCollateralInputs = other.getMaxCollateralInputs();
        if (this$maxCollateralInputs == null ? other$maxCollateralInputs != null : !((Object)this$maxCollateralInputs).equals(other$maxCollateralInputs)) {
            return false;
        }
        String this$stakeKeyDeposit = this.getStakeKeyDeposit();
        String other$stakeKeyDeposit = other.getStakeKeyDeposit();
        if (this$stakeKeyDeposit == null ? other$stakeKeyDeposit != null : !this$stakeKeyDeposit.equals(other$stakeKeyDeposit)) {
            return false;
        }
        String this$poolDeposit = this.getPoolDeposit();
        String other$poolDeposit = other.getPoolDeposit();
        if (this$poolDeposit == null ? other$poolDeposit != null : !this$poolDeposit.equals(other$poolDeposit)) {
            return false;
        }
        String this$poolInfluence = this.getPoolInfluence();
        String other$poolInfluence = other.getPoolInfluence();
        if (this$poolInfluence == null ? other$poolInfluence != null : !this$poolInfluence.equals(other$poolInfluence)) {
            return false;
        }
        String this$monetaryExpansion = this.getMonetaryExpansion();
        String other$monetaryExpansion = other.getMonetaryExpansion();
        if (this$monetaryExpansion == null ? other$monetaryExpansion != null : !this$monetaryExpansion.equals(other$monetaryExpansion)) {
            return false;
        }
        String this$treasuryExpansion = this.getTreasuryExpansion();
        String other$treasuryExpansion = other.getTreasuryExpansion();
        if (this$treasuryExpansion == null ? other$treasuryExpansion != null : !this$treasuryExpansion.equals(other$treasuryExpansion)) {
            return false;
        }
        String this$decentralizationParameter = this.getDecentralizationParameter();
        String other$decentralizationParameter = other.getDecentralizationParameter();
        if (this$decentralizationParameter == null ? other$decentralizationParameter != null : !this$decentralizationParameter.equals(other$decentralizationParameter)) {
            return false;
        }
        String this$extraEntropy = this.getExtraEntropy();
        String other$extraEntropy = other.getExtraEntropy();
        if (this$extraEntropy == null ? other$extraEntropy != null : !this$extraEntropy.equals(other$extraEntropy)) {
            return false;
        }
        ProtocolVersion this$protocolVersion = this.getProtocolVersion();
        ProtocolVersion other$protocolVersion = other.getProtocolVersion();
        if (this$protocolVersion == null ? other$protocolVersion != null : !((Object)this$protocolVersion).equals(other$protocolVersion)) {
            return false;
        }
        String this$minUtxoValue = this.getMinUtxoValue();
        String other$minUtxoValue = other.getMinUtxoValue();
        if (this$minUtxoValue == null ? other$minUtxoValue != null : !this$minUtxoValue.equals(other$minUtxoValue)) {
            return false;
        }
        String this$minPoolCost = this.getMinPoolCost();
        String other$minPoolCost = other.getMinPoolCost();
        if (this$minPoolCost == null ? other$minPoolCost != null : !this$minPoolCost.equals(other$minPoolCost)) {
            return false;
        }
        String this$coinsPerUtxoWord = this.getCoinsPerUtxoWord();
        String other$coinsPerUtxoWord = other.getCoinsPerUtxoWord();
        if (this$coinsPerUtxoWord == null ? other$coinsPerUtxoWord != null : !this$coinsPerUtxoWord.equals(other$coinsPerUtxoWord)) {
            return false;
        }
        String this$coinsPerUtxoByte = this.getCoinsPerUtxoByte();
        String other$coinsPerUtxoByte = other.getCoinsPerUtxoByte();
        if (this$coinsPerUtxoByte == null ? other$coinsPerUtxoByte != null : !this$coinsPerUtxoByte.equals(other$coinsPerUtxoByte)) {
            return false;
        }
        CostModels this$costModels = this.getCostModels();
        CostModels other$costModels = other.getCostModels();
        if (this$costModels == null ? other$costModels != null : !((Object)this$costModels).equals(other$costModels)) {
            return false;
        }
        Prices this$prices = this.getPrices();
        Prices other$prices = other.getPrices();
        if (this$prices == null ? other$prices != null : !this$prices.equals(other$prices)) {
            return false;
        }
        ExecutionUnit this$maxExecutionUnitsPerTransaction = this.getMaxExecutionUnitsPerTransaction();
        ExecutionUnit other$maxExecutionUnitsPerTransaction = other.getMaxExecutionUnitsPerTransaction();
        if (this$maxExecutionUnitsPerTransaction == null ? other$maxExecutionUnitsPerTransaction != null : !this$maxExecutionUnitsPerTransaction.equals(other$maxExecutionUnitsPerTransaction)) {
            return false;
        }
        ExecutionUnit this$maxExecutionUnitsPerBlock = this.getMaxExecutionUnitsPerBlock();
        ExecutionUnit other$maxExecutionUnitsPerBlock = other.getMaxExecutionUnitsPerBlock();
        if (this$maxExecutionUnitsPerBlock == null ? other$maxExecutionUnitsPerBlock != null : !this$maxExecutionUnitsPerBlock.equals(other$maxExecutionUnitsPerBlock)) {
            return false;
        }
        String this$maxValueSize = this.getMaxValueSize();
        String other$maxValueSize = other.getMaxValueSize();
        if (this$maxValueSize == null ? other$maxValueSize != null : !this$maxValueSize.equals(other$maxValueSize)) {
            return false;
        }
        BigDecimal this$collateralPercentage = this.getCollateralPercentage();
        BigDecimal other$collateralPercentage = other.getCollateralPercentage();
        return !(this$collateralPercentage == null ? other$collateralPercentage != null : !((Object)this$collateralPercentage).equals(other$collateralPercentage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProtocolParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $minFeeCoefficient = this.getMinFeeCoefficient();
        result = result * 59 + ($minFeeCoefficient == null ? 43 : ((Object)$minFeeCoefficient).hashCode());
        Integer $minFeeConstant = this.getMinFeeConstant();
        result = result * 59 + ($minFeeConstant == null ? 43 : ((Object)$minFeeConstant).hashCode());
        Integer $maxBlockBodySize = this.getMaxBlockBodySize();
        result = result * 59 + ($maxBlockBodySize == null ? 43 : ((Object)$maxBlockBodySize).hashCode());
        Integer $maxBlockHeaderSize = this.getMaxBlockHeaderSize();
        result = result * 59 + ($maxBlockHeaderSize == null ? 43 : ((Object)$maxBlockHeaderSize).hashCode());
        Integer $maxTxSize = this.getMaxTxSize();
        result = result * 59 + ($maxTxSize == null ? 43 : ((Object)$maxTxSize).hashCode());
        Integer $poolRetirementEpochBound = this.getPoolRetirementEpochBound();
        result = result * 59 + ($poolRetirementEpochBound == null ? 43 : ((Object)$poolRetirementEpochBound).hashCode());
        Integer $desiredNumberOfPools = this.getDesiredNumberOfPools();
        result = result * 59 + ($desiredNumberOfPools == null ? 43 : ((Object)$desiredNumberOfPools).hashCode());
        Integer $maxCollateralInputs = this.getMaxCollateralInputs();
        result = result * 59 + ($maxCollateralInputs == null ? 43 : ((Object)$maxCollateralInputs).hashCode());
        String $stakeKeyDeposit = this.getStakeKeyDeposit();
        result = result * 59 + ($stakeKeyDeposit == null ? 43 : $stakeKeyDeposit.hashCode());
        String $poolDeposit = this.getPoolDeposit();
        result = result * 59 + ($poolDeposit == null ? 43 : $poolDeposit.hashCode());
        String $poolInfluence = this.getPoolInfluence();
        result = result * 59 + ($poolInfluence == null ? 43 : $poolInfluence.hashCode());
        String $monetaryExpansion = this.getMonetaryExpansion();
        result = result * 59 + ($monetaryExpansion == null ? 43 : $monetaryExpansion.hashCode());
        String $treasuryExpansion = this.getTreasuryExpansion();
        result = result * 59 + ($treasuryExpansion == null ? 43 : $treasuryExpansion.hashCode());
        String $decentralizationParameter = this.getDecentralizationParameter();
        result = result * 59 + ($decentralizationParameter == null ? 43 : $decentralizationParameter.hashCode());
        String $extraEntropy = this.getExtraEntropy();
        result = result * 59 + ($extraEntropy == null ? 43 : $extraEntropy.hashCode());
        ProtocolVersion $protocolVersion = this.getProtocolVersion();
        result = result * 59 + ($protocolVersion == null ? 43 : ((Object)$protocolVersion).hashCode());
        String $minUtxoValue = this.getMinUtxoValue();
        result = result * 59 + ($minUtxoValue == null ? 43 : $minUtxoValue.hashCode());
        String $minPoolCost = this.getMinPoolCost();
        result = result * 59 + ($minPoolCost == null ? 43 : $minPoolCost.hashCode());
        String $coinsPerUtxoWord = this.getCoinsPerUtxoWord();
        result = result * 59 + ($coinsPerUtxoWord == null ? 43 : $coinsPerUtxoWord.hashCode());
        String $coinsPerUtxoByte = this.getCoinsPerUtxoByte();
        result = result * 59 + ($coinsPerUtxoByte == null ? 43 : $coinsPerUtxoByte.hashCode());
        CostModels $costModels = this.getCostModels();
        result = result * 59 + ($costModels == null ? 43 : ((Object)$costModels).hashCode());
        Prices $prices = this.getPrices();
        result = result * 59 + ($prices == null ? 43 : $prices.hashCode());
        ExecutionUnit $maxExecutionUnitsPerTransaction = this.getMaxExecutionUnitsPerTransaction();
        result = result * 59 + ($maxExecutionUnitsPerTransaction == null ? 43 : $maxExecutionUnitsPerTransaction.hashCode());
        ExecutionUnit $maxExecutionUnitsPerBlock = this.getMaxExecutionUnitsPerBlock();
        result = result * 59 + ($maxExecutionUnitsPerBlock == null ? 43 : $maxExecutionUnitsPerBlock.hashCode());
        String $maxValueSize = this.getMaxValueSize();
        result = result * 59 + ($maxValueSize == null ? 43 : $maxValueSize.hashCode());
        BigDecimal $collateralPercentage = this.getCollateralPercentage();
        result = result * 59 + ($collateralPercentage == null ? 43 : ((Object)$collateralPercentage).hashCode());
        return result;
    }

    public String toString() {
        return "ProtocolParameters(minFeeCoefficient=" + this.getMinFeeCoefficient() + ", minFeeConstant=" + this.getMinFeeConstant() + ", maxBlockBodySize=" + this.getMaxBlockBodySize() + ", maxBlockHeaderSize=" + this.getMaxBlockHeaderSize() + ", maxTxSize=" + this.getMaxTxSize() + ", stakeKeyDeposit=" + this.getStakeKeyDeposit() + ", poolDeposit=" + this.getPoolDeposit() + ", poolRetirementEpochBound=" + this.getPoolRetirementEpochBound() + ", desiredNumberOfPools=" + this.getDesiredNumberOfPools() + ", poolInfluence=" + this.getPoolInfluence() + ", monetaryExpansion=" + this.getMonetaryExpansion() + ", treasuryExpansion=" + this.getTreasuryExpansion() + ", decentralizationParameter=" + this.getDecentralizationParameter() + ", extraEntropy=" + this.getExtraEntropy() + ", protocolVersion=" + this.getProtocolVersion() + ", minUtxoValue=" + this.getMinUtxoValue() + ", minPoolCost=" + this.getMinPoolCost() + ", coinsPerUtxoWord=" + this.getCoinsPerUtxoWord() + ", coinsPerUtxoByte=" + this.getCoinsPerUtxoByte() + ", costModels=" + this.getCostModels() + ", prices=" + this.getPrices() + ", maxExecutionUnitsPerTransaction=" + this.getMaxExecutionUnitsPerTransaction() + ", maxExecutionUnitsPerBlock=" + this.getMaxExecutionUnitsPerBlock() + ", maxValueSize=" + this.getMaxValueSize() + ", collateralPercentage=" + this.getCollateralPercentage() + ", maxCollateralInputs=" + this.getMaxCollateralInputs() + ")";
    }
}

