/*
 * Decompiled with CFR 0.152.
 */
package io.adabox.model.query.response.models;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.adabox.model.Amount;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Utxo {
    private String txId;
    private Long index;
    private List<Amount> amountList;
    private String datum;

    public static Utxo deserialize(ArrayNode arrayNode) {
        Object utxo = null;
        Iterator iterator = arrayNode.iterator();
        String txId = null;
        Long index = null;
        List<Amount> amountList = null;
        String datum = null;
        while (iterator.hasNext()) {
            JsonNode jsonObject = (JsonNode)iterator.next();
            if (jsonObject.has("txId")) {
                txId = jsonObject.get("txId").asText();
            }
            if (jsonObject.has("index")) {
                index = jsonObject.get("index").asLong();
            }
            if (jsonObject.has("value")) {
                amountList = Utxo.deserializeAmountList(jsonObject.get("value"));
            }
            if (!jsonObject.has("datum")) continue;
            datum = jsonObject.get("datum").asText();
        }
        return new Utxo(txId, index, amountList, datum);
    }

    private static List<Amount> deserializeAmountList(JsonNode jsonNode) {
        ArrayList<Amount> amountList = new ArrayList<Amount>();
        amountList.add(new Amount("lovelace", jsonNode.get("coins").bigIntegerValue()));
        JsonNode assets = jsonNode.get("assets");
        Iterator iterator = assets.fieldNames();
        while (iterator.hasNext()) {
            String unit = (String)iterator.next();
            amountList.add(new Amount(unit, assets.get(unit).bigIntegerValue()));
        }
        return amountList;
    }

    public String getTxId() {
        return this.txId;
    }

    public Long getIndex() {
        return this.index;
    }

    public List<Amount> getAmountList() {
        return this.amountList;
    }

    public String getDatum() {
        return this.datum;
    }

    public void setTxId(String txId) {
        this.txId = txId;
    }

    public void setIndex(Long index) {
        this.index = index;
    }

    public void setAmountList(List<Amount> amountList) {
        this.amountList = amountList;
    }

    public void setDatum(String datum) {
        this.datum = datum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Utxo)) {
            return false;
        }
        Utxo other = (Utxo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$index = this.getIndex();
        Long other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        String this$txId = this.getTxId();
        String other$txId = other.getTxId();
        if (this$txId == null ? other$txId != null : !this$txId.equals(other$txId)) {
            return false;
        }
        List<Amount> this$amountList = this.getAmountList();
        List<Amount> other$amountList = other.getAmountList();
        if (this$amountList == null ? other$amountList != null : !((Object)this$amountList).equals(other$amountList)) {
            return false;
        }
        String this$datum = this.getDatum();
        String other$datum = other.getDatum();
        return !(this$datum == null ? other$datum != null : !this$datum.equals(other$datum));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Utxo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        String $txId = this.getTxId();
        result = result * 59 + ($txId == null ? 43 : $txId.hashCode());
        List<Amount> $amountList = this.getAmountList();
        result = result * 59 + ($amountList == null ? 43 : ((Object)$amountList).hashCode());
        String $datum = this.getDatum();
        result = result * 59 + ($datum == null ? 43 : $datum.hashCode());
        return result;
    }

    public String toString() {
        return "Utxo(txId=" + this.getTxId() + ", index=" + this.getIndex() + ", amountList=" + this.getAmountList() + ", datum=" + this.getDatum() + ")";
    }

    public Utxo(String txId, Long index, List<Amount> amountList, String datum) {
        this.txId = txId;
        this.index = index;
        this.amountList = amountList;
        this.datum = datum;
    }
}

