/*
 * Decompiled with CFR 0.152.
 */
package io.adabox.model.tx.request;

import io.adabox.model.base.MethodType;
import io.adabox.model.base.Request;
import io.adabox.util.HexUtil;
import java.util.Arrays;

public class EvaluateTxRequest
extends Request {
    private static final MethodType METHOD_TYPE = MethodType.EVALUATE_TX;
    private final byte[] cborBytes;

    public EvaluateTxRequest(byte[] cborBytes) {
        this.cborBytes = cborBytes;
    }

    @Override
    protected String getMethodType() {
        return METHOD_TYPE.getValue();
    }

    @Override
    public String getArgs() {
        return "\"evaluate\":\"" + HexUtil.encodeHexString(this.cborBytes) + "\"";
    }

    @Override
    public String getMirror() {
        return "\"object\":\"" + METHOD_TYPE.getValue() + "\",\"msg_id\":" + this.getMsgId();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EvaluateTxRequest)) {
            return false;
        }
        EvaluateTxRequest other = (EvaluateTxRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.cborBytes, other.cborBytes);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EvaluateTxRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.cborBytes);
        return result;
    }
}

