/*
 * Decompiled with CFR 0.152.
 */
package io.adabox.model.tx.request;

import io.adabox.model.base.MethodType;
import io.adabox.model.base.Request;
import java.util.Arrays;
import java.util.Base64;

public class SubmitTxRequest
extends Request {
    private static final MethodType METHOD_TYPE = MethodType.SUBMIT_TX;
    private final byte[] bytes;

    public SubmitTxRequest(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public String getMethodType() {
        return METHOD_TYPE.getValue();
    }

    @Override
    public String getArgs() {
        return "\"bytes\":\"" + Base64.getEncoder().encodeToString(this.bytes) + "\"";
    }

    @Override
    public String getMirror() {
        return "\"object\":\"" + METHOD_TYPE.getValue() + "\",\"msg_id\":" + this.getMsgId();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubmitTxRequest)) {
            return false;
        }
        SubmitTxRequest other = (SubmitTxRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.bytes, other.bytes);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SubmitTxRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.bytes);
        return result;
    }
}

