/*
 * Decompiled with CFR 0.152.
 */
package io.adabox.model.tx.response;

import com.fasterxml.jackson.databind.JsonNode;
import io.adabox.model.base.Response;
import io.adabox.model.tx.response.EvaluationFailure;
import io.adabox.model.tx.response.EvaluationResult;
import io.adabox.model.tx.response.ExUnits;
import io.adabox.model.tx.response.RedeemerTag;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EvaluateTxResponse
extends Response {
    private EvaluationFailure evaluationFailure;
    private List<EvaluationResult> evaluationResults;

    public EvaluateTxResponse(long msgId) {
        super(msgId);
    }

    public static EvaluateTxResponse deserialize(long msgId, JsonNode result) {
        EvaluateTxResponse evaluateTxResponse = new EvaluateTxResponse(msgId);
        if (result.has("EvaluationFailure")) {
            evaluateTxResponse.setEvaluationFailure(new EvaluationFailure(result.get("EvaluationFailure").toString()));
        }
        ArrayList<EvaluationResult> evaluationResults = new ArrayList<EvaluationResult>();
        if (result.has("EvaluationResult")) {
            JsonNode evaluationResultsObj = result.get("EvaluationResult");
            Iterator keys = evaluationResultsObj.fieldNames();
            while (keys.hasNext()) {
                RedeemerTag redeemerTag;
                String redeemerPointer = (String)keys.next();
                JsonNode evalRes = evaluationResultsObj.get(redeemerPointer);
                BigInteger memory = evalRes.get("memory").bigIntegerValue();
                BigInteger steps = evalRes.get("steps").bigIntegerValue();
                String[] splits = redeemerPointer.split(":");
                if (splits.length != 2) {
                    throw new RuntimeException("Invalid redeemer pointer : " + evaluationResultsObj);
                }
                if ("spend".equals(splits[0])) {
                    redeemerTag = RedeemerTag.Spend;
                } else if ("mint".equals(splits[0])) {
                    redeemerTag = RedeemerTag.Mint;
                } else if ("certificate".equals(splits[0])) {
                    redeemerTag = RedeemerTag.Cert;
                } else if ("withdrawal".equals(splits[0])) {
                    redeemerTag = RedeemerTag.Reward;
                } else {
                    throw new RuntimeException("Invalid RedeemerTag in evaluateTx reponse: " + splits[0]);
                }
                EvaluationResult evaluationResult = new EvaluationResult();
                evaluationResult.setRedeemerTag(redeemerTag);
                evaluationResult.setIndex(Integer.parseInt(splits[1]));
                ExUnits exUnits = ExUnits.builder().mem(memory).steps(steps).build();
                evaluationResult.setExUnits(exUnits);
                evaluationResults.add(evaluationResult);
            }
        }
        evaluateTxResponse.setEvaluationResults(evaluationResults);
        return evaluateTxResponse;
    }

    public EvaluationFailure getEvaluationFailure() {
        return this.evaluationFailure;
    }

    public List<EvaluationResult> getEvaluationResults() {
        return this.evaluationResults;
    }

    public void setEvaluationFailure(EvaluationFailure evaluationFailure) {
        this.evaluationFailure = evaluationFailure;
    }

    public void setEvaluationResults(List<EvaluationResult> evaluationResults) {
        this.evaluationResults = evaluationResults;
    }

    @Override
    public String toString() {
        return "EvaluateTxResponse(evaluationFailure=" + this.getEvaluationFailure() + ", evaluationResults=" + this.getEvaluationResults() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EvaluateTxResponse)) {
            return false;
        }
        EvaluateTxResponse other = (EvaluateTxResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EvaluationFailure this$evaluationFailure = this.getEvaluationFailure();
        EvaluationFailure other$evaluationFailure = other.getEvaluationFailure();
        if (this$evaluationFailure == null ? other$evaluationFailure != null : !((Object)this$evaluationFailure).equals(other$evaluationFailure)) {
            return false;
        }
        List<EvaluationResult> this$evaluationResults = this.getEvaluationResults();
        List<EvaluationResult> other$evaluationResults = other.getEvaluationResults();
        return !(this$evaluationResults == null ? other$evaluationResults != null : !((Object)this$evaluationResults).equals(other$evaluationResults));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EvaluateTxResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        EvaluationFailure $evaluationFailure = this.getEvaluationFailure();
        result = result * 59 + ($evaluationFailure == null ? 43 : ((Object)$evaluationFailure).hashCode());
        List<EvaluationResult> $evaluationResults = this.getEvaluationResults();
        result = result * 59 + ($evaluationResults == null ? 43 : ((Object)$evaluationResults).hashCode());
        return result;
    }
}

