/*
 * Decompiled with CFR 0.152.
 */
package io.adabox.model.tx.response;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.adabox.model.tx.response.TxError;
import io.adabox.model.tx.response.TxErrorType;
import java.util.ArrayList;
import java.util.List;

class InvalidWitnesses
extends TxError {
    private List<String> witnesses;

    public InvalidWitnesses(List<String> witnesses) {
        super(TxErrorType.INVALID_WITNESSES);
        this.setWitnesses(witnesses);
    }

    public static InvalidWitnesses deserialize(ArrayNode invalidWitnessesEntity) {
        ArrayList<String> witnesses = new ArrayList<String>();
        for (JsonNode o : invalidWitnessesEntity) {
            witnesses.add(o.asText());
        }
        return new InvalidWitnesses(witnesses);
    }

    public List<String> getWitnesses() {
        return this.witnesses;
    }

    public void setWitnesses(List<String> witnesses) {
        this.witnesses = witnesses;
    }

    @Override
    public String toString() {
        return "InvalidWitnesses(witnesses=" + this.getWitnesses() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvalidWitnesses)) {
            return false;
        }
        InvalidWitnesses other = (InvalidWitnesses)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$witnesses = this.getWitnesses();
        List<String> other$witnesses = other.getWitnesses();
        return !(this$witnesses == null ? other$witnesses != null : !((Object)this$witnesses).equals(other$witnesses));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InvalidWitnesses;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $witnesses = this.getWitnesses();
        result = result * 59 + ($witnesses == null ? 43 : ((Object)$witnesses).hashCode());
        return result;
    }
}

