/*
 * Decompiled with CFR 0.152.
 */
package io.adabox.model.tx.response;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.adabox.model.tx.response.InvalidEntity;
import io.adabox.model.tx.response.TxError;
import io.adabox.model.tx.response.TxErrorType;
import java.util.ArrayList;
import java.util.List;

public class NetworkMismatch
extends TxError {
    private List<InvalidEntity> invalidEntities;
    private String expectedNetwork;

    public NetworkMismatch() {
        super(TxErrorType.NETWORK_MISMATCH);
    }

    public static NetworkMismatch deserialize(JsonNode networkMismatchEntity) {
        NetworkMismatch networkMismatch = new NetworkMismatch();
        if (networkMismatchEntity.has("invalidEntities")) {
            ArrayList<InvalidEntity> invalidEntities = new ArrayList<InvalidEntity>();
            ArrayNode invalidEntitiesEntity = (ArrayNode)networkMismatchEntity.get("invalidEntities");
            for (Object o : invalidEntitiesEntity) {
                invalidEntities.add(InvalidEntity.deserialize((JsonNode)o));
            }
            networkMismatch.setInvalidEntities(invalidEntities);
        }
        if (networkMismatchEntity.has("expectedNetwork")) {
            networkMismatch.setExpectedNetwork(networkMismatchEntity.get("expectedNetwork").asText());
        }
        return networkMismatch;
    }

    public List<InvalidEntity> getInvalidEntities() {
        return this.invalidEntities;
    }

    public String getExpectedNetwork() {
        return this.expectedNetwork;
    }

    public void setInvalidEntities(List<InvalidEntity> invalidEntities) {
        this.invalidEntities = invalidEntities;
    }

    public void setExpectedNetwork(String expectedNetwork) {
        this.expectedNetwork = expectedNetwork;
    }

    @Override
    public String toString() {
        return "NetworkMismatch(invalidEntities=" + this.getInvalidEntities() + ", expectedNetwork=" + this.getExpectedNetwork() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NetworkMismatch)) {
            return false;
        }
        NetworkMismatch other = (NetworkMismatch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<InvalidEntity> this$invalidEntities = this.getInvalidEntities();
        List<InvalidEntity> other$invalidEntities = other.getInvalidEntities();
        if (this$invalidEntities == null ? other$invalidEntities != null : !((Object)this$invalidEntities).equals(other$invalidEntities)) {
            return false;
        }
        String this$expectedNetwork = this.getExpectedNetwork();
        String other$expectedNetwork = other.getExpectedNetwork();
        return !(this$expectedNetwork == null ? other$expectedNetwork != null : !this$expectedNetwork.equals(other$expectedNetwork));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NetworkMismatch;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<InvalidEntity> $invalidEntities = this.getInvalidEntities();
        result = result * 59 + ($invalidEntities == null ? 43 : ((Object)$invalidEntities).hashCode());
        String $expectedNetwork = this.getExpectedNetwork();
        result = result * 59 + ($expectedNetwork == null ? 43 : $expectedNetwork.hashCode());
        return result;
    }
}

