/*
 * Decompiled with CFR 0.152.
 */
package io.adabox.model.tx.response;

import com.fasterxml.jackson.databind.JsonNode;
import io.adabox.model.tx.response.TxError;
import io.adabox.model.tx.response.TxErrorType;
import io.adabox.model.tx.response.ValidityInterval;
import java.math.BigInteger;

public class OutsideOfValidityInterval
extends TxError {
    private BigInteger currentSlot;
    private ValidityInterval interval;

    public OutsideOfValidityInterval() {
        super(TxErrorType.OUTSIDE_OF_VALIDITY_INTERVAL);
    }

    public static OutsideOfValidityInterval deserialize(JsonNode jsonObject) {
        OutsideOfValidityInterval outsideOfValidityInterval = new OutsideOfValidityInterval();
        if (jsonObject.has("currentSlot")) {
            outsideOfValidityInterval.setCurrentSlot(jsonObject.get("currentSlot").bigIntegerValue());
        }
        if (jsonObject.has("interval")) {
            outsideOfValidityInterval.setInterval(ValidityInterval.deserialize(jsonObject.get("interval")));
        }
        return outsideOfValidityInterval;
    }

    public BigInteger getCurrentSlot() {
        return this.currentSlot;
    }

    public ValidityInterval getInterval() {
        return this.interval;
    }

    public void setCurrentSlot(BigInteger currentSlot) {
        this.currentSlot = currentSlot;
    }

    public void setInterval(ValidityInterval interval) {
        this.interval = interval;
    }

    @Override
    public String toString() {
        return "OutsideOfValidityInterval(currentSlot=" + this.getCurrentSlot() + ", interval=" + this.getInterval() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutsideOfValidityInterval)) {
            return false;
        }
        OutsideOfValidityInterval other = (OutsideOfValidityInterval)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BigInteger this$currentSlot = this.getCurrentSlot();
        BigInteger other$currentSlot = other.getCurrentSlot();
        if (this$currentSlot == null ? other$currentSlot != null : !((Object)this$currentSlot).equals(other$currentSlot)) {
            return false;
        }
        ValidityInterval this$interval = this.getInterval();
        ValidityInterval other$interval = other.getInterval();
        return !(this$interval == null ? other$interval != null : !this$interval.equals(other$interval));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OutsideOfValidityInterval;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        BigInteger $currentSlot = this.getCurrentSlot();
        result = result * 59 + ($currentSlot == null ? 43 : ((Object)$currentSlot).hashCode());
        ValidityInterval $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
        return result;
    }
}

