/*
 * Decompiled with CFR 0.152.
 */
package io.adabox.model.tx.response;

import com.fasterxml.jackson.databind.JsonNode;
import io.adabox.model.tx.response.BadInputs;
import io.adabox.model.tx.response.FeeTooSmall;
import io.adabox.model.tx.response.InvalidWitnesses;
import io.adabox.model.tx.response.NetworkMismatch;
import io.adabox.model.tx.response.OutsideOfValidityInterval;
import io.adabox.model.tx.response.TxErrorType;
import io.adabox.model.tx.response.ValueNotConserved;

public class TxError {
    private final TxErrorType txErrorType;

    public TxError(TxErrorType txErrorType) {
        this.txErrorType = txErrorType;
    }

    public static TxError deserialize(JsonNode txError) {
        if (txError.has("networkMismatch")) {
            return NetworkMismatch.deserialize(txError.get("networkMismatch"));
        }
        if (txError.has("invalidWitnesses")) {
            return InvalidWitnesses.deserialize(txError.get("invalidWitnesses"));
        }
        if (txError.has("valueNotConserved")) {
            return ValueNotConserved.deserialize(txError.get("valueNotConserved"));
        }
        if (txError.has("badInputs")) {
            return BadInputs.deserialize(txError.get("badInputs"));
        }
        if (txError.has("feeTooSmall")) {
            return FeeTooSmall.deserialize(txError.get("feeTooSmall"));
        }
        if (txError.has("outsideOfValidityInterval")) {
            return OutsideOfValidityInterval.deserialize(txError.get("outsideOfValidityInterval"));
        }
        return null;
    }

    public TxErrorType getTxErrorType() {
        return this.txErrorType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TxError)) {
            return false;
        }
        TxError other = (TxError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TxErrorType this$txErrorType = this.getTxErrorType();
        TxErrorType other$txErrorType = other.getTxErrorType();
        return !(this$txErrorType == null ? other$txErrorType != null : !((Object)((Object)this$txErrorType)).equals((Object)other$txErrorType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TxError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TxErrorType $txErrorType = this.getTxErrorType();
        result = result * 59 + ($txErrorType == null ? 43 : ((Object)((Object)$txErrorType)).hashCode());
        return result;
    }

    public String toString() {
        return "TxError(txErrorType=" + this.getTxErrorType() + ")";
    }
}

