/*
 * Decompiled with CFR 0.152.
 */
package io.adabox.model.tx.response;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.adabox.model.Amount;
import io.adabox.model.tx.response.TxError;
import io.adabox.model.tx.response.TxErrorType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ValueNotConserved
extends TxError {
    private List<Amount> consumed;
    private List<Amount> produced;

    public ValueNotConserved() {
        super(TxErrorType.VALUE_NOT_CONSERVED);
    }

    public static ValueNotConserved deserialize(JsonNode jsonObject) {
        ValueNotConserved valueNotConserved = new ValueNotConserved();
        if (jsonObject.has("consumed")) {
            valueNotConserved.setConsumed(ValueNotConserved.fetch(jsonObject.get("consumed")));
        }
        if (jsonObject.has("produced")) {
            valueNotConserved.setProduced(ValueNotConserved.fetch(jsonObject.get("produced")));
        }
        return valueNotConserved;
    }

    private static List<Amount> fetch(JsonNode jsonObject) {
        ArrayList<Amount> list = new ArrayList<Amount>();
        if (jsonObject.has("assets")) {
            JsonNode assets = jsonObject.get("assets");
            if (assets.getNodeType() == JsonNodeType.OBJECT) {
                ObjectNode asset = (ObjectNode)assets;
                Iterator iterator = asset.fieldNames();
                while (iterator.hasNext()) {
                    String unit = (String)iterator.next();
                    list.add(new Amount(unit, asset.get(unit).bigIntegerValue()));
                }
            } else if (assets.getNodeType() == JsonNodeType.ARRAY) {
                ArrayNode assetsArray = (ArrayNode)assets;
                for (JsonNode asset : assetsArray) {
                    String unit = asset.get("unit").asText();
                    list.add(new Amount(unit, asset.get(unit).bigIntegerValue()));
                }
            }
        }
        if (jsonObject.has("coins")) {
            list.add(new Amount("lovelace", jsonObject.get("coins").bigIntegerValue()));
        }
        return list;
    }

    public List<Amount> getConsumed() {
        return this.consumed;
    }

    public List<Amount> getProduced() {
        return this.produced;
    }

    public void setConsumed(List<Amount> consumed) {
        this.consumed = consumed;
    }

    public void setProduced(List<Amount> produced) {
        this.produced = produced;
    }

    @Override
    public String toString() {
        return "ValueNotConserved(consumed=" + this.getConsumed() + ", produced=" + this.getProduced() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueNotConserved)) {
            return false;
        }
        ValueNotConserved other = (ValueNotConserved)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Amount> this$consumed = this.getConsumed();
        List<Amount> other$consumed = other.getConsumed();
        if (this$consumed == null ? other$consumed != null : !((Object)this$consumed).equals(other$consumed)) {
            return false;
        }
        List<Amount> this$produced = this.getProduced();
        List<Amount> other$produced = other.getProduced();
        return !(this$produced == null ? other$produced != null : !((Object)this$produced).equals(other$produced));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ValueNotConserved;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Amount> $consumed = this.getConsumed();
        result = result * 59 + ($consumed == null ? 43 : ((Object)$consumed).hashCode());
        List<Amount> $produced = this.getProduced();
        result = result * 59 + ($produced == null ? 43 : ((Object)$produced).hashCode());
        return result;
    }
}

