/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.http;

import android.text.TextUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;

public abstract class HttpRequestHelper {
    public static final String HTTP_METHOD_GET = "GET";
    public static final String HTTP_METHOD_POST = "POST";
    public static final String HTTP_METHOD_PUT = "PUT";

    private static HttpURLConnection connect(String url, String method, Map<String, String> requestProperty, boolean doOutput, boolean useCaches) throws MalformedURLException, URISyntaxException, IOException {
        URL netURL = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)netURL.openConnection();
        conn.setRequestMethod(method);
        conn.setInstanceFollowRedirects(true);
        conn.setDoOutput(doOutput);
        conn.setUseCaches(useCaches);
        if (requestProperty != null) {
            for (Map.Entry<String, String> entry : requestProperty.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    private static byte[] copyInputStreamToByteArray(InputStream inputStream) throws IOException {
        int size;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int bufferSize = 4096;
        byte[] buffer = new byte[4096];
        while ((size = inputStream.read(buffer)) != -1) {
            byteArrayOutputStream.write(buffer, 0, size);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] get(String url, Map<String, String> requestProperty) throws MalformedURLException, URISyntaxException, IOException {
        HttpURLConnection conn = HttpRequestHelper.connect(url, HTTP_METHOD_GET, requestProperty, false, true);
        conn.connect();
        int code = conn.getResponseCode();
        boolean redirected = code == 301 || code == 302 || code == 303;
        String location = conn.getHeaderField("Location");
        if (!redirected || TextUtils.isEmpty((CharSequence)location)) {
            BufferedInputStream inputStream = new BufferedInputStream(conn.getInputStream());
            byte[] bytes = HttpRequestHelper.copyInputStreamToByteArray(inputStream);
            inputStream.close();
            return bytes;
        }
        return HttpRequestHelper.get(location, requestProperty);
    }

    public static byte[] get(String url) throws MalformedURLException, URISyntaxException, IOException {
        return HttpRequestHelper.get(url, null);
    }

    private static byte[] requestBody(String url, String method, Map<String, String> requestProperty, String body) throws MalformedURLException, URISyntaxException, IOException {
        byte[] bodyBytes = body.getBytes("UTF-8");
        requestProperty.put("Content-Length", String.valueOf(bodyBytes.length));
        HttpURLConnection conn = HttpRequestHelper.connect(url, method, requestProperty, true, false);
        OutputStream outputStream = conn.getOutputStream();
        outputStream.write(bodyBytes);
        BufferedInputStream inputStream = new BufferedInputStream(conn.getInputStream());
        byte[] bytes = HttpRequestHelper.copyInputStreamToByteArray(inputStream);
        outputStream.close();
        inputStream.close();
        return bytes;
    }

    public static byte[] post(String url, Map<String, String> requestProperty, String body) throws MalformedURLException, URISyntaxException, IOException {
        return HttpRequestHelper.requestBody(url, HTTP_METHOD_POST, requestProperty, body);
    }

    public static byte[] put(String url, Map<String, String> requestProperty, String body) throws MalformedURLException, URISyntaxException, IOException {
        return HttpRequestHelper.requestBody(url, HTTP_METHOD_PUT, requestProperty, body);
    }
}

