/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.input;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.TimeInput;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.input.TextInputRenderer;
import io.adaptivecards.renderer.input.TimePickerFragment;
import io.adaptivecards.renderer.inputhandler.TimeInputHandler;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class TimeInputRenderer
extends TextInputRenderer {
    private static TimeInputRenderer s_instance = null;
    private static final String TITLE = "Set Time";

    private TimeInputRenderer() {
    }

    public static TimeInputRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new TimeInputRenderer();
        }
        return s_instance;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, ContainerStyle containerStyle) {
        TimeInput timeInput = null;
        if (baseCardElement instanceof TimeInput) {
            timeInput = (TimeInput)baseCardElement;
        } else {
            timeInput = TimeInput.dynamic_cast(baseCardElement);
            if (timeInput == null) {
                throw new InternalError("Unable to convert BaseCardElement to TimeInput object model.");
            }
        }
        TimeInputRenderer.setSpacingAndSeparator(context, viewGroup, timeInput.GetSpacing(), timeInput.GetSeparator(), hostConfig, true);
        TimeInputHandler timeInputHandler = new TimeInputHandler(timeInput, fragmentManager);
        String time = timeInput.GetValue();
        try {
            Date date = TimeInputHandler.s_simpleDateFormat.parse(timeInput.GetValue());
            time = DateFormat.getTimeInstance().format(date);
        }
        catch (ParseException date) {
            // empty catch block
        }
        EditText editText = this.renderInternal(renderedCard, context, viewGroup, timeInput, time, timeInput.GetPlaceholder(), timeInputHandler, hostConfig);
        editText.setRawInputType(0);
        editText.setFocusable(false);
        editText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TimeInputHandler timeInputHandler = (TimeInputHandler)v.getTag();
                TimePickerFragment timePickerFragment = new TimePickerFragment();
                timePickerFragment.initialize((EditText)v);
                Bundle args = new Bundle();
                args.putString("title", TimeInputRenderer.TITLE);
                timePickerFragment.setArguments(args);
                FragmentManager fm = timeInputHandler.getFragmentManager();
                timePickerFragment.show(fm, TimeInputRenderer.TITLE);
            }
        });
        return editText;
    }
}

