/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.graphics.Color;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.Column;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.action.ActionElementRenderer;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.registration.CardRendererRegistration;
import java.util.Locale;

public class ColumnRenderer
extends BaseCardElementRenderer {
    private static ColumnRenderer s_instance = null;
    private final String g_columnSizeAuto = "auto";
    private final String g_columnSizeStretch = "stretch";

    private ColumnRenderer() {
    }

    public static ColumnRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ColumnRenderer();
        }
        return s_instance;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, ContainerStyle containerStyle) {
        String columnSize;
        Column column;
        if (baseCardElement instanceof Column) {
            column = (Column)baseCardElement;
        } else {
            column = Column.dynamic_cast(baseCardElement);
            if (column == null) {
                throw new InternalError("Unable to convert BaseCardElement to FactSet object model.");
            }
        }
        ColumnRenderer.setSpacingAndSeparator(context, viewGroup, column.GetSpacing(), column.GetSeparator(), hostConfig, false);
        ContainerStyle styleForThis = column.GetStyle().swigValue() == ContainerStyle.None.swigValue() ? containerStyle : column.GetStyle();
        View returnedView = CardRendererRegistration.getInstance().render(renderedCard, context, fragmentManager, null, column, column.GetItems(), cardActionHandler, hostConfig, styleForThis);
        if (styleForThis != containerStyle) {
            int padding = Util.dpToPixels(context, hostConfig.getSpacing().getPaddingSpacing());
            returnedView.setPadding(padding, padding, padding, padding);
            String color = styleForThis == ContainerStyle.Emphasis ? hostConfig.getContainerStyles().getEmphasisPalette().getBackgroundColor() : hostConfig.getContainerStyles().getDefaultPalette().getBackgroundColor();
            returnedView.setBackgroundColor(Color.parseColor((String)color));
        }
        if (TextUtils.isEmpty((CharSequence)(columnSize = column.GetWidth().toLowerCase(Locale.getDefault()))) || columnSize.equals("stretch")) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
            layoutParams.weight = 1.0f;
            returnedView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        } else if (columnSize.equals("auto")) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
            returnedView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        } else {
            try {
                float columnWeight = Float.parseFloat(columnSize);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
                layoutParams.width = 0;
                layoutParams.weight = columnWeight;
                returnedView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
            catch (NumberFormatException numFormatExcep) {
                throw new IllegalArgumentException("Column Width (" + column.GetWidth() + ") is not a valid weight ('auto', 'stretch', <integer>).");
            }
        }
        if (column.GetSelectAction() != null) {
            returnedView.setClickable(true);
            returnedView.setOnClickListener((View.OnClickListener)new ActionElementRenderer.ButtonOnClickListener(renderedCard, column.GetSelectAction(), cardActionHandler));
        }
        viewGroup.addView(returnedView);
        return returnedView;
    }
}

