/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.ActionAlignment;
import io.adaptivecards.objectmodel.ActionsOrientation;
import io.adaptivecards.objectmodel.BaseActionElement;
import io.adaptivecards.objectmodel.BaseActionElementVector;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Spacing;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.IActionLayoutRenderer;
import io.adaptivecards.renderer.IBaseActionElementRenderer;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class ActionLayoutRenderer
implements IActionLayoutRenderer {
    private static ActionLayoutRenderer s_instance = null;

    protected ActionLayoutRenderer() {
    }

    public static ActionLayoutRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ActionLayoutRenderer();
        }
        return s_instance;
    }

    @Override
    public void renderActions(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseActionElementVector baseActionElementList, ICardActionHandler cardActionHandler, HostConfig hostConfig) {
        long size;
        if (baseActionElementList == null || (size = baseActionElementList.size()) <= 0L) {
            return;
        }
        LinearLayout actionButtonsLayout = new LinearLayout(context);
        actionButtonsLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        int alignment = hostConfig.getActions().getActionAlignment().swigValue();
        if (alignment == ActionAlignment.Right.swigValue()) {
            actionButtonsLayout.setGravity(5);
        } else if (alignment == ActionAlignment.Center.swigValue()) {
            actionButtonsLayout.setGravity(1);
        }
        int actionButtonsLayoutOrientation = hostConfig.getActions().getActionsOrientation().swigValue();
        if (actionButtonsLayoutOrientation == ActionsOrientation.Vertical.swigValue()) {
            actionButtonsLayout.setOrientation(1);
        } else {
            actionButtonsLayout.setOrientation(0);
        }
        Spacing spacing = hostConfig.getActions().getSpacing();
        BaseCardElementRenderer.setSpacingAndSeparator(context, viewGroup, spacing, false, hostConfig, true);
        if (viewGroup != null) {
            if (actionButtonsLayoutOrientation == ActionsOrientation.Horizontal.swigValue()) {
                HorizontalScrollView actionButtonsContainer = new HorizontalScrollView(context);
                actionButtonsContainer.setHorizontalScrollBarEnabled(false);
                actionButtonsContainer.addView((View)actionButtonsLayout);
                viewGroup.addView((View)actionButtonsContainer);
            } else {
                viewGroup.addView((View)actionButtonsLayout);
            }
        }
        int i = 0;
        long maxActions = hostConfig.getActions().getMaxActions();
        while ((long)i < size && (long)i < maxActions) {
            BaseActionElement actionElement = baseActionElementList.get(i);
            IBaseActionElementRenderer actionRenderer = CardRendererRegistration.getInstance().getActionRenderer();
            actionRenderer.render(renderedCard, context, fragmentManager, (ViewGroup)actionButtonsLayout, actionElement, cardActionHandler, hostConfig);
            ++i;
        }
        if ((long)i >= maxActions && size != maxActions) {
            renderedCard.addWarning(new AdaptiveWarning(4, "A maximum of " + maxActions + " actions are allowed"));
        }
    }
}

