/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.action;

import android.content.Context;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.ActionAlignment;
import io.adaptivecards.objectmodel.ActionMode;
import io.adaptivecards.objectmodel.ActionType;
import io.adaptivecards.objectmodel.ActionsOrientation;
import io.adaptivecards.objectmodel.BaseActionElement;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.ShowCardAction;
import io.adaptivecards.renderer.AdaptiveCardRenderer;
import io.adaptivecards.renderer.IBaseActionElementRenderer;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;

public class ActionElementRenderer
implements IBaseActionElementRenderer {
    private static ActionElementRenderer s_instance = null;

    protected ActionElementRenderer() {
    }

    public static ActionElementRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ActionElementRenderer();
        }
        return s_instance;
    }

    public Button renderButton(Context context, ViewGroup viewGroup, BaseActionElement baseActionElement, HostConfig hostConfig) {
        LinearLayout.LayoutParams layoutParams;
        Button button = new Button(context);
        button.setText((CharSequence)baseActionElement.GetTitle());
        ActionAlignment alignment = hostConfig.getActions().getActionAlignment();
        ActionsOrientation orientation = hostConfig.getActions().getActionsOrientation();
        if (orientation == ActionsOrientation.Horizontal) {
            layoutParams = new LinearLayout.LayoutParams(-2, -1);
            long spacing = hostConfig.getActions().getButtonSpacing();
            layoutParams.rightMargin = Util.dpToPixels(context, spacing);
        } else {
            layoutParams = new LinearLayout.LayoutParams(-1, -1);
        }
        if (alignment == ActionAlignment.Stretch) {
            layoutParams.weight = 1.0f;
        }
        button.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        viewGroup.addView((View)button);
        return button;
    }

    @Override
    public Button render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseActionElement baseActionElement, ICardActionHandler cardActionHandler, HostConfig hostConfig) {
        if (cardActionHandler == null) {
            throw new IllegalArgumentException("Action Handler is null.");
        }
        Button button = this.renderButton(context, viewGroup, baseActionElement, hostConfig);
        if (baseActionElement.GetElementType() == ActionType.ShowCard && hostConfig.getActions().getShowCard().getActionMode() == ActionMode.Inline) {
            ShowCardAction showCardAction = null;
            if (baseActionElement instanceof ShowCardAction) {
                showCardAction = (ShowCardAction)baseActionElement;
            } else {
                showCardAction = ShowCardAction.dynamic_cast(baseActionElement);
                if (showCardAction == null) {
                    throw new InternalError("Unable to convert BaseActionElement to ShowCardAction object model.");
                }
            }
            View invisibleCard = AdaptiveCardRenderer.getInstance().internalRender(renderedCard, context, fragmentManager, showCardAction.GetCard(), cardActionHandler, hostConfig, true);
            invisibleCard.setVisibility(8);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
            layoutParams.setMargins(0, Util.dpToPixels(context, hostConfig.getActions().getShowCard().getInlineTopMargin()), 0, 0);
            invisibleCard.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ViewGroup parent = (ViewGroup)viewGroup.getParent();
            parent = parent instanceof HorizontalScrollView ? (ViewGroup)parent.getParent().getParent() : (ViewGroup)parent.getParent();
            ViewGroup hiddenCards = (ViewGroup)parent.getChildAt(1);
            hiddenCards.addView(invisibleCard);
            button.setOnClickListener((View.OnClickListener)new ShowCardInlineClickListener(invisibleCard, hiddenCards));
        } else {
            button.setOnClickListener((View.OnClickListener)new ButtonOnClickListener(renderedCard, baseActionElement, cardActionHandler));
        }
        return button;
    }

    protected class ShowCardInlineClickListener
    implements View.OnClickListener {
        private View m_invisibleCard;
        private ViewGroup m_hiddenCardsLayout;

        public ShowCardInlineClickListener(View invisibleCard, ViewGroup hiddenCardsLayout) {
            this.m_invisibleCard = invisibleCard;
            this.m_hiddenCardsLayout = hiddenCardsLayout;
        }

        public void onClick(View v) {
            v.setPressed(this.m_invisibleCard.getVisibility() != 0);
            for (int i = 0; i < this.m_hiddenCardsLayout.getChildCount(); ++i) {
                View child = this.m_hiddenCardsLayout.getChildAt(i);
                if (child == this.m_invisibleCard) continue;
                child.setVisibility(8);
            }
            this.m_invisibleCard.setVisibility(this.m_invisibleCard.getVisibility() == 0 ? 8 : 0);
            View mainCardView = ((ViewGroup)this.m_hiddenCardsLayout.getParent()).getChildAt(0);
            int padding = mainCardView.getPaddingTop();
            if (this.m_invisibleCard.getVisibility() == 0) {
                mainCardView.setPadding(padding, padding, padding, 0);
            } else {
                mainCardView.setPadding(padding, padding, padding, padding);
            }
        }
    }

    public static class ButtonOnClickListener
    implements View.OnClickListener {
        private BaseActionElement m_action;
        private RenderedAdaptiveCard m_renderedAdaptiveCard;
        private ICardActionHandler m_cardActionHandler;

        public ButtonOnClickListener(RenderedAdaptiveCard renderedCard, BaseActionElement action, ICardActionHandler cardActionHandler) {
            this.m_action = action;
            this.m_renderedAdaptiveCard = renderedCard;
            this.m_cardActionHandler = cardActionHandler;
        }

        public void onClick(View v) {
            this.m_cardActionHandler.onAction(this.m_action, this.m_renderedAdaptiveCard);
        }
    }
}

