/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.input;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.DateInput;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.input.DatePickerFragment;
import io.adaptivecards.renderer.input.TextInputRenderer;
import io.adaptivecards.renderer.inputhandler.DateInputHandler;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class DateInputRenderer
extends TextInputRenderer {
    private static DateInputRenderer s_instance = null;
    private static final String TITLE = "Set Date";

    protected DateInputRenderer() {
    }

    public static DateInputRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new DateInputRenderer();
        }
        return s_instance;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, ContainerStyle containerStyle) {
        if (!hostConfig.getSupportsInteractivity()) {
            renderedCard.addWarning(new AdaptiveWarning(3, "Input.Date is not allowed"));
            return null;
        }
        DateInput dateInput = null;
        if (baseCardElement instanceof DateInput) {
            dateInput = (DateInput)baseCardElement;
        } else {
            dateInput = DateInput.dynamic_cast(baseCardElement);
            if (dateInput == null) {
                throw new InternalError("Unable to convert BaseCardElement to DateInput object model.");
            }
        }
        DateInputRenderer.setSpacingAndSeparator(context, viewGroup, dateInput.GetSpacing(), dateInput.GetSeparator(), hostConfig, true);
        DateInputHandler dateInputHandler = new DateInputHandler(dateInput, fragmentManager);
        String dateString = dateInput.GetValue();
        try {
            Date date = DateInputHandler.s_simpleDateFormat.parse(dateInput.GetValue());
            dateString = DateFormat.getDateInstance().format(date);
        }
        catch (ParseException date) {
            // empty catch block
        }
        EditText editText = this.renderInternal(renderedCard, context, viewGroup, dateInput, dateString, dateInput.GetPlaceholder(), dateInputHandler, hostConfig);
        editText.setRawInputType(0);
        editText.setFocusable(false);
        editText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DateInputHandler dateInputHandler = (DateInputHandler)v.getTag();
                DateInput dateInput = (DateInput)dateInputHandler.getBaseInputElement();
                DatePickerFragment datePickerFragment = new DatePickerFragment();
                datePickerFragment.initialize(dateInput, (EditText)v);
                Bundle args = new Bundle();
                args.putString("title", DateInputRenderer.TITLE);
                datePickerFragment.setArguments(args);
                FragmentManager fm = dateInputHandler.getFragmentManager();
                datePickerFragment.show(fm, DateInputRenderer.TITLE);
            }
        });
        return editText;
    }
}

