/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.input;

import android.content.Context;
import android.support.v4.app.FragmentManager;
import android.text.InputFilter;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.TextInput;
import io.adaptivecards.objectmodel.TextInputStyle;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.inputhandler.TextInputHandler;

public class TextInputRenderer
extends BaseCardElementRenderer {
    private static TextInputRenderer s_instance = null;

    protected TextInputRenderer() {
    }

    public static TextInputRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new TextInputRenderer();
        }
        return s_instance;
    }

    protected void setTextInputStyle(EditText editText, TextInputStyle textInputStyle) {
        if (textInputStyle != TextInputStyle.Text) {
            if (textInputStyle == TextInputStyle.Tel) {
                editText.setInputType(3);
            } else if (textInputStyle == TextInputStyle.Url) {
                editText.setInputType(16);
            } else if (textInputStyle == TextInputStyle.Email) {
                editText.setInputType(32);
            } else {
                throw new IllegalArgumentException("Unknown TextInputStyle: " + textInputStyle.toString());
            }
        }
    }

    protected EditText renderInternal(RenderedAdaptiveCard renderedCard, Context context, ViewGroup viewGroup, BaseInputElement baseInputElement, String value, String placeHolder, TextInputHandler textInputHandler, HostConfig hostConfig) {
        EditText editText = new EditText(context);
        textInputHandler.setView((View)editText);
        editText.setTag((Object)textInputHandler);
        editText.setTextColor(-16777216);
        renderedCard.registerInputHandler(textInputHandler);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            editText.setText((CharSequence)value);
        }
        if (!TextUtils.isEmpty((CharSequence)placeHolder)) {
            editText.setHint((CharSequence)placeHolder);
        }
        viewGroup.addView((View)editText);
        return editText;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, ContainerStyle containerStyle) {
        if (!hostConfig.getSupportsInteractivity()) {
            renderedCard.addWarning(new AdaptiveWarning(3, "Input.Text is not allowed"));
            return null;
        }
        TextInput textInput = null;
        if (baseCardElement instanceof TextInput) {
            textInput = (TextInput)baseCardElement;
        } else {
            textInput = TextInput.dynamic_cast(baseCardElement);
            if (textInput == null) {
                throw new InternalError("Unable to convert BaseCardElement to TextInput object model.");
            }
        }
        TextInputHandler textInputHandler = new TextInputHandler(textInput);
        TextInputRenderer.setSpacingAndSeparator(context, viewGroup, textInput.GetSpacing(), textInput.GetSeparator(), hostConfig, true);
        EditText editText = this.renderInternal(renderedCard, context, viewGroup, textInput, textInput.GetValue(), textInput.GetPlaceholder(), textInputHandler, hostConfig);
        editText.setSingleLine(!textInput.GetIsMultiline());
        editText.setTag((Object)textInput);
        if (textInput.GetIsMultiline()) {
            editText.setLines(3);
            editText.setOnTouchListener((View.OnTouchListener)new EditTextTouchListener(textInput));
        }
        this.setTextInputStyle(editText, textInput.GetTextInputStyle());
        int maxLength = (int)Math.min(textInput.GetMaxLength(), Integer.MAX_VALUE);
        if (maxLength > 0) {
            editText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
        }
        return editText;
    }

    private class EditTextTouchListener
    implements View.OnTouchListener {
        private Object m_tag = null;

        EditTextTouchListener(Object tag) {
            this.m_tag = tag;
        }

        public boolean onTouch(View v, MotionEvent event) {
            if (v.getTag() == this.m_tag) {
                v.getParent().requestDisallowInterceptTouchEvent(true);
                switch (event.getAction() & 0xFF) {
                    case 1: {
                        v.getParent().requestDisallowInterceptTouchEvent(false);
                    }
                }
            }
            return false;
        }
    }
}

