/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.CardElementType;
import io.adaptivecards.objectmodel.Column;
import io.adaptivecards.objectmodel.ColumnSet;
import io.adaptivecards.objectmodel.ColumnVector;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.IBaseCardElementRenderer;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.action.ActionElementRenderer;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class ColumnSetRenderer
extends BaseCardElementRenderer {
    private static ColumnSetRenderer s_instance = null;

    protected ColumnSetRenderer() {
    }

    public static ColumnSetRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ColumnSetRenderer();
        }
        return s_instance;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, ContainerStyle containerStyle) {
        ColumnSet columnSet = null;
        if (baseCardElement instanceof ColumnSet) {
            columnSet = (ColumnSet)baseCardElement;
        } else {
            columnSet = ColumnSet.dynamic_cast(baseCardElement);
            if (columnSet == null) {
                throw new InternalError("Unable to convert BaseCardElement to ColumnSet object model.");
            }
        }
        IBaseCardElementRenderer columnRenderer = CardRendererRegistration.getInstance().getRenderer(CardElementType.Column.toString());
        if (columnRenderer == null) {
            throw new UnknownError(CardElementType.Column.toString() + " is not a registered renderer.");
        }
        ColumnSetRenderer.setSpacingAndSeparator(context, viewGroup, columnSet.GetSpacing(), columnSet.GetSeparator(), hostConfig, true);
        ColumnVector columnVector = columnSet.GetColumns();
        long columnVectorSize = columnVector.size();
        LinearLayout layout2 = new LinearLayout(context);
        layout2.setTag((Object)columnSet);
        layout2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        int i = 0;
        while ((long)i < columnVectorSize) {
            Column column = columnVector.get(i);
            columnRenderer.render(renderedCard, context, fragmentManager, (ViewGroup)layout2, column, cardActionHandler, hostConfig, containerStyle);
            ++i;
        }
        if (columnSet.GetSelectAction() != null) {
            layout2.setClickable(true);
            layout2.setOnClickListener((View.OnClickListener)new ActionElementRenderer.ButtonOnClickListener(renderedCard, columnSet.GetSelectAction(), cardActionHandler));
        }
        viewGroup.addView((View)layout2);
        return layout2;
    }
}

