/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Shader;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HorizontalAlignment;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Image;
import io.adaptivecards.objectmodel.ImageSize;
import io.adaptivecards.objectmodel.ImageSizesConfig;
import io.adaptivecards.objectmodel.ImageStyle;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.IOnlineImageLoader;
import io.adaptivecards.renderer.InnerImageLoaderAsync;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.action.ActionElementRenderer;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.layout.HorizontalFlowLayout;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class ImageRenderer
extends BaseCardElementRenderer {
    private static ImageRenderer s_instance = null;

    protected ImageRenderer() {
    }

    public static ImageRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ImageRenderer();
        }
        return s_instance;
    }

    private static void setImageSize(Context context, ImageView imageView, ImageSize imageSize, ImageSizesConfig imageSizesConfig) {
        imageView.setScaleType(ImageView.ScaleType.CENTER);
        if (imageSize == ImageSize.Stretch) {
            imageView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
            imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        } else if (imageSize == ImageSize.Small) {
            imageView.setMaxWidth(Util.dpToPixels(context, imageSizesConfig.getSmallSize()));
        } else if (imageSize == ImageSize.Medium) {
            imageView.setMaxWidth(Util.dpToPixels(context, imageSizesConfig.getMediumSize()));
        } else if (imageSize == ImageSize.Large) {
            imageView.setMaxWidth(Util.dpToPixels(context, imageSizesConfig.getLargeSize()));
        } else if (imageSize != ImageSize.Auto && imageSize != ImageSize.None) {
            throw new IllegalArgumentException("Unknown image size: " + imageSize.toString());
        }
        imageView.setAdjustViewBounds(true);
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, ContainerStyle containerStyle) {
        Image image;
        if (baseCardElement instanceof Image) {
            image = (Image)baseCardElement;
        } else {
            image = Image.dynamic_cast(baseCardElement);
            if (image == null) {
                throw new InternalError("Unable to convert BaseCardElement to Image object model.");
            }
        }
        ImageView imageView = new ImageView(context);
        imageView.setTag((Object)image);
        ImageRendererImageLoaderAsync imageLoaderAsync = new ImageRendererImageLoaderAsync(renderedCard, imageView, "", image.GetImageStyle());
        IOnlineImageLoader onlineImageLoader = CardRendererRegistration.getInstance().getOnlineImageLoader();
        if (onlineImageLoader != null) {
            imageLoaderAsync.registerCustomOnlineImageLoader(onlineImageLoader);
        }
        imageLoaderAsync.execute(new String[]{image.GetUrl()});
        LinearLayout.LayoutParams layoutParams = image.GetImageSize() == ImageSize.Stretch ? new LinearLayout.LayoutParams(-1, -2) : new LinearLayout.LayoutParams(-2, -2);
        HorizontalAlignment horizontalAlignment = image.GetHorizontalAlignment();
        if (horizontalAlignment == HorizontalAlignment.Right) {
            layoutParams.gravity = 5;
        } else if (horizontalAlignment == HorizontalAlignment.Center) {
            layoutParams.gravity = 1;
        }
        if (image.GetSelectAction() != null) {
            imageView.setClickable(true);
            imageView.setOnClickListener((View.OnClickListener)new ActionElementRenderer.ButtonOnClickListener(renderedCard, image.GetSelectAction(), cardActionHandler));
        }
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        ImageRenderer.setImageSize(context, imageView, image.GetImageSize(), hostConfig.getImageSizes());
        ImageRenderer.setSpacingAndSeparator(context, viewGroup, image.GetSpacing(), image.GetSeparator(), hostConfig, !(viewGroup instanceof HorizontalFlowLayout));
        viewGroup.addView((View)imageView);
        return imageView;
    }

    private class ImageRendererImageLoaderAsync
    extends InnerImageLoaderAsync {
        private Context m_context;
        private ImageView m_imageView;
        private ImageStyle m_imageStyle;
        private RenderedAdaptiveCard m_renderedCard;

        ImageRendererImageLoaderAsync(RenderedAdaptiveCard renderedCard, ImageView imageView, String imageBaseUrl, ImageStyle imageStyle) {
            super(renderedCard, (View)imageView, imageBaseUrl);
            this.m_imageStyle = imageStyle;
            this.m_renderedCard = renderedCard;
        }

        @Override
        protected Bitmap styleBitmap(Bitmap bitmap) {
            if (bitmap != null && this.m_imageStyle == ImageStyle.Person) {
                Bitmap circleBitmap = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                BitmapShader shader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                Paint paint = new Paint();
                paint.setShader((Shader)shader);
                Canvas c = new Canvas(circleBitmap);
                c.drawCircle((float)(bitmap.getWidth() / 2), (float)(bitmap.getHeight() / 2), (float)(bitmap.getWidth() / 2), paint);
                bitmap = circleBitmap;
            }
            return bitmap;
        }

        @Override
        protected void renderBitmap(Bitmap bitmap) {
            ImageView view = (ImageView)this.m_view;
            view.setImageBitmap(bitmap);
        }
    }
}

