/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.graphics.Typeface;
import android.os.Build;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.Html;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ClickableSpan;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.FontSizesConfig;
import io.adaptivecards.objectmodel.ForegroundColor;
import io.adaptivecards.objectmodel.HorizontalAlignment;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.MarkDownParser;
import io.adaptivecards.objectmodel.TextBlock;
import io.adaptivecards.objectmodel.TextSize;
import io.adaptivecards.objectmodel.TextWeight;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.readonly.DateTimeParser;
import java.util.HashMap;
import org.xml.sax.XMLReader;

public class TextBlockRenderer
extends BaseCardElementRenderer {
    private static TextBlockRenderer s_instance = null;
    private HashMap<TextWeight, Integer> m_textWeightMap = new HashMap();
    private final int g_textWeightDefault = 0;
    private final int g_textWeightBolder = 1;
    private final int g_textWeightLighter = 2;

    protected TextBlockRenderer() {
        this.m_textWeightMap.put(TextWeight.Default, 0);
        this.m_textWeightMap.put(TextWeight.Bolder, 1);
        this.m_textWeightMap.put(TextWeight.Lighter, 2);
    }

    public static TextBlockRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new TextBlockRenderer();
        }
        return s_instance;
    }

    static void setTextSize(Context context, TextView textView, TextSize textSize, HostConfig hostConfig) {
        FontSizesConfig fontSizesConfig = hostConfig.getFontSizes();
        if (textSize == TextSize.ExtraLarge) {
            textView.setTextSize((float)fontSizesConfig.getExtraLargeFontSize());
        } else if (textSize == TextSize.Large) {
            textView.setTextSize((float)fontSizesConfig.getLargeFontSize());
        } else if (textSize == TextSize.Medium) {
            textView.setTextSize((float)fontSizesConfig.getMediumFontSize());
        } else if (textSize == TextSize.Default) {
            textView.setTextSize((float)fontSizesConfig.getDefaultFontSize());
        } else if (textSize == TextSize.Small) {
            textView.setTextSize((float)fontSizesConfig.getSmallFontSize());
        } else {
            throw new IllegalArgumentException("Unknown text size: " + textSize.toString());
        }
    }

    static void setTextAlignment(TextView textView, HorizontalAlignment textAlignment) {
        int alignment;
        if (textAlignment == HorizontalAlignment.Center) {
            alignment = 17;
        } else if (textAlignment == HorizontalAlignment.Left) {
            alignment = 3;
        } else if (textAlignment == HorizontalAlignment.Right) {
            alignment = 5;
        } else {
            throw new IllegalArgumentException("Invalid text alignment: " + textAlignment.toString());
        }
        textView.setGravity(alignment);
    }

    void setTextFormat(TextView textView, String textFamily, TextWeight textWeight) {
        textView.setTypeface(Typeface.create((String)textFamily, (int)0), this.m_textWeightMap.get((Object)textWeight).intValue());
    }

    static void setTextColor(TextView textView, ForegroundColor foregroundColor, HostConfig hostConfig, boolean isSubtle, ContainerStyle containerStyle) {
        if (containerStyle == ContainerStyle.Emphasis) {
            textView.setTextColor(TextBlockRenderer.getColor(foregroundColor, hostConfig.getContainerStyles().getEmphasisPalette().getForegroundColors(), isSubtle));
        } else {
            textView.setTextColor(TextBlockRenderer.getColor(foregroundColor, hostConfig.getContainerStyles().getDefaultPalette().getForegroundColors(), isSubtle));
        }
    }

    private CharSequence trimHtmlString(Spanned htmlString) {
        int i;
        int numToRemoveFromEnd = 0;
        int numToRemoveFromStart = 0;
        for (i = htmlString.length() - 1; i >= 0 && htmlString.charAt(i) == '\n'; --i) {
            ++numToRemoveFromEnd;
        }
        for (i = 0; i <= htmlString.length() - 1 && htmlString.charAt(i) == '\n'; ++i) {
            ++numToRemoveFromStart;
        }
        if (numToRemoveFromStart + numToRemoveFromEnd >= htmlString.length()) {
            return htmlString;
        }
        return htmlString.subSequence(numToRemoveFromStart, htmlString.length() - numToRemoveFromEnd);
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, ContainerStyle containerStyle) {
        TextBlock textBlock = null;
        if (baseCardElement instanceof TextBlock) {
            textBlock = (TextBlock)baseCardElement;
        } else {
            textBlock = TextBlock.dynamic_cast(baseCardElement);
            if (textBlock == null) {
                throw new InternalError("Unable to convert BaseCardElement to TextBlock object model.");
            }
        }
        TextView textView = new TextView(context);
        textView.setTag((Object)baseCardElement);
        DateTimeParser parser = new DateTimeParser(textBlock.GetLanguage());
        String textWithFormattedDates = parser.GenerateString(textBlock.GetTextForDateParsing());
        MarkDownParser markDownParser = new MarkDownParser(textWithFormattedDates);
        String textString = markDownParser.TransformToHtml();
        Spanned htmlString = Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)textString, (int)63, null, (Html.TagHandler)new UlTagHandler()) : Html.fromHtml((String)textString, null, (Html.TagHandler)new UlTagHandler());
        textView.setText(this.trimHtmlString(htmlString));
        textView.setSingleLine(!textBlock.GetWrap());
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setOnTouchListener((View.OnTouchListener)new TouchTextView((Spannable)new SpannableString(this.trimHtmlString(htmlString))));
        textView.setHorizontallyScrolling(false);
        this.setTextFormat(textView, hostConfig.getFontFamily(), textBlock.GetTextWeight());
        TextBlockRenderer.setTextSize(context, textView, textBlock.GetTextSize(), hostConfig);
        TextBlockRenderer.setSpacingAndSeparator(context, viewGroup, textBlock.GetSpacing(), textBlock.GetSeparator(), hostConfig, true);
        TextBlockRenderer.setTextColor(textView, textBlock.GetTextColor(), hostConfig, textBlock.GetIsSubtle(), containerStyle);
        TextBlockRenderer.setTextAlignment(textView, textBlock.GetHorizontalAlignment());
        textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        int maxLines = (int)textBlock.GetMaxLines();
        if (maxLines > 0 && textBlock.GetWrap()) {
            textView.setMaxLines(maxLines);
        } else if (!textBlock.GetWrap()) {
            textView.setMaxLines(1);
        }
        viewGroup.addView((View)textView);
        return textView;
    }

    static class TouchTextView
    implements View.OnTouchListener {
        Spannable spannable;

        public TouchTextView(Spannable spannable) {
            this.spannable = spannable;
        }

        public boolean onTouch(View v, MotionEvent event) {
            int action = event.getAction();
            if (!(v instanceof TextView)) {
                return false;
            }
            TextView textView = (TextView)v;
            if (action == 1 || action == 0) {
                int line;
                int x = (int)event.getX();
                int y = (int)event.getY();
                x -= textView.getTotalPaddingLeft();
                y -= textView.getTotalPaddingTop();
                Layout layout2 = textView.getLayout();
                int off = layout2.getOffsetForHorizontal(line = layout2.getLineForVertical(y += textView.getScrollY()), (float)(x += textView.getScrollX()));
                ClickableSpan[] link = (ClickableSpan[])this.spannable.getSpans(off, off, ClickableSpan.class);
                if (link.length != 0) {
                    if (action == 1) {
                        link[0].onClick((View)textView);
                    } else if (action == 0) {
                        Selection.setSelection((Spannable)this.spannable, (int)this.spannable.getSpanStart((Object)link[0]), (int)this.spannable.getSpanEnd((Object)link[0]));
                    }
                    return true;
                }
                Selection.removeSelection((Spannable)this.spannable);
            }
            return false;
        }
    }

    public class UlTagHandler
    implements Html.TagHandler {
        public void handleTag(boolean opening, String tag, Editable output, XMLReader xmlReader) {
            if (tag.equals("ul") && !opening) {
                output.append((CharSequence)"\n");
            }
            if (tag.equals("li") && opening) {
                output.append((CharSequence)"\n\t\u2022 ");
            }
        }
    }
}

