/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.input;

import android.content.Context;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.ChoiceInput;
import io.adaptivecards.objectmodel.ChoiceInputVector;
import io.adaptivecards.objectmodel.ChoiceSetInput;
import io.adaptivecards.objectmodel.ChoiceSetStyle;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.inputhandler.CheckBoxSetInputHandler;
import io.adaptivecards.renderer.inputhandler.ComboBoxInputHandler;
import io.adaptivecards.renderer.inputhandler.RadioGroupInputHandler;
import java.util.Arrays;
import java.util.Vector;

public class ChoiceSetInputRenderer
extends BaseCardElementRenderer {
    private static ChoiceSetInputRenderer s_instance = null;

    private ChoiceSetInputRenderer() {
    }

    public static ChoiceSetInputRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ChoiceSetInputRenderer();
        }
        return s_instance;
    }

    public View renderCheckBoxSet(RenderedAdaptiveCard renderedCard, Context context, ChoiceSetInput choiceSetInput) {
        LinearLayout layout2 = new LinearLayout(context);
        layout2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        layout2.setOrientation(1);
        Vector<CheckBox> checkBoxList = new Vector<CheckBox>();
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        long size = choiceInputVector.size();
        String value = choiceSetInput.GetValue();
        Vector<String> defaults = new Vector<String>();
        defaults.addAll(Arrays.asList(value.split(",")));
        int i = 0;
        while ((long)i < size) {
            ChoiceInput choiceInput = choiceInputVector.get(i);
            CheckBox checkBox = new CheckBox(context);
            checkBox.setText((CharSequence)choiceInput.GetTitle());
            if (defaults.contains(choiceInput.GetValue())) {
                checkBox.setChecked(true);
            }
            checkBoxList.add(checkBox);
            layout2.addView((View)checkBox);
            ++i;
        }
        CheckBoxSetInputHandler checkBoxSetInputHandler = new CheckBoxSetInputHandler(choiceSetInput, checkBoxList);
        checkBoxSetInputHandler.setView((View)layout2);
        layout2.setTag((Object)checkBoxSetInputHandler);
        renderedCard.registerInputHandler(checkBoxSetInputHandler);
        return layout2;
    }

    public View renderRadioGroup(RenderedAdaptiveCard renderedCard, Context context, ChoiceSetInput choiceSetInput) {
        RadioGroup radioGroup = new RadioGroup(context);
        radioGroup.setOrientation(1);
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        long size = choiceInputVector.size();
        String value = choiceSetInput.GetValue();
        int i = 0;
        while ((long)i < size) {
            ChoiceInput choiceInput = choiceInputVector.get(i);
            RadioButton radioButton = new RadioButton(context);
            radioButton.setId(i);
            radioButton.setText((CharSequence)choiceInput.GetTitle());
            if (choiceInput.GetValue().equals(value)) {
                radioButton.setChecked(true);
            }
            radioGroup.addView((View)radioButton);
            ++i;
        }
        RadioGroupInputHandler radioGroupInputHandler = new RadioGroupInputHandler(choiceSetInput);
        radioGroupInputHandler.setView((View)radioGroup);
        radioGroup.setTag((Object)radioGroupInputHandler);
        renderedCard.registerInputHandler(radioGroupInputHandler);
        return radioGroup;
    }

    public View renderComboBox(RenderedAdaptiveCard renderedCard, Context context, ChoiceSetInput choiceSetInput) {
        Vector<String> titleList = new Vector<String>();
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        long size = choiceInputVector.size();
        int selection = 0;
        String value = choiceSetInput.GetValue();
        int i = 0;
        while ((long)i < size) {
            ChoiceInput choiceInput = choiceInputVector.get(i);
            titleList.addElement(choiceInput.GetTitle());
            if (choiceInput.GetValue().equals(value)) {
                selection = i;
            }
            ++i;
        }
        ComboBoxInputHandler comboBoxInputHandler = new ComboBoxInputHandler(choiceSetInput);
        Spinner spinner = new Spinner(context);
        comboBoxInputHandler.setView((View)spinner);
        spinner.setTag((Object)comboBoxInputHandler);
        renderedCard.registerInputHandler(comboBoxInputHandler);
        ArrayAdapter spinnerArrayAdapter = new ArrayAdapter(context, 17367048, titleList);
        spinnerArrayAdapter.setDropDownViewResource(0x1090009);
        spinner.setAdapter((SpinnerAdapter)spinnerArrayAdapter);
        spinner.setSelection(selection);
        return spinner;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, ContainerStyle containerStyle) {
        if (!hostConfig.getSupportsInteractivity()) {
            renderedCard.addWarning(new AdaptiveWarning(3, "Input.ChoiceSet is not allowed"));
            return null;
        }
        ChoiceSetInput choiceSetInput = null;
        if (baseCardElement instanceof ChoiceSetInput) {
            choiceSetInput = (ChoiceSetInput)baseCardElement;
        } else {
            choiceSetInput = ChoiceSetInput.dynamic_cast(baseCardElement);
            if (choiceSetInput == null) {
                throw new InternalError("Unable to convert BaseCardElement to ChoiceSetInput object model.");
            }
        }
        ChoiceSetInputRenderer.setSpacingAndSeparator(context, viewGroup, choiceSetInput.GetSpacing(), choiceSetInput.GetSeparator(), hostConfig, true);
        View view = null;
        if (choiceSetInput.GetIsMultiSelect()) {
            view = this.renderCheckBoxSet(renderedCard, context, choiceSetInput);
        } else if (choiceSetInput.GetChoiceSetStyle() == ChoiceSetStyle.Expanded) {
            view = this.renderRadioGroup(renderedCard, context, choiceSetInput);
        } else if (choiceSetInput.GetChoiceSetStyle() == ChoiceSetStyle.Compact) {
            view = this.renderComboBox(renderedCard, context, choiceSetInput);
        } else {
            throw new IllegalArgumentException("ChoiceSet Input, " + choiceSetInput.GetId() + ", contains invalid style, " + choiceSetInput.GetChoiceSetStyle().toString() + ".");
        }
        viewGroup.addView(view);
        return view;
    }
}

