/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.input;

import android.content.Context;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.NumberInput;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.input.TextInputRenderer;
import io.adaptivecards.renderer.inputhandler.TextInputHandler;

public class NumberInputRenderer
extends TextInputRenderer {
    private static NumberInputRenderer s_instance = null;

    private NumberInputRenderer() {
    }

    public static NumberInputRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new NumberInputRenderer();
        }
        return s_instance;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, ContainerStyle containerStyle) {
        if (!hostConfig.getSupportsInteractivity()) {
            renderedCard.addWarning(new AdaptiveWarning(3, "Input.Number is not allowed"));
            return null;
        }
        NumberInput numberInput = null;
        if (baseCardElement instanceof NumberInput) {
            numberInput = (NumberInput)baseCardElement;
        } else {
            numberInput = NumberInput.dynamic_cast(baseCardElement);
            if (numberInput == null) {
                throw new InternalError("Unable to convert BaseCardElement to NumberInput object model.");
            }
        }
        NumberInputRenderer.setSpacingAndSeparator(context, viewGroup, numberInput.GetSpacing(), numberInput.GetSeparator(), hostConfig, true);
        TextInputHandler numberInputHandler = new TextInputHandler(numberInput);
        EditText editText = this.renderInternal(renderedCard, context, viewGroup, numberInput, String.valueOf(numberInput.GetValue()), String.valueOf(numberInput.GetPlaceholder()), numberInputHandler, hostConfig);
        editText.setInputType(8194);
        return editText;
    }
}

