/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.AdaptiveCard;
import io.adaptivecards.objectmodel.BaseActionElement;
import io.adaptivecards.objectmodel.BaseActionElementVector;
import io.adaptivecards.objectmodel.BaseCardElementVector;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.VerticalContentAlignment;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.GenericImageLoaderAsync;
import io.adaptivecards.renderer.IActionLayoutRenderer;
import io.adaptivecards.renderer.IOnlineImageLoader;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.action.ActionElementRenderer;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.http.HttpRequestResult;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class AdaptiveCardRenderer {
    public static final String VERSION = "1.1";
    private static AdaptiveCardRenderer s_instance = null;
    private IOnlineImageLoader m_onlineImageLoader = null;
    private HostConfig defaultHostConfig = new HostConfig();

    protected AdaptiveCardRenderer() {
    }

    public static AdaptiveCardRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new AdaptiveCardRenderer();
        }
        return s_instance;
    }

    public RenderedAdaptiveCard render(Context context, FragmentManager fragmentManager, AdaptiveCard adaptiveCard, ICardActionHandler cardActionHandler) {
        return this.render(context, fragmentManager, adaptiveCard, cardActionHandler, this.defaultHostConfig);
    }

    public RenderedAdaptiveCard render(Context context, FragmentManager fragmentManager, AdaptiveCard adaptiveCard, ICardActionHandler cardActionHandler, HostConfig hostConfig) {
        RenderedAdaptiveCard result = new RenderedAdaptiveCard(adaptiveCard);
        View cardView = this.internalRender(result, context, fragmentManager, adaptiveCard, cardActionHandler, hostConfig, false);
        result.setView(cardView);
        return result;
    }

    public View internalRender(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, AdaptiveCard adaptiveCard, ICardActionHandler cardActionHandler, HostConfig hostConfig, boolean isInlineShowCard) {
        BaseActionElement selectAction;
        if (hostConfig == null) {
            throw new IllegalArgumentException("hostConfig is null");
        }
        if (renderedCard == null) {
            throw new IllegalArgumentException("renderedCard is null");
        }
        LinearLayout rootLayout = new LinearLayout(context);
        rootLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        rootLayout.setOrientation(1);
        rootLayout.setFocusable(true);
        rootLayout.setFocusableInTouchMode(true);
        LinearLayout layout = new LinearLayout(context);
        layout.setTag((Object)adaptiveCard);
        if (adaptiveCard.GetHeight() == HeightType.Stretch) {
            layout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        } else {
            layout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        }
        VerticalContentAlignment contentAlignment = adaptiveCard.GetVerticalContentAlignment();
        switch (contentAlignment) {
            case Center: {
                layout.setGravity(16);
                break;
            }
            case Bottom: {
                layout.setGravity(80);
                break;
            }
            default: {
                layout.setGravity(48);
            }
        }
        layout.setOrientation(1);
        int padding = Util.dpToPixels(context, hostConfig.getSpacing().getPaddingSpacing());
        layout.setPadding(padding, padding, padding, padding);
        rootLayout.addView((View)layout);
        BaseCardElementVector baseCardElementList = adaptiveCard.GetBody();
        ContainerStyle style = ContainerStyle.Default;
        if (isInlineShowCard && hostConfig.getActions().getShowCard().getStyle() != ContainerStyle.None) {
            style = hostConfig.getActions().getShowCard().getStyle();
        }
        if (hostConfig.getAdaptiveCard().getAllowCustomStyle() && adaptiveCard.GetStyle() != ContainerStyle.None) {
            style = adaptiveCard.GetStyle();
        }
        String color = style == ContainerStyle.Default ? hostConfig.getContainerStyles().getDefaultPalette().getBackgroundColor() : hostConfig.getContainerStyles().getEmphasisPalette().getBackgroundColor();
        layout.setBackgroundColor(Color.parseColor((String)color));
        CardRendererRegistration.getInstance().render(renderedCard, context, fragmentManager, (ViewGroup)layout, adaptiveCard, baseCardElementList, cardActionHandler, hostConfig, style);
        if (hostConfig.getSupportsInteractivity()) {
            BaseActionElementVector baseActionElementList = adaptiveCard.GetActions();
            if (baseActionElementList != null && baseActionElementList.size() > 0L) {
                LinearLayout showCardsLayout = new LinearLayout(context);
                showCardsLayout.setBackgroundColor(Color.parseColor((String)color));
                showCardsLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
                rootLayout.addView((View)showCardsLayout);
                IActionLayoutRenderer actionLayoutRenderer = CardRendererRegistration.getInstance().getActionLayoutRenderer();
                if (actionLayoutRenderer != null) {
                    actionLayoutRenderer.renderActions(renderedCard, context, fragmentManager, (ViewGroup)layout, baseActionElementList, cardActionHandler, hostConfig);
                }
            }
        } else {
            renderedCard.addWarning(new AdaptiveWarning(3, "Interactivity is not allowed. Actions not rendered."));
        }
        String imageUrl = adaptiveCard.GetBackgroundImage();
        if (!imageUrl.isEmpty()) {
            BackgroundImageLoaderAsync loaderAsync = new BackgroundImageLoaderAsync(renderedCard, context, layout, hostConfig.getImageBaseUrl());
            IOnlineImageLoader onlineImageLoader = CardRendererRegistration.getInstance().getOnlineImageLoader();
            if (onlineImageLoader != null) {
                loaderAsync.registerCustomOnlineImageLoader(onlineImageLoader);
            }
            loaderAsync.execute(new String[]{imageUrl});
        }
        if ((selectAction = renderedCard.getAdaptiveCard().GetSelectAction()) != null) {
            rootLayout.setClickable(true);
            rootLayout.setOnClickListener((View.OnClickListener)new ActionElementRenderer.ButtonOnClickListener(renderedCard, selectAction, cardActionHandler));
        }
        return rootLayout;
    }

    private class BackgroundImageLoaderAsync
    extends GenericImageLoaderAsync {
        private Context m_context;
        private LinearLayout m_layout;

        public BackgroundImageLoaderAsync(RenderedAdaptiveCard renderedCard, Context context, LinearLayout layout, String imageBaseUrl) {
            super(renderedCard, imageBaseUrl);
            this.m_context = context;
            this.m_layout = layout;
        }

        protected HttpRequestResult<Bitmap> doInBackground(String ... args) {
            if (args.length == 0) {
                return null;
            }
            return this.loadImage(args[0], this.m_context);
        }

        @Override
        void onSuccessfulPostExecute(Bitmap bitmap) {
            BitmapDrawable background = new BitmapDrawable(this.m_context.getResources(), bitmap);
            this.m_layout.setBackground((Drawable)background);
            this.m_layout.bringChildToFront(this.m_layout.getChildAt(0));
        }
    }
}

