/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.ColorConfig;
import io.adaptivecards.objectmodel.ColorsConfig;
import io.adaptivecards.objectmodel.ForegroundColor;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Spacing;
import io.adaptivecards.objectmodel.SpacingConfig;
import io.adaptivecards.renderer.IBaseCardElementRenderer;
import io.adaptivecards.renderer.Util;

public abstract class BaseCardElementRenderer
implements IBaseCardElementRenderer {
    protected static long getSpacingSize(Spacing spacing, SpacingConfig defaultSpacingConfig) {
        long spacingSize = 0L;
        if (spacing == Spacing.None) {
            return 0L;
        }
        if (spacing == Spacing.Default) {
            spacingSize = defaultSpacingConfig.getDefaultSpacing();
        } else if (spacing == Spacing.ExtraLarge) {
            spacingSize = defaultSpacingConfig.getExtraLargeSpacing();
        } else if (spacing == Spacing.Large) {
            spacingSize = defaultSpacingConfig.getLargeSpacing();
        } else if (spacing == Spacing.Medium) {
            spacingSize = defaultSpacingConfig.getMediumSpacing();
        } else if (spacing == Spacing.Small) {
            spacingSize = defaultSpacingConfig.getSmallSpacing();
        } else if (spacing == Spacing.Padding) {
            spacingSize = defaultSpacingConfig.getPaddingSpacing();
        } else {
            throw new IllegalArgumentException("Unknown spacing style: " + spacing.toString());
        }
        return (int)spacingSize;
    }

    protected static int getColor(ForegroundColor color, ColorsConfig colorsConfig, boolean isSubtle) {
        ColorConfig colorConfig;
        if (color == ForegroundColor.Accent) {
            colorConfig = colorsConfig.getAccent();
        } else if (color == ForegroundColor.Attention) {
            colorConfig = colorsConfig.getAttention();
        } else if (color == ForegroundColor.Dark) {
            colorConfig = colorsConfig.getDark();
        } else if (color == ForegroundColor.Default) {
            colorConfig = colorsConfig.getDefaultColor();
        } else if (color == ForegroundColor.Good) {
            colorConfig = colorsConfig.getGood();
        } else if (color == ForegroundColor.Light) {
            colorConfig = colorsConfig.getLight();
        } else if (color == ForegroundColor.Warning) {
            colorConfig = colorsConfig.getWarning();
        } else {
            throw new IllegalArgumentException("Unknown color: " + color.toString());
        }
        return Color.parseColor((String)(isSubtle ? colorConfig.getSubtleColor() : colorConfig.getDefaultColor()));
    }

    protected static void setSpacingAndSeparator(Context context, ViewGroup viewGroup, Spacing spacing, boolean separator, HostConfig hostConfig, boolean horizontalLine, boolean isImageSet) {
        LinearLayout.LayoutParams params;
        if (viewGroup.getChildCount() <= 0) {
            return;
        }
        int spacingSize = Util.dpToPixels(context, BaseCardElementRenderer.getSpacingSize(spacing, hostConfig.getSpacing()));
        int separatorThickness = Util.dpToPixels(context, hostConfig.getSeparator().getLineThickness());
        int separatorColor = Color.parseColor((String)hostConfig.getSeparator().getLineColor());
        ImageView view = new ImageView(context);
        if (separator && separatorThickness > 0) {
            view.setBackgroundColor(separatorColor);
            params = new LinearLayout.LayoutParams(horizontalLine ? -1 : separatorThickness, horizontalLine ? separatorThickness : -1);
            params.setMargins(horizontalLine ? 0 : spacingSize / 2, horizontalLine ? spacingSize / 2 : 0, horizontalLine ? 0 : spacingSize / 2, horizontalLine ? spacingSize / 2 : 0);
        } else {
            params = new LinearLayout.LayoutParams(horizontalLine ? -1 : spacingSize, horizontalLine ? spacingSize : (isImageSet ? 0 : -1));
        }
        view.setLayoutParams((ViewGroup.LayoutParams)params);
        viewGroup.addView((View)view);
    }

    protected static void setSpacingAndSeparator(Context context, ViewGroup viewGroup, Spacing spacing, boolean separator, HostConfig hostConfig, boolean horizontalLine) {
        BaseCardElementRenderer.setSpacingAndSeparator(context, viewGroup, spacing, separator, hostConfig, horizontalLine, false);
    }
}

