/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.IOnlineImageLoader;
import io.adaptivecards.renderer.OnlineImageLoader;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.http.HttpRequestResult;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class GenericImageLoaderAsync
extends AsyncTask<String, Void, HttpRequestResult<Bitmap>> {
    RenderedAdaptiveCard m_renderedCard;
    String m_imageBaseUrl;
    IOnlineImageLoader m_onlineImageLoader = null;

    GenericImageLoaderAsync(RenderedAdaptiveCard renderedCard, String imageBaseUrl) {
        this.m_renderedCard = renderedCard;
        this.m_imageBaseUrl = imageBaseUrl;
        this.m_onlineImageLoader = new OnlineImageLoader();
    }

    HttpRequestResult<Bitmap> loadImage(String path, Context context) {
        try {
            try {
                return this.m_onlineImageLoader.loadOnlineImage(path, this);
            }
            catch (MalformedURLException e1) {
                try {
                    if (this.m_imageBaseUrl == null || this.m_imageBaseUrl.isEmpty()) {
                        throw new IOException("Image base URL is empty or not specified");
                    }
                    URL urlContext = new URL(this.m_imageBaseUrl);
                    URL url = new URL(urlContext, path);
                    return this.m_onlineImageLoader.loadOnlineImage(url.toString(), this);
                }
                catch (MalformedURLException e2) {
                    return this.loadLocalImage(this.m_imageBaseUrl, context, path);
                }
            }
        }
        catch (Exception e) {
            return new HttpRequestResult<Bitmap>(e);
        }
    }

    private HttpRequestResult<Bitmap> loadLocalImage(String imageBaseUrl, Context context, String url) throws IOException {
        String authority = context.getPackageName();
        Resources resources = context.getResources();
        int identifier = resources.getIdentifier(url, imageBaseUrl, authority);
        if (identifier == 0) {
            throw new IOException("Image not found: " + url);
        }
        InputStream ins = resources.openRawResource(identifier);
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)ins);
        if (bitmap == null) {
            throw new IOException("Failed to convert local content to bitmap: " + url);
        }
        return new HttpRequestResult<Bitmap>(bitmap);
    }

    protected Bitmap styleBitmap(Bitmap bitmap) {
        return bitmap;
    }

    protected void onPostExecute(HttpRequestResult<Bitmap> result) {
        if (result.isSuccessful()) {
            this.onSuccessfulPostExecute(result.getResult());
        } else {
            this.m_renderedCard.addWarning(new AdaptiveWarning(2, result.getException().getMessage()));
        }
    }

    public void registerCustomOnlineImageLoader(IOnlineImageLoader onlineImageLoader) {
        this.m_onlineImageLoader = onlineImageLoader;
    }

    abstract void onSuccessfulPostExecute(Bitmap var1);
}

