/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.os.AsyncTask;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.MediaSource;
import io.adaptivecards.renderer.http.HttpRequestHelper;
import io.adaptivecards.renderer.layout.FullscreenVideoView;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class MediaLoaderAsync
extends AsyncTask<String, Void, Void> {
    private FullscreenVideoView m_mediaView;
    private MediaSource m_mediaSource;
    private HostConfig m_hostConfig;
    private boolean m_isAudio;
    private Context m_context;

    public MediaLoaderAsync(FullscreenVideoView mediaPlayer, MediaSource mediaSource, HostConfig hostConfig, boolean isAudio, Context context) {
        this.m_mediaView = mediaPlayer;
        this.m_mediaSource = mediaSource;
        this.m_hostConfig = hostConfig;
        this.m_isAudio = isAudio;
        this.m_context = context;
    }

    protected Void doInBackground(String ... strings) {
        String mediaSourceUrl = this.m_mediaSource.GetUrl();
        try {
            try {
                HttpRequestHelper.query(mediaSourceUrl);
                this.m_mediaView.setVideoURI(Uri.parse((String)mediaSourceUrl), this.m_isAudio);
            }
            catch (MalformedURLException e1) {
                String baseUrl = this.m_hostConfig.getImageBaseUrl();
                try {
                    if (baseUrl == null || baseUrl.isEmpty()) {
                        throw new IOException("Image base URL is empty or not specified");
                    }
                    URL urlContext = new URL(baseUrl);
                    URL url = new URL(urlContext, mediaSourceUrl);
                    HttpRequestHelper.query(url.toString());
                    this.m_mediaView.setVideoURI(Uri.parse((String)(baseUrl + mediaSourceUrl)), this.m_isAudio);
                }
                catch (MalformedURLException e2) {
                    String authority = this.m_context.getPackageName();
                    Resources resources = this.m_context.getResources();
                    int identifier = resources.getIdentifier(mediaSourceUrl, baseUrl, authority);
                    if (identifier == 0) {
                        throw new IOException("Media not found: " + mediaSourceUrl);
                    }
                    this.m_mediaView.setVideoPath("android.resource://" + authority + "/" + baseUrl + "/" + mediaSourceUrl, this.m_isAudio);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

