/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import io.adaptivecards.renderer.GenericImageLoaderAsync;
import io.adaptivecards.renderer.IOnlineImageLoader;
import io.adaptivecards.renderer.http.HttpRequestHelper;
import io.adaptivecards.renderer.http.HttpRequestResult;
import java.io.IOException;
import java.net.URISyntaxException;

public class OnlineImageLoader
implements IOnlineImageLoader {
    @Override
    public HttpRequestResult<Bitmap> loadOnlineImage(String url, GenericImageLoaderAsync loader) throws IOException, URISyntaxException {
        byte[] bytes = HttpRequestHelper.get(url);
        if (bytes == null) {
            throw new IOException("Failed to retrieve content from " + url);
        }
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
        if ((bitmap = loader.styleBitmap(bitmap)) == null) {
            throw new IOException("Failed to convert content to bitmap: " + new String(bytes));
        }
        return new HttpRequestResult<Bitmap>(bitmap);
    }
}

