/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.action;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.app.FragmentManager;
import android.text.TextPaint;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.ActionAlignment;
import io.adaptivecards.objectmodel.ActionMode;
import io.adaptivecards.objectmodel.ActionType;
import io.adaptivecards.objectmodel.ActionsOrientation;
import io.adaptivecards.objectmodel.BaseActionElement;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.IconPlacement;
import io.adaptivecards.objectmodel.ShowCardAction;
import io.adaptivecards.renderer.AdaptiveCardRenderer;
import io.adaptivecards.renderer.IBaseActionElementRenderer;
import io.adaptivecards.renderer.InnerImageLoaderAsync;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;

public class ActionElementRenderer
implements IBaseActionElementRenderer {
    private static ActionElementRenderer s_instance = null;

    protected ActionElementRenderer() {
    }

    public static ActionElementRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ActionElementRenderer();
        }
        return s_instance;
    }

    public Button renderButton(Context context, ViewGroup viewGroup, BaseActionElement baseActionElement, HostConfig hostConfig, RenderedAdaptiveCard renderedCard) {
        LinearLayout.LayoutParams layoutParams;
        Button button = new Button(context);
        button.setText((CharSequence)baseActionElement.GetTitle());
        ActionAlignment alignment = hostConfig.getActions().getActionAlignment();
        ActionsOrientation orientation = hostConfig.getActions().getActionsOrientation();
        if (orientation == ActionsOrientation.Horizontal) {
            layoutParams = new LinearLayout.LayoutParams(-2, -1);
            long spacing = hostConfig.getActions().getButtonSpacing();
            layoutParams.rightMargin = Util.dpToPixels(context, spacing);
        } else {
            layoutParams = new LinearLayout.LayoutParams(-1, -1);
        }
        if (alignment == ActionAlignment.Stretch) {
            layoutParams.weight = 1.0f;
        }
        button.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        String iconUrl = baseActionElement.GetIconUrl();
        if (!iconUrl.isEmpty()) {
            ActionElementRendererIconImageLoaderAsync imageLoader = new ActionElementRendererIconImageLoaderAsync(renderedCard, (View)button, hostConfig.getImageBaseUrl(), hostConfig.getActions().getIconPlacement(), hostConfig.getActions().getIconSize());
            imageLoader.execute(new String[]{baseActionElement.GetIconUrl()});
            if (hostConfig.getActions().getIconPlacement() == IconPlacement.LeftOfTitle) {
                int padding = (int)hostConfig.getSpacing().getDefaultSpacing();
                ButtonOnLayoutChangedListener layoutChangedListener = new ButtonOnLayoutChangedListener();
                layoutChangedListener.setPadding(padding);
                button.addOnLayoutChangeListener((View.OnLayoutChangeListener)layoutChangedListener);
            }
        }
        viewGroup.addView((View)button);
        return button;
    }

    @Override
    public Button render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseActionElement baseActionElement, ICardActionHandler cardActionHandler, HostConfig hostConfig) {
        if (cardActionHandler == null) {
            throw new IllegalArgumentException("Action Handler is null.");
        }
        Button button = this.renderButton(context, viewGroup, baseActionElement, hostConfig, renderedCard);
        if (baseActionElement.GetElementType() == ActionType.ShowCard && hostConfig.getActions().getShowCard().getActionMode() == ActionMode.Inline) {
            ShowCardAction showCardAction = null;
            if (baseActionElement instanceof ShowCardAction) {
                showCardAction = (ShowCardAction)baseActionElement;
            } else {
                showCardAction = ShowCardAction.dynamic_cast(baseActionElement);
                if (showCardAction == null) {
                    throw new InternalError("Unable to convert BaseActionElement to ShowCardAction object model.");
                }
            }
            View invisibleCard = AdaptiveCardRenderer.getInstance().internalRender(renderedCard, context, fragmentManager, showCardAction.GetCard(), cardActionHandler, hostConfig, true);
            invisibleCard.setVisibility(8);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
            layoutParams.setMargins(0, Util.dpToPixels(context, hostConfig.getActions().getShowCard().getInlineTopMargin()), 0, 0);
            invisibleCard.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ViewGroup parent = (ViewGroup)viewGroup.getParent();
            parent = parent instanceof HorizontalScrollView ? (ViewGroup)parent.getParent().getParent() : (ViewGroup)parent.getParent();
            ViewGroup hiddenCards = (ViewGroup)parent.getChildAt(1);
            hiddenCards.addView(invisibleCard);
            button.setOnClickListener((View.OnClickListener)new ShowCardInlineClickListener(invisibleCard, hiddenCards));
        } else {
            button.setOnClickListener((View.OnClickListener)new ButtonOnClickListener(renderedCard, baseActionElement, cardActionHandler));
        }
        return button;
    }

    private class ActionElementRendererIconImageLoaderAsync
    extends InnerImageLoaderAsync {
        private IconPlacement m_iconPlacement;
        private long m_iconSize;

        protected ActionElementRendererIconImageLoaderAsync(RenderedAdaptiveCard renderedCard, View containerView, String imageBaseUrl, IconPlacement iconPlacement, long iconSize) {
            super(renderedCard, containerView, imageBaseUrl);
            this.m_iconPlacement = iconPlacement;
            this.m_iconSize = iconSize;
        }

        @Override
        protected Bitmap styleBitmap(Bitmap bitmap) {
            Button button = (Button)this.m_view;
            BitmapDrawable originalDrawableIcon = new BitmapDrawable(null, bitmap);
            double imageHeight = this.m_iconPlacement == IconPlacement.AboveTitle ? (double)this.m_iconSize : (double)button.getTextSize();
            double scaleRatio = imageHeight / (double)originalDrawableIcon.getIntrinsicHeight();
            double imageWidth = scaleRatio * (double)originalDrawableIcon.getIntrinsicWidth();
            return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)(imageWidth * 2.0)), (int)((int)(imageHeight * 2.0)), (boolean)false);
        }

        @Override
        protected void renderBitmap(Bitmap bitmap) {
            Button button = (Button)this.m_view;
            BitmapDrawable drawableIcon = new BitmapDrawable(null, bitmap);
            if (this.m_iconPlacement == IconPlacement.AboveTitle) {
                button.setCompoundDrawablesWithIntrinsicBounds(null, (Drawable)drawableIcon, null, null);
            } else {
                button.setCompoundDrawablesWithIntrinsicBounds((Drawable)drawableIcon, null, null, null);
                button.requestLayout();
            }
        }
    }

    protected class ShowCardInlineClickListener
    implements View.OnClickListener {
        private View m_invisibleCard;
        private ViewGroup m_hiddenCardsLayout;

        public ShowCardInlineClickListener(View invisibleCard, ViewGroup hiddenCardsLayout) {
            this.m_invisibleCard = invisibleCard;
            this.m_hiddenCardsLayout = hiddenCardsLayout;
        }

        private Activity getActivity(Context context) {
            while (context instanceof ContextWrapper) {
                if (context instanceof Activity) {
                    return (Activity)context;
                }
                context = ((ContextWrapper)context).getBaseContext();
            }
            return null;
        }

        public void onClick(View v) {
            View currentFocusedView;
            Activity hostingActivity = this.getActivity(v.getContext());
            if (hostingActivity != null && (currentFocusedView = hostingActivity.getCurrentFocus()) != null) {
                currentFocusedView.clearFocus();
            }
            v.setPressed(this.m_invisibleCard.getVisibility() != 0);
            for (int i = 0; i < this.m_hiddenCardsLayout.getChildCount(); ++i) {
                View child = this.m_hiddenCardsLayout.getChildAt(i);
                if (child == this.m_invisibleCard) continue;
                child.setVisibility(8);
            }
            this.m_invisibleCard.setVisibility(this.m_invisibleCard.getVisibility() == 0 ? 8 : 0);
            View mainCardView = ((ViewGroup)this.m_hiddenCardsLayout.getParent()).getChildAt(0);
            int padding = mainCardView.getPaddingTop();
            if (this.m_invisibleCard.getVisibility() == 0) {
                mainCardView.setPadding(padding, padding, padding, 0);
                this.m_invisibleCard.requestFocus();
            } else {
                mainCardView.setPadding(padding, padding, padding, padding);
            }
        }
    }

    public static class ButtonOnLayoutChangedListener
    implements View.OnLayoutChangeListener {
        private int mPadding;

        public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            Button button = (Button)v;
            double textHeight = button.getTextSize();
            Rect bounds = new Rect();
            String text = button.getText().toString().toUpperCase();
            TextPaint paint = button.getPaint();
            paint.setTextSize((float)textHeight);
            paint.getTextBounds(text, 0, text.length(), bounds);
            Drawable[] icons = button.getCompoundDrawables();
            if (icons[0] != null) {
                double iconWidth = icons[0].getIntrinsicWidth();
                double buttonWidth = button.getWidth();
                double boundsWidth = bounds.width();
                double iconStartPosition = (buttonWidth - (iconWidth + (double)this.mPadding + boundsWidth)) / 2.0;
                button.setCompoundDrawablePadding((int)(-iconStartPosition + (double)this.mPadding));
                button.setPadding((int)iconStartPosition, 0, 0, 0);
            }
        }

        void setPadding(int padding) {
            this.mPadding = padding;
        }
    }

    public static class ButtonOnClickListener
    implements View.OnClickListener {
        private BaseActionElement m_action;
        private RenderedAdaptiveCard m_renderedAdaptiveCard;
        private ICardActionHandler m_cardActionHandler;

        public ButtonOnClickListener(RenderedAdaptiveCard renderedCard, BaseActionElement action, ICardActionHandler cardActionHandler) {
            this.m_action = action;
            this.m_renderedAdaptiveCard = renderedCard;
            this.m_cardActionHandler = cardActionHandler;
        }

        public void onClick(View v) {
            this.m_cardActionHandler.onAction(this.m_action, this.m_renderedAdaptiveCard);
        }
    }
}

