/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.inputhandler;

import android.text.TextUtils;
import android.widget.CheckBox;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.objectmodel.ChoiceInputVector;
import io.adaptivecards.objectmodel.ChoiceSetInput;
import io.adaptivecards.renderer.inputhandler.BaseInputHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class CheckBoxSetInputHandler
extends BaseInputHandler {
    private List<CheckBox> m_checkBoxList;

    public CheckBoxSetInputHandler(BaseInputElement baseInputElement, List<CheckBox> checkBoxList) {
        super(baseInputElement);
        this.m_checkBoxList = checkBoxList;
    }

    protected List<CheckBox> getCheckBox() {
        return this.m_checkBoxList;
    }

    @Override
    public String getInput() {
        ChoiceSetInput choiceSetInput = (ChoiceSetInput)this.m_baseInputElement;
        Vector<String> resultList = new Vector<String>();
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        for (int index = 0; index < this.m_checkBoxList.size(); ++index) {
            if (!this.m_checkBoxList.get(index).isChecked()) continue;
            resultList.addElement(choiceInputVector.get(index).GetValue());
        }
        return TextUtils.join((CharSequence)",", resultList);
    }

    @Override
    public void setInput(String values) {
        ChoiceSetInput choiceSetInput = (ChoiceSetInput)this.m_baseInputElement;
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        if (values.isEmpty()) {
            int i = 0;
            while ((long)i < choiceInputVector.size()) {
                this.m_checkBoxList.get(i).setChecked(false);
                ++i;
            }
            return;
        }
        List<String> listValues = Arrays.asList(values.split(";"));
        int i = 0;
        while ((long)i < choiceInputVector.size()) {
            if (listValues.contains(choiceInputVector.get(i).GetValue())) {
                this.m_checkBoxList.get(i).setChecked(true);
            } else {
                this.m_checkBoxList.get(i).setChecked(false);
            }
            ++i;
        }
    }
}

