/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.Fact;
import io.adaptivecards.objectmodel.FactSet;
import io.adaptivecards.objectmodel.FactVector;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.TextConfig;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.readonly.DateTimeParser;
import io.adaptivecards.renderer.readonly.RendererUtil;
import io.adaptivecards.renderer.readonly.TextBlockRenderer;

public class FactSetRenderer
extends BaseCardElementRenderer {
    private static FactSetRenderer s_instance = null;

    protected FactSetRenderer() {
    }

    public static FactSetRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new FactSetRenderer();
        }
        return s_instance;
    }

    static TextView createTextView(Context context, CharSequence text, TextConfig textConfig, HostConfig hostConfig, long spacing, ContainerStyle containerStyle) {
        TextView textView = new TextView(context);
        textView.setText(text);
        TextBlockRenderer.setTextColor(textView, textConfig.getColor(), hostConfig, textConfig.getIsSubtle(), containerStyle);
        TextBlockRenderer.setTextSize(context, textView, textConfig.getSize(), hostConfig);
        TextBlockRenderer.getInstance().setTextFormat(textView, hostConfig.getFontFamily(), textConfig.getWeight());
        textView.setSingleLine(!textConfig.getWrap());
        textView.setMaxWidth(Util.dpToPixels(context, textConfig.getMaxWidth()));
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setPaddingRelative(0, 0, (int)spacing, 0);
        return textView;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, ContainerStyle containerStyle) {
        FactSet factSet = null;
        if (baseCardElement instanceof FactSet) {
            factSet = (FactSet)baseCardElement;
        } else {
            factSet = FactSet.dynamic_cast(baseCardElement);
            if (factSet == null) {
                throw new InternalError("Unable to convert BaseCardElement to FactSet object model.");
            }
        }
        FactSetRenderer.setSpacingAndSeparator(context, viewGroup, factSet.GetSpacing(), factSet.GetSeparator(), hostConfig, true);
        TableLayout tableLayout = new TableLayout(context);
        tableLayout.setTag((Object)factSet);
        tableLayout.setColumnShrinkable(1, true);
        HeightType height = factSet.GetHeight();
        if (height == HeightType.Stretch) {
            tableLayout.setLayoutParams((ViewGroup.LayoutParams)new TableLayout.LayoutParams(-2, -1, 1.0f));
        } else {
            tableLayout.setLayoutParams((ViewGroup.LayoutParams)new TableLayout.LayoutParams(-2, -2));
        }
        FactVector factVector = factSet.GetFacts();
        long factVectorSize = factVector.size();
        long spacing = hostConfig.getFactSet().getSpacing();
        int i = 0;
        while ((long)i < factVectorSize) {
            Fact fact = factVector.get(i);
            TableRow factRow = new TableRow(context);
            if (height == HeightType.Stretch) {
                factRow.setLayoutParams((ViewGroup.LayoutParams)new TableRow.LayoutParams(-1, -1, 1.0f));
            } else {
                factRow.setLayoutParams((ViewGroup.LayoutParams)new TableRow.LayoutParams(-1, -2));
            }
            DateTimeParser parser = new DateTimeParser(fact.GetLanguage());
            String titleWithFormattedDates = parser.GenerateString(fact.GetTitleForDateParsing());
            factRow.addView((View)FactSetRenderer.createTextView(context, RendererUtil.handleSpecialText(titleWithFormattedDates), hostConfig.getFactSet().getTitle(), hostConfig, spacing, containerStyle));
            String valueWithFormattedDates = parser.GenerateString(fact.GetValueForDateParsing());
            factRow.addView((View)FactSetRenderer.createTextView(context, RendererUtil.handleSpecialText(valueWithFormattedDates), hostConfig.getFactSet().getValue(), hostConfig, 0L, containerStyle));
            tableLayout.addView((View)factRow);
            ++i;
        }
        viewGroup.addView((View)tableLayout);
        return tableLayout;
    }
}

